/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.eventing.managers;

import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.eventing.filters.TopicBasedEventFilter;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.wso2.eventing.Event;
import org.wso2.eventing.Subscription;
import org.wso2.eventing.SubscriptionManager;
import org.wso2.eventing.exceptions.EventException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultInMemorySubscriptionManager
implements SubscriptionManager<MessageContext> {
    private final Map<String, Subscription> store = new ConcurrentHashMap<String, Subscription>();
    private String topicHeaderName;
    private String topicHeaderNS;
    private SynapseXPath topicXPath;
    private final Map<String, String> properties = new HashMap<String, String>();
    private static final Log log = LogFactory.getLog(DefaultInMemorySubscriptionManager.class);

    public List<Subscription> getStaticSubscriptions() {
        LinkedList<Subscription> list = new LinkedList<Subscription>();
        for (Subscription storeSubscription : this.store.values()) {
            if (!storeSubscription.isStaticEntry()) continue;
            list.add(storeSubscription);
        }
        return list;
    }

    public String subscribe(Subscription subscription) throws EventException {
        if (subscription.getId() == null) {
            subscription.setId(UUIDGenerator.getUUID());
        }
        this.store.put(subscription.getId(), subscription);
        return subscription.getId();
    }

    public boolean unsubscribe(String id) throws EventException {
        if (this.store.containsKey(id)) {
            this.store.remove(id);
            return true;
        }
        return false;
    }

    public boolean renew(Subscription subscription) throws EventException {
        Subscription subscriptionOld = this.getSubscription(subscription.getId());
        if (subscriptionOld != null) {
            subscriptionOld.setExpires(subscription.getExpires());
            return true;
        }
        return false;
    }

    public List<Subscription> getSubscriptions() throws EventException {
        LinkedList<Subscription> list = new LinkedList<Subscription>();
        for (Map.Entry<String, Subscription> stringSubscriptionEntry : this.store.entrySet()) {
            list.add(stringSubscriptionEntry.getValue());
        }
        return list;
    }

    public List<Subscription> getAllSubscriptions() throws EventException {
        LinkedList<Subscription> list = new LinkedList<Subscription>();
        for (Map.Entry<String, Subscription> stringSubscriptionEntry : this.store.entrySet()) {
            list.add(stringSubscriptionEntry.getValue());
        }
        return list;
    }

    public List<Subscription> getMatchingSubscriptions(Event<MessageContext> event) throws EventException {
        LinkedList<Subscription> list = new LinkedList<Subscription>();
        for (Map.Entry<String, Subscription> stringSubscriptionEntry : this.store.entrySet()) {
            TopicBasedEventFilter filter = new TopicBasedEventFilter();
            if (filter != null) {
                filter.setResultValue(stringSubscriptionEntry.getValue().getFilterValue());
                filter.setSourceXpath(this.topicXPath);
            }
            if (filter != null && !filter.match(event)) continue;
            Subscription subscription = stringSubscriptionEntry.getValue();
            Calendar current = Calendar.getInstance();
            if (subscription.getExpires() != null) {
                if (!current.before(subscription.getExpires())) continue;
                list.add(subscription);
                continue;
            }
            list.add(subscription);
        }
        return list;
    }

    public Subscription getSubscription(String id) {
        return this.store.get(id);
    }

    public Subscription getStatus(String s) throws EventException {
        return null;
    }

    public void init() {
        try {
            this.topicHeaderName = this.getPropertyValue("topicHeaderName");
            if (this.topicHeaderName == null) {
                this.handleException("Unable to create topic header topic header name is null");
            }
            this.topicHeaderNS = this.getPropertyValue("topicHeaderNS");
            if (this.topicHeaderNS == null) {
                this.handleException("Unable to create topic header topic header namespace is null");
            }
            this.topicXPath = new SynapseXPath("s11:Header/ns:" + this.topicHeaderName + " | s12:Header/ns:" + this.topicHeaderName);
            this.topicXPath.addNamespace("s11", "http://schemas.xmlsoap.org/soap/envelope/");
            this.topicXPath.addNamespace("s12", "http://www.w3.org/2003/05/soap-envelope");
            this.topicXPath.addNamespace("ns", this.topicHeaderNS);
        }
        catch (JaxenException e) {
            this.handleException("Unable to create the topic header XPath", (Exception)((Object)e));
        }
    }

    public void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public String getPropertyValue(String name) {
        return this.properties.get(name);
    }

    private void handleException(String message) {
        log.error((Object)message);
        throw new SynapseException(message);
    }

    private void handleException(String message, Exception e) {
        log.error((Object)message, (Throwable)e);
        throw new SynapseException(message, e);
    }
}

