/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.PropertyInclude;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.config.xml.MediatorPropertySerializer;
import org.apache.synapse.config.xml.endpoints.AddressEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.DefaultEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.DynamicLoadbalanceEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.config.xml.endpoints.FailoverEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.IndirectEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.LoadbalanceEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.ResolvingEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.SALoadbalanceEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.WSDLEndpointSerializer;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.AddressEndpoint;
import org.apache.synapse.endpoints.DefaultEndpoint;
import org.apache.synapse.endpoints.DynamicLoadbalanceEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.endpoints.FailoverEndpoint;
import org.apache.synapse.endpoints.IndirectEndpoint;
import org.apache.synapse.endpoints.LoadbalanceEndpoint;
import org.apache.synapse.endpoints.ResolvingEndpoint;
import org.apache.synapse.endpoints.SALoadbalanceEndpoint;
import org.apache.synapse.endpoints.WSDLEndpoint;
import org.apache.synapse.mediators.MediatorProperty;

public abstract class EndpointSerializer {
    private Log log = LogFactory.getLog(this.getClass());
    protected OMFactory fac;

    protected EndpointSerializer() {
    }

    public static OMElement getElementFromEndpoint(Endpoint endpoint) {
        EndpointSerializer endpointSerializer = EndpointSerializer.getEndpointSerializer(endpoint);
        OMElement elem = endpointSerializer.serializeEndpoint(endpoint);
        OMElement descriptionElem = endpointSerializer.getSerializedDescription(endpoint);
        if (descriptionElem != null) {
            elem.addChild((OMNode)descriptionElem);
        }
        return elem;
    }

    protected abstract OMElement serializeEndpoint(Endpoint var1);

    private OMElement getSerializedDescription(Endpoint endpoint) {
        OMElement descriptionElem = this.fac.createOMElement(new QName("http://ws.apache.org/ns/synapse", "description"));
        if (endpoint.getDescription() != null) {
            descriptionElem.setText(endpoint.getDescription());
            return descriptionElem;
        }
        return null;
    }

    protected void serializeCommonEndpointProperties(EndpointDefinition endpointDefinition, OMElement element) {
        OMElement errorCodes;
        if (endpointDefinition.getTraceState() == 1) {
            element.addAttribute(this.fac.createOMAttribute("trace", null, "enable"));
        } else if (endpointDefinition.getTraceState() == 0) {
            element.addAttribute(this.fac.createOMAttribute("trace", null, "disable"));
        }
        AspectConfiguration statisticsConfigurable = endpointDefinition.getAspectConfiguration();
        if (statisticsConfigurable != null && statisticsConfigurable.isStatisticsEnable()) {
            element.addAttribute(this.fac.createOMAttribute("statistics", null, "enable"));
        }
        if (endpointDefinition.isUseSwa()) {
            element.addAttribute(this.fac.createOMAttribute("optimize", null, "swa"));
        } else if (endpointDefinition.isUseMTOM()) {
            element.addAttribute(this.fac.createOMAttribute("optimize", null, "mtom"));
        }
        if (endpointDefinition.getCharSetEncoding() != null) {
            element.addAttribute(this.fac.createOMAttribute("encoding", null, endpointDefinition.getCharSetEncoding()));
        }
        if (endpointDefinition.isAddressingOn()) {
            OMElement addressing = this.fac.createOMElement("enableAddressing", SynapseConstants.SYNAPSE_OMNAMESPACE);
            if (endpointDefinition.getAddressingVersion() != null) {
                addressing.addAttribute(this.fac.createOMAttribute("version", null, endpointDefinition.getAddressingVersion()));
            }
            if (endpointDefinition.isUseSeparateListener()) {
                addressing.addAttribute(this.fac.createOMAttribute("separateListener", null, "true"));
            }
            element.addChild((OMNode)addressing);
        }
        if (endpointDefinition.isReliableMessagingOn()) {
            OMElement rm = this.fac.createOMElement("enableRM", SynapseConstants.SYNAPSE_OMNAMESPACE);
            if (endpointDefinition.getWsRMPolicyKey() != null) {
                rm.addAttribute(this.fac.createOMAttribute("policy", null, endpointDefinition.getWsRMPolicyKey()));
            }
            element.addChild((OMNode)rm);
        }
        if (endpointDefinition.isSecurityOn()) {
            OMElement sec = this.fac.createOMElement("enableSec", SynapseConstants.SYNAPSE_OMNAMESPACE);
            if (endpointDefinition.getWsSecPolicyKey() != null) {
                sec.addAttribute(this.fac.createOMAttribute("policy", null, endpointDefinition.getWsSecPolicyKey()));
            } else {
                if (endpointDefinition.getInboundWsSecPolicyKey() != null) {
                    sec.addAttribute(this.fac.createOMAttribute("inboundPolicy", null, endpointDefinition.getInboundWsSecPolicyKey()));
                }
                if (endpointDefinition.getOutboundWsSecPolicyKey() != null) {
                    sec.addAttribute(this.fac.createOMAttribute("outboundPolicy", null, endpointDefinition.getOutboundWsSecPolicyKey()));
                }
            }
            element.addChild((OMNode)sec);
        }
        if (endpointDefinition.getTimeoutAction() != 100 || endpointDefinition.getTimeoutDuration() > 0L) {
            OMElement timeout = this.fac.createOMElement("timeout", SynapseConstants.SYNAPSE_OMNAMESPACE);
            element.addChild((OMNode)timeout);
            OMElement duration = this.fac.createOMElement("duration", SynapseConstants.SYNAPSE_OMNAMESPACE);
            duration.setText(Long.toString(endpointDefinition.getTimeoutDuration()));
            timeout.addChild((OMNode)duration);
            OMElement action = this.fac.createOMElement("responseAction", SynapseConstants.SYNAPSE_OMNAMESPACE);
            if (endpointDefinition.getTimeoutAction() == 101) {
                action.setText("discard");
            } else if (endpointDefinition.getTimeoutAction() == 102) {
                action.setText("fault");
            }
            timeout.addChild((OMNode)action);
        }
        if (endpointDefinition.getInitialSuspendDuration() != -1L || !endpointDefinition.getSuspendErrorCodes().isEmpty()) {
            OMElement suspendOnFailure = this.fac.createOMElement("suspendOnFailure", SynapseConstants.SYNAPSE_OMNAMESPACE);
            if (!endpointDefinition.getSuspendErrorCodes().isEmpty()) {
                errorCodes = this.fac.createOMElement("errorCodes", SynapseConstants.SYNAPSE_OMNAMESPACE);
                errorCodes.setText(endpointDefinition.getSuspendErrorCodes().toString().replaceAll("[\\[\\] ]", ""));
                suspendOnFailure.addChild((OMNode)errorCodes);
            }
            if (endpointDefinition.getInitialSuspendDuration() != -1L) {
                OMElement initialDuration = this.fac.createOMElement("initialDuration", SynapseConstants.SYNAPSE_OMNAMESPACE);
                initialDuration.setText(Long.toString(endpointDefinition.getInitialSuspendDuration()));
                suspendOnFailure.addChild((OMNode)initialDuration);
            }
            if (endpointDefinition.getSuspendProgressionFactor() != -1.0f) {
                OMElement progressionFactor = this.fac.createOMElement("progressionFactor", SynapseConstants.SYNAPSE_OMNAMESPACE);
                progressionFactor.setText(Float.toString(endpointDefinition.getSuspendProgressionFactor()));
                suspendOnFailure.addChild((OMNode)progressionFactor);
            }
            if (endpointDefinition.getSuspendMaximumDuration() != -1L && endpointDefinition.getSuspendMaximumDuration() != Long.MAX_VALUE) {
                OMElement suspendMaximum = this.fac.createOMElement("maximumDuration", SynapseConstants.SYNAPSE_OMNAMESPACE);
                suspendMaximum.setText(Long.toString(endpointDefinition.getSuspendMaximumDuration()));
                suspendOnFailure.addChild((OMNode)suspendMaximum);
            }
            element.addChild((OMNode)suspendOnFailure);
        }
        if (endpointDefinition.getRetryDurationOnTimeout() > 0 || !endpointDefinition.getTimeoutErrorCodes().isEmpty()) {
            OMElement markAsTimedout = this.fac.createOMElement("markForSuspension", SynapseConstants.SYNAPSE_OMNAMESPACE);
            if (!endpointDefinition.getTimeoutErrorCodes().isEmpty()) {
                errorCodes = this.fac.createOMElement("errorCodes", SynapseConstants.SYNAPSE_OMNAMESPACE);
                errorCodes.setText(endpointDefinition.getTimeoutErrorCodes().toString().replaceAll("[\\[\\] ]", ""));
                markAsTimedout.addChild((OMNode)errorCodes);
            }
            if (endpointDefinition.getRetriesOnTimeoutBeforeSuspend() > 0) {
                OMElement retries = this.fac.createOMElement("retriesBeforeSuspension", SynapseConstants.SYNAPSE_OMNAMESPACE);
                retries.setText(Long.toString(endpointDefinition.getRetriesOnTimeoutBeforeSuspend()));
                markAsTimedout.addChild((OMNode)retries);
            }
            if (endpointDefinition.getRetryDurationOnTimeout() > 0) {
                OMElement retryDelay = this.fac.createOMElement("retryDelay", SynapseConstants.SYNAPSE_OMNAMESPACE);
                retryDelay.setText(Long.toString(endpointDefinition.getRetryDurationOnTimeout()));
                markAsTimedout.addChild((OMNode)retryDelay);
            }
            element.addChild((OMNode)markAsTimedout);
        }
        if (!endpointDefinition.getRetryDisabledErrorCodes().isEmpty()) {
            OMElement retryConfig = this.fac.createOMElement("retryConfig", SynapseConstants.SYNAPSE_OMNAMESPACE);
            errorCodes = this.fac.createOMElement("disabledErrorCodes", SynapseConstants.SYNAPSE_OMNAMESPACE);
            errorCodes.setText(endpointDefinition.getRetryDisabledErrorCodes().toString().replaceAll("[\\[\\] ]", ""));
            retryConfig.addChild((OMNode)errorCodes);
            element.addChild((OMNode)retryConfig);
        }
    }

    protected void serializeSpecificEndpointProperties(EndpointDefinition endpointDefinition, OMElement element) {
    }

    protected void handleException(String message) {
        this.log.error((Object)message);
        throw new SynapseException(message);
    }

    public static EndpointSerializer getEndpointSerializer(Endpoint endpoint) {
        if (endpoint instanceof AddressEndpoint) {
            return new AddressEndpointSerializer();
        }
        if (endpoint instanceof DefaultEndpoint) {
            return new DefaultEndpointSerializer();
        }
        if (endpoint instanceof WSDLEndpoint) {
            return new WSDLEndpointSerializer();
        }
        if (endpoint instanceof IndirectEndpoint) {
            return new IndirectEndpointSerializer();
        }
        if (endpoint instanceof ResolvingEndpoint) {
            return new ResolvingEndpointSerializer();
        }
        if (endpoint instanceof SALoadbalanceEndpoint) {
            return new SALoadbalanceEndpointSerializer();
        }
        if (endpoint instanceof DynamicLoadbalanceEndpoint) {
            return new DynamicLoadbalanceEndpointSerializer();
        }
        if (endpoint instanceof LoadbalanceEndpoint) {
            return new LoadbalanceEndpointSerializer();
        }
        if (endpoint instanceof FailoverEndpoint) {
            return new FailoverEndpointSerializer();
        }
        throw new SynapseException("Serializer for endpoint " + endpoint.getClass().toString() + " is not defined.");
    }

    protected void serializeCommonAttributes(Endpoint endpoint, OMElement element) {
        String messageStore;
        String name = endpoint.getName();
        boolean anon = ((AbstractEndpoint)endpoint).isAnonymous();
        if (name != null && !anon) {
            element.addAttribute("name", name, null);
        }
        if ((messageStore = endpoint.getOnFaultMessageStore()) != null) {
            element.addAttribute(EndpointFactory.ON_FAULT_Q.getLocalPart(), messageStore, null);
        }
    }

    protected void serializeProperties(PropertyInclude endpoint, OMElement element) {
        Collection<MediatorProperty> properties = endpoint.getProperties();
        if (properties != null && properties.size() > 0) {
            MediatorPropertySerializer.serializeMediatorProperties(element, properties);
        }
    }
}

