/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.util.UIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.PropertyInclude;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.XMLToObjectMapper;
import org.apache.synapse.config.xml.MediatorPropertyFactory;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.config.xml.endpoints.AddressEndpointFactory;
import org.apache.synapse.config.xml.endpoints.DefaultEndpointFactory;
import org.apache.synapse.config.xml.endpoints.DynamicLoadbalanceEndpointFactory;
import org.apache.synapse.config.xml.endpoints.FailoverEndpointFactory;
import org.apache.synapse.config.xml.endpoints.IndirectEndpointFactory;
import org.apache.synapse.config.xml.endpoints.LoadbalanceEndpointFactory;
import org.apache.synapse.config.xml.endpoints.ResolvingEndpointFactory;
import org.apache.synapse.config.xml.endpoints.SALoadbalanceEndpointFactory;
import org.apache.synapse.config.xml.endpoints.WSDLEndpointFactory;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.endpoints.IndirectEndpoint;
import org.apache.synapse.mediators.MediatorProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EndpointFactory
implements XMLToObjectMapper {
    static Log log;
    private static final String ENDPOINT_NAME_PREFIX = "endpoint_";
    public static final QName ON_FAULT_Q;
    private static final QName DESCRIPTION_Q;

    protected EndpointFactory() {
        log = LogFactory.getLog(this.getClass());
    }

    public static Endpoint getEndpointFromElement(OMElement elem, boolean isAnonymous, Properties properties) {
        return EndpointFactory.getEndpointFactory(elem).createEndpointWithName(elem, isAnonymous, properties);
    }

    @Override
    public Object getObjectFromOMNode(OMNode om, Properties properties) {
        if (om instanceof OMElement) {
            return this.createEndpointWithName((OMElement)om, false, properties);
        }
        EndpointFactory.handleException("Invalid XML configuration for an Endpoint. OMElement expected");
        return null;
    }

    protected abstract Endpoint createEndpoint(OMElement var1, boolean var2, Properties var3);

    private Endpoint createEndpointWithName(OMElement epConfig, boolean anonymousEndpoint, Properties properties) {
        OMAttribute onFaultAtt;
        Endpoint ep = this.createEndpoint(epConfig, anonymousEndpoint, properties);
        OMElement descriptionElem = epConfig.getFirstChildWithName(DESCRIPTION_Q);
        if (descriptionElem != null) {
            ep.setDescription(descriptionElem.getText());
        }
        if (anonymousEndpoint && ep.getName() == null) {
            String uuid = UIDGenerator.generateUID();
            uuid = uuid.replace(':', '_');
            ep.setName(ENDPOINT_NAME_PREFIX + uuid);
            if (ep instanceof AbstractEndpoint) {
                ((AbstractEndpoint)ep).setAnonymous(true);
            }
        }
        if ((onFaultAtt = epConfig.getAttribute(ON_FAULT_Q)) != null) {
            ep.setOnFaultMessageStore(onFaultAtt.getAttributeValue());
        }
        return ep;
    }

    protected void extractCommonEndpointProperties(EndpointDefinition definition, OMElement elem) {
        OMElement retryDisabledErrorCodes;
        OMElement retryConfig;
        OMElement suspendOnFailure;
        OMElement suspendDurationOnFailure;
        OMElement markAsTimedOut;
        OMElement timeout;
        OMElement wsRm;
        OMElement wsSec;
        OMElement wsAddr;
        OMAttribute optimize = elem.getAttribute(new QName("", "optimize"));
        OMAttribute encoding = elem.getAttribute(new QName("", "encoding"));
        OMAttribute trace = elem.getAttribute(new QName("", "trace"));
        if (trace != null && trace.getAttributeValue() != null) {
            String traceValue = trace.getAttributeValue();
            if ("enable".equals(traceValue)) {
                definition.setTraceState(1);
            } else if ("disable".equals(traceValue)) {
                definition.setTraceState(0);
            }
        } else {
            definition.setTraceState(2);
        }
        if (optimize != null && optimize.getAttributeValue().length() > 0) {
            String method = optimize.getAttributeValue().trim();
            if ("mtom".equalsIgnoreCase(method)) {
                definition.setUseMTOM(true);
            } else if ("swa".equalsIgnoreCase(method)) {
                definition.setUseSwa(true);
            }
        }
        if (encoding != null && encoding.getAttributeValue() != null) {
            definition.setCharSetEncoding(encoding.getAttributeValue());
        }
        if ((wsAddr = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "enableAddressing"))) != null) {
            String useSepList;
            definition.setAddressingOn(true);
            OMAttribute version = wsAddr.getAttribute(new QName("version"));
            if (version != null && version.getAttributeValue() != null) {
                String versionValue = version.getAttributeValue().trim().toLowerCase();
                if ("final".equals(versionValue) || "submission".equals(versionValue)) {
                    definition.setAddressingVersion(version.getAttributeValue());
                } else {
                    EndpointFactory.handleException("Unknown value for the addressing version. Possible values for the addressing version are 'final' and 'submission' only.");
                }
            }
            if ((useSepList = wsAddr.getAttributeValue(new QName("separateListener"))) != null && "true".equals(useSepList.trim().toLowerCase())) {
                definition.setUseSeparateListener(true);
            }
        }
        if ((wsSec = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "enableSec"))) != null) {
            definition.setSecurityOn(true);
            OMAttribute policyKey = wsSec.getAttribute(new QName("", "policy"));
            OMAttribute inboundPolicyKey = wsSec.getAttribute(new QName("", "inboundPolicy"));
            OMAttribute outboundPolicyKey = wsSec.getAttribute(new QName("", "outboundPolicy"));
            if (policyKey != null && policyKey.getAttributeValue() != null) {
                definition.setWsSecPolicyKey(policyKey.getAttributeValue());
            } else {
                if (inboundPolicyKey != null && inboundPolicyKey.getAttributeValue() != null) {
                    definition.setInboundWsSecPolicyKey(inboundPolicyKey.getAttributeValue());
                }
                if (outboundPolicyKey != null && outboundPolicyKey.getAttributeValue() != null) {
                    definition.setOutboundWsSecPolicyKey(outboundPolicyKey.getAttributeValue());
                }
            }
        }
        if ((wsRm = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "enableRM"))) != null) {
            definition.setReliableMessagingOn(true);
            OMAttribute policy = wsRm.getAttribute(new QName("", "policy"));
            if (policy != null) {
                definition.setWsRMPolicyKey(policy.getAttributeValue());
            }
        }
        if ((timeout = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "timeout"))) != null) {
            OMElement action;
            String d;
            OMElement duration = timeout.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "duration"));
            if (duration != null && (d = duration.getText()) != null) {
                try {
                    long timeoutMilliSeconds = Long.parseLong(d.trim());
                    definition.setTimeoutDuration(timeoutMilliSeconds);
                }
                catch (NumberFormatException e) {
                    EndpointFactory.handleException("Endpoint timeout duration expected as a number but was not a number");
                }
            }
            if ((action = timeout.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "responseAction"))) != null && action.getText() != null) {
                String actionString = action.getText();
                if ("discard".equalsIgnoreCase(actionString.trim())) {
                    definition.setTimeoutAction(101);
                    if (definition.getTimeoutDuration() == 0L) {
                        definition.setTimeoutDuration(30000L);
                    }
                } else if ("fault".equalsIgnoreCase(actionString.trim())) {
                    definition.setTimeoutAction(102);
                    if (definition.getTimeoutDuration() == 0L) {
                        definition.setTimeoutDuration(30000L);
                    }
                } else {
                    EndpointFactory.handleException("Invalid timeout action, action : " + actionString + " is not supported");
                }
            }
        }
        if ((markAsTimedOut = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "markForSuspension"))) != null) {
            OMElement retryDelay;
            OMElement retriesBeforeSuspend;
            OMElement timeoutCodes = markAsTimedOut.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "errorCodes"));
            if (timeoutCodes != null && timeoutCodes.getText() != null) {
                StringTokenizer st = new StringTokenizer(timeoutCodes.getText().trim(), ", ");
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    try {
                        definition.addTimeoutErrorCode(Integer.parseInt(s));
                    }
                    catch (NumberFormatException e) {
                        EndpointFactory.handleException("The timeout error codes should be specified as valid numbers separated by commas : " + timeoutCodes.getText(), e);
                    }
                }
            }
            if ((retriesBeforeSuspend = markAsTimedOut.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "retriesBeforeSuspension"))) != null && retriesBeforeSuspend.getText() != null) {
                try {
                    definition.setRetriesOnTimeoutBeforeSuspend(Integer.parseInt(retriesBeforeSuspend.getText().trim()));
                }
                catch (NumberFormatException e) {
                    EndpointFactory.handleException("The retries before suspend [for timeouts] should be specified as a valid number : " + retriesBeforeSuspend.getText(), e);
                }
            }
            if ((retryDelay = markAsTimedOut.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "retryDelay"))) != null && retryDelay.getText() != null) {
                try {
                    definition.setRetryDurationOnTimeout(Integer.parseInt(retryDelay.getText().trim()));
                }
                catch (NumberFormatException e) {
                    EndpointFactory.handleException("The retry delay for timeouts should be specified as a valid number : " + retryDelay.getText(), e);
                }
            }
        }
        if ((suspendDurationOnFailure = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "suspendDurationOnFailure"))) != null && suspendDurationOnFailure.getText() != null) {
            log.warn((Object)"Configuration uses deprecated style for endpoint 'suspendDurationOnFailure'");
            try {
                definition.setInitialSuspendDuration(1000L * Long.parseLong(suspendDurationOnFailure.getText().trim()));
                definition.setSuspendProgressionFactor(1.0f);
            }
            catch (NumberFormatException e) {
                EndpointFactory.handleException("The initial suspend duration should be specified as a valid number : " + suspendDurationOnFailure.getText(), e);
            }
        }
        if ((suspendOnFailure = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "suspendOnFailure"))) != null) {
            OMElement maximumDuration;
            OMElement progressionFactor;
            OMElement initialDuration;
            OMElement suspendCodes = suspendOnFailure.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "errorCodes"));
            if (suspendCodes != null && suspendCodes.getText() != null) {
                StringTokenizer st = new StringTokenizer(suspendCodes.getText().trim(), ", ");
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    try {
                        definition.addSuspendErrorCode(Integer.parseInt(s));
                    }
                    catch (NumberFormatException e) {
                        EndpointFactory.handleException("The suspend error codes should be specified as valid numbers separated by commas : " + suspendCodes.getText(), e);
                    }
                }
            }
            if ((initialDuration = suspendOnFailure.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "initialDuration"))) != null && initialDuration.getText() != null) {
                try {
                    definition.setInitialSuspendDuration(Integer.parseInt(initialDuration.getText().trim()));
                }
                catch (NumberFormatException e) {
                    EndpointFactory.handleException("The initial suspend duration should be specified as a valid number : " + initialDuration.getText(), e);
                }
            }
            if ((progressionFactor = suspendOnFailure.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "progressionFactor"))) != null && progressionFactor.getText() != null) {
                try {
                    definition.setSuspendProgressionFactor(Float.parseFloat(progressionFactor.getText().trim()));
                }
                catch (NumberFormatException e) {
                    EndpointFactory.handleException("The suspend duration progression factor should be specified as a valid float : " + progressionFactor.getText(), e);
                }
            }
            if ((maximumDuration = suspendOnFailure.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "maximumDuration"))) != null && maximumDuration.getText() != null) {
                try {
                    definition.setSuspendMaximumDuration(Long.parseLong(maximumDuration.getText().trim()));
                }
                catch (NumberFormatException e) {
                    EndpointFactory.handleException("The maximum suspend duration should be specified as a valid number : " + maximumDuration.getText(), e);
                }
            }
        }
        if ((retryConfig = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "retryConfig"))) != null && (retryDisabledErrorCodes = retryConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "disabledErrorCodes"))) != null && retryDisabledErrorCodes.getText() != null) {
            StringTokenizer st = new StringTokenizer(retryDisabledErrorCodes.getText().trim(), ", ");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                try {
                    definition.addRetryDisabledErrorCode(Integer.parseInt(s));
                }
                catch (NumberFormatException e) {
                    EndpointFactory.handleException("The suspend error codes should be specified as valid numbers separated by commas : " + retryDisabledErrorCodes.getText(), e);
                }
            }
        }
    }

    protected void extractSpecificEndpointProperties(EndpointDefinition definition, OMElement elem) {
    }

    private static EndpointFactory getEndpointFactory(OMElement configElement) {
        if (configElement.getAttribute(new QName("key")) != null) {
            return IndirectEndpointFactory.getInstance();
        }
        if (configElement.getAttribute(new QName("key-expression")) != null) {
            return ResolvingEndpointFactory.getInstance();
        }
        OMElement addressElement = configElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "address"));
        if (addressElement != null) {
            return AddressEndpointFactory.getInstance();
        }
        OMElement wsdlElement = configElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "wsdl"));
        if (wsdlElement != null) {
            return WSDLEndpointFactory.getInstance();
        }
        OMElement defaultElement = configElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "default"));
        if (defaultElement != null) {
            return DefaultEndpointFactory.getInstance();
        }
        OMElement lbElement = configElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "loadbalance"));
        if (lbElement != null) {
            OMElement sessionElement = configElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "session"));
            if (sessionElement != null) {
                return SALoadbalanceEndpointFactory.getInstance();
            }
            return LoadbalanceEndpointFactory.getInstance();
        }
        OMElement dlbElement = configElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "dynamicLoadbalance"));
        if (dlbElement != null) {
            return DynamicLoadbalanceEndpointFactory.getInstance();
        }
        OMElement foElement = configElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "failover"));
        if (foElement != null) {
            return FailoverEndpointFactory.getInstance();
        }
        EndpointFactory.handleException("Invalid endpoint configuration.");
        return null;
    }

    protected ArrayList<Endpoint> getEndpoints(OMElement listEndpointElement, Endpoint parent, Properties properties) {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        ArrayList<String> keys = new ArrayList<String>();
        Iterator iter = listEndpointElement.getChildrenWithName(XMLConfigConstants.ENDPOINT_ELT);
        while (iter.hasNext()) {
            OMElement endptElem = (OMElement)iter.next();
            Endpoint endpoint = EndpointFactory.getEndpointFromElement(endptElem, true, properties);
            if (endpoint instanceof IndirectEndpoint) {
                String key = ((IndirectEndpoint)endpoint).getKey();
                if (!keys.contains(key)) {
                    keys.add(key);
                } else {
                    EndpointFactory.handleException("Same endpoint definition cannot be used with in the siblings");
                }
            }
            endpoint.setParentEndpoint(parent);
            endpoints.add(endpoint);
        }
        return endpoints;
    }

    protected void processProperties(PropertyInclude endpoint, OMElement endpointElement) {
        List<MediatorProperty> properties = MediatorPropertyFactory.getMediatorProperties(endpointElement);
        if (properties != null && properties.size() > 0) {
            endpoint.addProperties(properties);
        }
    }

    protected static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    protected static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    static {
        ON_FAULT_Q = new QName("", "onFault");
        DESCRIPTION_Q = new QName("http://ws.apache.org/ns/synapse", "description");
    }
}

