/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.commons.evaluators.Evaluator;
import org.apache.synapse.commons.evaluators.EvaluatorException;
import org.apache.synapse.commons.evaluators.config.EvaluatorSerializer;
import org.apache.synapse.commons.evaluators.config.EvaluatorSerializerFinder;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.mediators.transform.url.RewriteAction;
import org.apache.synapse.mediators.transform.url.RewriteRule;
import org.apache.synapse.mediators.transform.url.URLRewriteMediator;

public class URLRewriteMediatorSerializer
extends AbstractMediatorSerializer {
    protected OMElement serializeSpecificMediator(Mediator m) {
        if (!(m instanceof URLRewriteMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
            return null;
        }
        URLRewriteMediator mediator = (URLRewriteMediator)m;
        OMElement rewrite = fac.createOMElement("rewrite", synNS);
        URLRewriteMediatorSerializer.saveTracingState(rewrite, mediator);
        List<RewriteRule> rules = mediator.getRules();
        try {
            for (RewriteRule r : rules) {
                OMElement rule = this.serializeRule(r);
                rewrite.addChild((OMNode)rule);
            }
        }
        catch (EvaluatorException e) {
            this.handleException("Error while serializing the rewrite rule", (Exception)((Object)e));
        }
        return rewrite;
    }

    private OMElement serializeRule(RewriteRule r) throws EvaluatorException {
        OMElement rule = fac.createOMElement("rule", synNS);
        Evaluator condition = r.getCondition();
        if (condition != null) {
            OMElement conditionElt = fac.createOMElement("condition", synNS);
            EvaluatorSerializer serializer = EvaluatorSerializerFinder.getInstance().getSerializer(condition.getName());
            serializer.serialize(conditionElt, condition);
            rule.addChild((OMNode)conditionElt);
        }
        List<RewriteAction> actions = r.getActions();
        for (RewriteAction a : actions) {
            OMElement action = this.serializeAction(a);
            rule.addChild((OMNode)action);
        }
        return rule;
    }

    private OMElement serializeAction(RewriteAction a) {
        String fragmentStr;
        String typeStr;
        OMElement action = fac.createOMElement("action", synNS);
        if (a.getValue() != null) {
            action.addAttribute("value", a.getValue(), null);
        } else if (a.getXpath() != null) {
            action.addAttribute("xpath", a.getXpath().toString(), null);
        }
        if (a.getRegex() != null) {
            action.addAttribute("regex", a.getRegex(), null);
        }
        int type = a.getActionType();
        switch (type) {
            case 1: {
                typeStr = "append";
                break;
            }
            case 2: {
                typeStr = "prepend";
                break;
            }
            case 3: {
                typeStr = "replace";
                break;
            }
            case 4: {
                typeStr = "remove";
                break;
            }
            default: {
                typeStr = "set";
            }
        }
        action.addAttribute("type", typeStr, null);
        int fragment = a.getFragmentIndex();
        switch (fragment) {
            case 0: {
                fragmentStr = "protocol";
                break;
            }
            case 1: {
                fragmentStr = "user";
                break;
            }
            case 2: {
                fragmentStr = "host";
                break;
            }
            case -1: {
                fragmentStr = "port";
                break;
            }
            case 3: {
                fragmentStr = "path";
                break;
            }
            case 4: {
                fragmentStr = "query";
                break;
            }
            case 5: {
                fragmentStr = "ref";
                break;
            }
            default: {
                fragmentStr = "full";
            }
        }
        action.addAttribute("fragment", fragmentStr, null);
        return action;
    }

    public String getMediatorClassName() {
        return URLRewriteMediator.class.getName();
    }
}

