/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Startup;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.XMLToObjectMapper;
import org.apache.synapse.config.xml.ConfigurationFactoryAndSerializerFinder;
import org.apache.synapse.config.xml.StartupFactory;
import org.apache.synapse.config.xml.StartupSerializer;
import org.apache.synapse.startup.quartz.SimpleQuartzFactory;
import sun.misc.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartupFinder
implements XMLToObjectMapper {
    private static final Log log = LogFactory.getLog(ConfigurationFactoryAndSerializerFinder.class);
    private static final StartupFinder instance = new StartupFinder();
    private static Map<QName, Class<? extends StartupFactory>> factoryMap = new HashMap<QName, Class<? extends StartupFactory>>();
    private static Map<QName, Class<? extends StartupSerializer>> serializerMap = new HashMap<QName, Class<? extends StartupSerializer>>();
    private static boolean initialized = false;
    private static final Class<?>[] builtins = new Class[]{SimpleQuartzFactory.class};

    public static synchronized StartupFinder getInstance() {
        if (!initialized) {
            StartupFinder.loadStartups();
        }
        return instance;
    }

    public static synchronized void reset() {
        factoryMap.clear();
        serializerMap.clear();
        initialized = false;
    }

    private StartupFinder() {
    }

    private static void loadStartups() {
        for (Class<?> builtin : builtins) {
            StartupFactory sf;
            if (builtin == null) continue;
            Class<StartupFactory> b = builtin.asSubclass(StartupFactory.class);
            try {
                sf = b.newInstance();
            }
            catch (Exception e) {
                throw new SynapseException("cannot instantiate " + b.getName(), e);
            }
            factoryMap.put(sf.getTagQName(), b);
            serializerMap.put(sf.getTagQName(), sf.getSerializerClass());
        }
        StartupFinder.registerExtensions();
        initialized = true;
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private static void registerExtensions() {
        Iterator it = Service.providers(StartupFactory.class);
        while (it.hasNext()) {
            StartupFactory sf = (StartupFactory)it.next();
            QName tag = sf.getTagQName();
            factoryMap.put(tag, sf.getClass());
            serializerMap.put(tag, sf.getSerializerClass());
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Added StartupFactory " + sf.getClass() + " to handle " + tag));
        }
    }

    public boolean isStartup(QName name) {
        return factoryMap.containsKey(name);
    }

    public Startup getStartup(OMElement element, Properties properties) {
        Class<? extends StartupFactory> cls;
        QName qName = element.getQName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating the Startup for : " + qName));
        }
        if ((cls = factoryMap.get(qName)) == null) {
            String msg = "Unknown Startup type referenced by startup element : " + qName;
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        try {
            StartupFactory sf = cls.newInstance();
            return sf.createStartup(element);
        }
        catch (InstantiationException e) {
            String msg = "Error initializing configuration factory : " + cls;
            log.error((Object)msg);
            throw new SynapseException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "Error initializing configuration factory : " + cls;
            log.error((Object)msg);
            throw new SynapseException(msg, e);
        }
    }

    public OMElement serializeStartup(OMElement parent, Startup startup) {
        Class<? extends StartupSerializer> cls = serializerMap.get(startup.getTagQName());
        if (cls == null) {
            String msg = "Unknown startup type referenced by startup element : " + startup.getTagQName();
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        try {
            StartupSerializer ss = cls.newInstance();
            return ss.serializeStartup(parent, startup);
        }
        catch (InstantiationException e) {
            String msg = "Error initializing startup serializer: " + cls;
            log.error((Object)msg);
            throw new SynapseException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "Error initializing startup ser: " + cls;
            log.error((Object)msg);
            throw new SynapseException(msg, e);
        }
    }

    public Map<QName, Class<? extends StartupFactory>> getFactoryMap() {
        return factoryMap;
    }

    public Map<QName, Class<? extends StartupSerializer>> getSerializerMap() {
        return serializerMap;
    }

    @Override
    public Startup getObjectFromOMNode(OMNode om, Properties properties) {
        if (om instanceof OMElement) {
            return this.getStartup((OMElement)om, properties);
        }
        this.handleException("Invalid configuration XML : " + om);
        return null;
    }
}

