/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.Startup;
import org.apache.synapse.commons.executors.PriorityExecutor;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.SynapseXMLConfigurationFactory;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.config.xml.XMLConfigurationBuilder;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.eventing.SynapseEventSource;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.message.store.MessageStore;

public class MultiXMLConfigurationBuilder {
    public static final String PROXY_SERVICES_DIR = "proxy-services";
    public static final String SEQUENCES_DIR = "sequences";
    public static final String ENDPOINTS_DIR = "endpoints";
    public static final String LOCAL_ENTRY_DIR = "local-entries";
    public static final String TASKS_DIR = "tasks";
    public static final String EVENTS_DIR = "event-sources";
    public static final String EXECUTORS_DIR = "priority-executors";
    public static final String MESSAGE_STORE_DIR = "message-stores";
    public static final String REGISTRY_FILE = "registry.xml";
    public static final String SEPARATE_REGISTRY_DEFINITION = "__separateRegDef";
    private static Log log = LogFactory.getLog(MultiXMLConfigurationBuilder.class);
    private static FileFilter filter = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getName().endsWith(".xml");
        }
    };

    public static SynapseConfiguration getConfiguration(String root, Properties properties) throws XMLStreamException {
        log.info((Object)("Building synapse configuration from the synapse artifact repository at : " + root));
        SynapseConfiguration synapseConfig = MultiXMLConfigurationBuilder.createConfigurationFromSynapseXML(root, properties);
        if (synapseConfig == null) {
            synapseConfig = SynapseConfigUtils.newConfiguration();
            synapseConfig.setDefaultQName(XMLConfigConstants.DEFINITIONS_ELT);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Found a synapse configuration in the synapse.xml file at the artifact repository root, which gets the precedence over other definitions");
        }
        if (synapseConfig.getRegistry() == null) {
            MultiXMLConfigurationBuilder.createRegistry(synapseConfig, root, properties);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Using the registry defined in the synapse.xml as the registry, any definitions in the registry.xml will be neglected");
        }
        MultiXMLConfigurationBuilder.createLocalEntries(synapseConfig, root, properties);
        MultiXMLConfigurationBuilder.createEndpoints(synapseConfig, root, properties);
        MultiXMLConfigurationBuilder.createSequences(synapseConfig, root, properties);
        MultiXMLConfigurationBuilder.createProxyServices(synapseConfig, root, properties);
        MultiXMLConfigurationBuilder.createTasks(synapseConfig, root, properties);
        MultiXMLConfigurationBuilder.createEventSources(synapseConfig, root, properties);
        MultiXMLConfigurationBuilder.createExecutors(synapseConfig, root, properties);
        MultiXMLConfigurationBuilder.createMessageStores(synapseConfig, root, properties);
        return synapseConfig;
    }

    private static SynapseConfiguration createConfigurationFromSynapseXML(String rootDirPath, Properties properties) throws XMLStreamException {
        File synapseXML = new File(rootDirPath, "synapse.xml");
        if (synapseXML.exists() && synapseXML.isFile()) {
            try {
                return XMLConfigurationBuilder.getConfiguration(new FileInputStream(synapseXML), properties);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private static void createRegistry(SynapseConfiguration synapseConfig, String rootDirPath, Properties properties) throws XMLStreamException {
        File registryDef = new File(rootDirPath, REGISTRY_FILE);
        if (registryDef.exists() && registryDef.isFile()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Initializing Synapse registry from the configuration at : " + registryDef.getPath()));
            }
            try {
                OMElement document = MultiXMLConfigurationBuilder.parseFile(registryDef);
                SynapseXMLConfigurationFactory.defineRegistry(synapseConfig, document, properties);
                synapseConfig.setProperty(SEPARATE_REGISTRY_DEFINITION, String.valueOf(Boolean.TRUE));
            }
            catch (FileNotFoundException ignored) {
                // empty catch block
            }
        }
    }

    private static void createLocalEntries(SynapseConfiguration synapseConfig, String rootDirPath, Properties properties) throws XMLStreamException {
        File localEntriesDir = new File(rootDirPath, LOCAL_ENTRY_DIR);
        if (localEntriesDir.exists()) {
            File[] entryDefinitions;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading local entry definitions from : " + localEntriesDir.getPath()));
            }
            for (File file : entryDefinitions = localEntriesDir.listFiles(filter)) {
                try {
                    OMElement document = MultiXMLConfigurationBuilder.parseFile(file);
                    Entry entry = SynapseXMLConfigurationFactory.defineEntry(synapseConfig, document, properties);
                    entry.setFileName(file.getName());
                    synapseConfig.getArtifactDeploymentStore().addArtifact(file.getAbsolutePath(), entry.getKey());
                }
                catch (FileNotFoundException ignored) {
                    // empty catch block
                }
            }
        }
    }

    private static void createProxyServices(SynapseConfiguration synapseConfig, String rootDirPath, Properties properties) throws XMLStreamException {
        File proxyServicesDir = new File(rootDirPath, PROXY_SERVICES_DIR);
        if (proxyServicesDir.exists()) {
            File[] proxyDefinitions;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading proxy services from : " + proxyServicesDir.getPath()));
            }
            for (File file : proxyDefinitions = proxyServicesDir.listFiles(filter)) {
                try {
                    OMElement document = MultiXMLConfigurationBuilder.parseFile(file);
                    ProxyService proxy = SynapseXMLConfigurationFactory.defineProxy(synapseConfig, document, properties);
                    proxy.setFileName(file.getName());
                    synapseConfig.getArtifactDeploymentStore().addArtifact(file.getAbsolutePath(), proxy.getName());
                }
                catch (FileNotFoundException ignored) {
                    // empty catch block
                }
            }
        }
    }

    private static void createTasks(SynapseConfiguration synapseConfig, String rootDirPath, Properties properties) throws XMLStreamException {
        File tasksDir = new File(rootDirPath, TASKS_DIR);
        if (tasksDir.exists()) {
            File[] taskDefinitions;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading tasks from : " + tasksDir.getPath()));
            }
            for (File file : taskDefinitions = tasksDir.listFiles(filter)) {
                try {
                    OMElement document = MultiXMLConfigurationBuilder.parseFile(file);
                    Startup startup = SynapseXMLConfigurationFactory.defineStartup(synapseConfig, document, properties);
                    startup.setFileName(file.getName());
                    synapseConfig.getArtifactDeploymentStore().addArtifact(file.getAbsolutePath(), startup.getName());
                }
                catch (FileNotFoundException ignored) {
                    // empty catch block
                }
            }
        }
    }

    private static void createSequences(SynapseConfiguration synapseConfig, String rootDirPath, Properties properties) throws XMLStreamException {
        File sequencesDir = new File(rootDirPath, SEQUENCES_DIR);
        if (sequencesDir.exists()) {
            File[] sequences;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading sequences from : " + sequencesDir.getPath()));
            }
            for (File file : sequences = sequencesDir.listFiles(filter)) {
                try {
                    OMElement document = MultiXMLConfigurationBuilder.parseFile(file);
                    Mediator seq = SynapseXMLConfigurationFactory.defineSequence(synapseConfig, document, properties);
                    if (!(seq instanceof SequenceMediator)) continue;
                    SequenceMediator sequence = (SequenceMediator)seq;
                    sequence.setFileName(file.getName());
                    synapseConfig.getArtifactDeploymentStore().addArtifact(file.getAbsolutePath(), sequence.getName());
                }
                catch (FileNotFoundException ignored) {
                    // empty catch block
                }
            }
        }
    }

    private static void createEndpoints(SynapseConfiguration synapseConfig, String rootDirPath, Properties properties) throws XMLStreamException {
        File endpointsDir = new File(rootDirPath, ENDPOINTS_DIR);
        if (endpointsDir.exists()) {
            File[] endpoints;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading endpoints from : " + endpointsDir.getPath()));
            }
            for (File file : endpoints = endpointsDir.listFiles(filter)) {
                try {
                    OMElement document = MultiXMLConfigurationBuilder.parseFile(file);
                    Endpoint endpoint = SynapseXMLConfigurationFactory.defineEndpoint(synapseConfig, document, properties);
                    endpoint.setFileName(file.getName());
                    synapseConfig.getArtifactDeploymentStore().addArtifact(file.getAbsolutePath(), endpoint.getName());
                }
                catch (FileNotFoundException ignored) {
                    // empty catch block
                }
            }
        }
    }

    private static void createEventSources(SynapseConfiguration synapseConfig, String rootDirPath, Properties properties) throws XMLStreamException {
        File eventsDir = new File(rootDirPath, EVENTS_DIR);
        if (eventsDir.exists()) {
            File[] events;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading event sources from : " + eventsDir.getPath()));
            }
            for (File file : events = eventsDir.listFiles(filter)) {
                try {
                    OMElement document = MultiXMLConfigurationBuilder.parseFile(file);
                    SynapseEventSource eventSource = SynapseXMLConfigurationFactory.defineEventSource(synapseConfig, document, properties);
                    eventSource.setFileName(file.getName());
                    synapseConfig.getArtifactDeploymentStore().addArtifact(file.getAbsolutePath(), eventSource.getName());
                }
                catch (FileNotFoundException ignored) {
                    // empty catch block
                }
            }
        }
    }

    private static void createExecutors(SynapseConfiguration synapseConfig, String rootDirPath, Properties properties) throws XMLStreamException {
        File eventsDir = new File(rootDirPath, EXECUTORS_DIR);
        if (eventsDir.exists()) {
            File[] events;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading event sources from : " + eventsDir.getPath()));
            }
            for (File file : events = eventsDir.listFiles(filter)) {
                try {
                    OMElement document = MultiXMLConfigurationBuilder.parseFile(file);
                    PriorityExecutor executor = SynapseXMLConfigurationFactory.defineExecutor(synapseConfig, document, properties);
                    executor.setFileName(file.getName());
                    synapseConfig.getArtifactDeploymentStore().addArtifact(file.getAbsolutePath(), executor.getName());
                }
                catch (FileNotFoundException ignored) {
                    // empty catch block
                }
            }
        }
    }

    private static void createMessageStores(SynapseConfiguration synapseConfig, String rootDirPath, Properties properties) throws XMLStreamException {
        File messageStoresDir = new File(rootDirPath, MESSAGE_STORE_DIR);
        if (messageStoresDir.exists()) {
            File[] messageStores;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading Message Stores from :" + messageStoresDir.getPath()));
            }
            for (File file : messageStores = messageStoresDir.listFiles(filter)) {
                try {
                    OMElement document = MultiXMLConfigurationBuilder.parseFile(file);
                    MessageStore messageStore = SynapseXMLConfigurationFactory.defineMessageStore(synapseConfig, document, properties);
                    messageStore.setFileName(file.getName());
                    synapseConfig.getArtifactDeploymentStore().addArtifact(file.getAbsolutePath(), messageStore.getName());
                }
                catch (FileNotFoundException ignored) {
                    // empty catch block
                }
            }
        }
    }

    private static OMElement parseFile(File file) throws FileNotFoundException, XMLStreamException {
        FileInputStream is = new FileInputStream(file);
        OMElement document = new StAXOMBuilder((InputStream)is).getDocumentElement();
        document.build();
        return document;
    }
}

