/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.message.store.InMemoryMessageStore;
import org.apache.synapse.message.store.MessageStore;

public class MessageStoreSerializer {
    private static final Log log = LogFactory.getLog(MessageStoreSerializer.class);
    protected static final OMFactory fac = OMAbstractFactory.getOMFactory();
    protected static final OMNamespace synNS = SynapseConstants.SYNAPSE_OMNAMESPACE;
    protected static final OMNamespace nullNS = fac.createOMNamespace("", "");

    public static OMElement serializeMessageStore(OMElement parent, MessageStore messageStore) {
        OMElement store = fac.createOMElement("messageStore", synNS);
        if (messageStore.getProviderClass() != null) {
            if (!messageStore.getProviderClass().equals(InMemoryMessageStore.class.getName())) {
                store.addAttribute(fac.createOMAttribute("class", nullNS, messageStore.getProviderClass()));
            }
        } else {
            MessageStoreSerializer.handleException("Invalid MessageStore. Provider is required");
        }
        if (messageStore.getSequence() != null) {
            store.addAttribute(fac.createOMAttribute("sequence", nullNS, messageStore.getSequence()));
        }
        if (messageStore.getName() != null) {
            store.addAttribute(fac.createOMAttribute("name", nullNS, messageStore.getName()));
        } else {
            MessageStoreSerializer.handleException("Message store Name not specified");
        }
        OMElement redilevery = fac.createOMElement("redelivery", synNS);
        int reDeliveryDelay = messageStore.getRedeliveryProcessor().getRedeliveryDelay() / 1000;
        OMElement delay = fac.createOMElement("interval", synNS);
        delay.setText(String.valueOf(reDeliveryDelay));
        redilevery.addChild((OMNode)delay);
        int maxRedeliveries = messageStore.getRedeliveryProcessor().getMaxRedeleveries();
        OMElement maxRedeliveryElm = fac.createOMElement("maximumRedeliveries", synNS);
        maxRedeliveryElm.setText(String.valueOf(maxRedeliveries));
        redilevery.addChild((OMNode)maxRedeliveryElm);
        if (messageStore.getRedeliveryProcessor().isExponentialBackoffEnable()) {
            OMElement expBOElm = fac.createOMElement("exponentialBackoff", synNS);
            expBOElm.setText("true");
            redilevery.addChild((OMNode)expBOElm);
            OMElement multiplierElm = fac.createOMElement("backoffMutiplier", synNS);
            int multiplier = messageStore.getRedeliveryProcessor().getBackOffMultiplier();
            if (multiplier > 0) {
                multiplierElm.setText(String.valueOf(multiplier));
                redilevery.addChild((OMNode)multiplierElm);
            }
        }
        store.addChild((OMNode)redilevery);
        if (messageStore.getParameters() != null) {
            for (String name : messageStore.getParameters().keySet()) {
                String value = (String)messageStore.getParameters().get(name);
                OMElement property = fac.createOMElement("parameter", synNS);
                property.addAttribute(fac.createOMAttribute("name", nullNS, name));
                property.setText(value.trim());
                store.addChild((OMNode)property);
            }
        }
        if (MessageStoreSerializer.getSerializedDescription(messageStore) != null) {
            store.addChild((OMNode)MessageStoreSerializer.getSerializedDescription(messageStore));
        }
        if (parent != null) {
            parent.addChild((OMNode)store);
        }
        return store;
    }

    private static OMElement getSerializedDescription(MessageStore messageStore) {
        OMElement descriptionElem = fac.createOMElement(new QName("http://ws.apache.org/ns/synapse", "description"));
        if (messageStore.getDescription() != null) {
            descriptionElem.setText(messageStore.getDescription());
            return descriptionElem;
        }
        return null;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

