/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractListMediatorFactory;
import org.apache.synapse.config.xml.AnonymousListMediator;
import org.apache.synapse.config.xml.AnonymousListMediatorFactory;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.mediators.filters.FilterMediator;
import org.jaxen.JaxenException;

public class FilterMediatorFactory
extends AbstractListMediatorFactory {
    private static final QName FILTER_Q = new QName("http://ws.apache.org/ns/synapse", "filter");
    private static final QName THEN_Q = new QName("http://ws.apache.org/ns/synapse", "then");
    private static final QName ELSE_Q = new QName("http://ws.apache.org/ns/synapse", "else");

    protected Mediator createSpecificMediator(OMElement elem, Properties properties) {
        FilterMediator filter = new FilterMediator();
        OMAttribute attXpath = elem.getAttribute(ATT_XPATH);
        OMAttribute attSource = elem.getAttribute(ATT_SOURCE);
        OMAttribute attRegex = elem.getAttribute(ATT_REGEX);
        if (attXpath != null) {
            if (attXpath.getAttributeValue() != null && attXpath.getAttributeValue().trim().length() == 0) {
                this.handleException("Invalid attribute value specified for xpath");
            } else {
                try {
                    filter.setXpath(SynapseXPathFactory.getSynapseXPath(elem, ATT_XPATH));
                }
                catch (JaxenException e) {
                    this.handleException("Invalid XPath expression for attribute xpath : " + attXpath.getAttributeValue(), (Exception)((Object)e));
                }
            }
        } else if (attSource != null && attRegex != null) {
            if (attSource.getAttributeValue() != null && attSource.getAttributeValue().trim().length() == 0 || attRegex.getAttributeValue() != null && attRegex.getAttributeValue().trim().length() == 0) {
                this.handleException("Invalid attribute values for source and/or regex specified");
            } else {
                try {
                    filter.setSource(SynapseXPathFactory.getSynapseXPath(elem, ATT_SOURCE));
                }
                catch (JaxenException e) {
                    this.handleException("Invalid XPath expression for attribute source : " + attSource.getAttributeValue(), (Exception)((Object)e));
                }
                try {
                    filter.setRegex(Pattern.compile(attRegex.getAttributeValue()));
                }
                catch (PatternSyntaxException pse) {
                    this.handleException("Invalid Regular Expression for attribute regex : " + attRegex.getAttributeValue(), pse);
                }
            }
        } else {
            this.handleException("An xpath or (source, regex) attributes are required for a filter");
        }
        this.processAuditStatus(filter, elem);
        OMElement thenElem = elem.getFirstChildWithName(THEN_Q);
        if (thenElem != null) {
            filter.setThenElementPresent(true);
            OMAttribute sequenceAttr = thenElem.getAttribute(ATT_SEQUENCE);
            if (sequenceAttr != null && sequenceAttr.getAttributeValue() != null) {
                filter.setThenKey(sequenceAttr.getAttributeValue());
            } else {
                FilterMediatorFactory.addChildren(thenElem, filter, properties);
            }
            OMElement elseElem = elem.getFirstChildWithName(ELSE_Q);
            if (elseElem != null) {
                sequenceAttr = elseElem.getAttribute(ATT_SEQUENCE);
                if (sequenceAttr != null && sequenceAttr.getAttributeValue() != null) {
                    filter.setElseKey(sequenceAttr.getAttributeValue());
                } else {
                    AnonymousListMediator listMediator = AnonymousListMediatorFactory.createAnonymousListMediator(elseElem, properties);
                    filter.setElseMediator(listMediator);
                }
            }
        } else {
            filter.setThenElementPresent(false);
            FilterMediatorFactory.addChildren(elem, filter, properties);
        }
        return filter;
    }

    public QName getTagQName() {
        return FILTER_Q;
    }
}

