/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.mediators.ext.ClassMediator;

public class ClassMediatorSerializer
extends AbstractMediatorSerializer {
    protected OMElement serializeSpecificMediator(Mediator m) {
        if (!(m instanceof ClassMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        ClassMediator mediator = (ClassMediator)m;
        OMElement clazz = fac.createOMElement("class", synNS);
        ClassMediatorSerializer.saveTracingState(clazz, mediator);
        if (mediator.getMediator() != null && mediator.getMediator().getClass().getName() != null) {
            clazz.addAttribute(fac.createOMAttribute("name", nullNS, mediator.getMediator().getClass().getName()));
        } else {
            this.handleException("Invalid class mediator. The class name is required");
        }
        for (String propName : mediator.getProperties().keySet()) {
            Object o = mediator.getProperties().get(propName);
            OMElement prop = fac.createOMElement(PROP_Q, (OMContainer)clazz);
            prop.addAttribute(fac.createOMAttribute("name", nullNS, propName));
            if (o instanceof String) {
                prop.addAttribute(fac.createOMAttribute("value", nullNS, (String)o));
            } else {
                prop.addChild((OMNode)o);
            }
            clazz.addChild((OMNode)prop);
        }
        return clazz;
    }

    public String getMediatorClassName() {
        return ClassMediator.class.getName();
    }
}

