/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.statistics.view;

import java.util.ArrayList;
import java.util.List;
import org.apache.synapse.aspects.statistics.ErrorLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Statistics {
    public static final String ALL = "all";
    private long maxProcessingTime = 0L;
    private long minProcessingTime = -1L;
    private double avgProcessingTime = 0.0;
    private double totalProcessingTime;
    private int count = 0;
    private int faultCount = 0;
    private String id;
    private final List<ErrorLog> errorLogs = new ArrayList<ErrorLog>();

    public Statistics(String id) {
        this.id = id;
    }

    public void update(long currentProcessingTime, boolean isFault) {
        if (currentProcessingTime < 0L) {
            return;
        }
        ++this.count;
        if (isFault) {
            ++this.faultCount;
        }
        if (this.maxProcessingTime < currentProcessingTime) {
            this.maxProcessingTime = currentProcessingTime;
        }
        if (this.minProcessingTime > currentProcessingTime) {
            this.minProcessingTime = currentProcessingTime;
        }
        if (this.minProcessingTime == -1L) {
            this.minProcessingTime = currentProcessingTime;
        }
        this.totalProcessingTime += (double)currentProcessingTime;
        this.avgProcessingTime = this.totalProcessingTime / (double)this.count;
    }

    public long getMaxProcessingTime() {
        return this.maxProcessingTime;
    }

    public double getAvgProcessingTime() {
        return this.avgProcessingTime;
    }

    public long getMinProcessingTime() {
        return this.minProcessingTime;
    }

    public int getFaultCount() {
        return this.faultCount;
    }

    public int getCount() {
        return this.count;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<ErrorLog> getErrorLogs() {
        return this.errorLogs;
    }

    public void addErrorLog(ErrorLog errorLog) {
        if (errorLog != null) {
            this.errorLogs.add(errorLog);
        }
    }

    public String toString() {
        return new StringBuffer().append("[Avg Processing Time : ").append(this.avgProcessingTime).append(" ]").append(" [Max Processing Time : ").append(this.maxProcessingTime).append(" ]").append(" [Min Processing Time : ").append(this.minProcessingTime).append(" ]").append(" [Total Request Count : ").append(this.count).append(" ]").append(" [Total Fault Response Count : ").append(this.faultCount).append(" ]").toString();
    }
}

