/*
 * Decompiled with CFR 0.152.
 */
package samples.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import samples.util.SampleAxis2ServerManager;

public class SampleAxis2Server {
    private static final Log log = LogFactory.getLog(SampleAxis2Server.class);

    public static void main(String[] args) throws Exception {
        SampleAxis2Server.startServer(args);
        SampleAxis2Server.addShutdownHook();
    }

    private static void addShutdownHook() {
        Thread shutdownHook = new Thread(){

            public void run() {
                log.info((Object)"Shutting down SimpleAxisServer ...");
                try {
                    SampleAxis2Server.stopServer();
                    log.info((Object)"Shutdown complete");
                    log.info((Object)"Halting JVM");
                }
                catch (Exception e) {
                    log.warn((Object)("Error occurred while shutting down SimpleAxisServer : " + e));
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    public static void startServer(String[] args) throws Exception {
        SampleAxis2ServerManager.getInstance().start(args);
    }

    public static void stopServer() throws Exception {
        SampleAxis2ServerManager.getInstance().stop();
    }
}

