/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.yaml;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.RubyYAML;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jvyamlb.Representer;
import org.jvyamlb.ResolverImpl;
import org.jvyamlb.SafeRepresenterImpl;
import org.jvyamlb.Serializer;
import org.jvyamlb.YAMLConfig;
import org.jvyamlb.YAMLNodeCreator;
import org.jvyamlb.nodes.MappingNode;
import org.jvyamlb.nodes.Node;
import org.jvyamlb.nodes.ScalarNode;

public class JRubyRepresenter
extends SafeRepresenterImpl {
    public JRubyRepresenter(Serializer serializer, YAMLConfig opts) {
        super(serializer, opts);
    }

    protected YAMLNodeCreator getNodeCreatorFor(Object data) {
        if (data instanceof YAMLNodeCreator) {
            return (YAMLNodeCreator)data;
        }
        if (data instanceof IRubyObject) {
            return new IRubyObjectYAMLNodeCreator(data);
        }
        return super.getNodeCreatorFor(data);
    }

    public Node map(String tag, Map mapping, Object flowStyle) throws IOException {
        if (null == flowStyle) {
            return this.map(tag, mapping, false);
        }
        return this.map(tag, mapping, true);
    }

    public Node seq(String tag, List sequence, Object flowStyle) throws IOException {
        if (sequence instanceof RubyArray) {
            sequence = ((RubyArray)sequence).getList();
        }
        if (null == flowStyle) {
            return this.seq(tag, sequence, false);
        }
        return this.seq(tag, sequence, true);
    }

    public Node scalar(String tag, String val, String style) throws IOException {
        return this.scalar(tag, ByteList.create(val), style);
    }

    public Node scalar(String tag, ByteList val, String style) throws IOException {
        if (null == style || style.length() == 0) {
            return this.scalar(tag, val, '\u0000');
        }
        return this.scalar(tag, val, style.charAt(0));
    }

    public Node representMapping(String tag, Map mapping, boolean flowStyle) throws IOException {
        Iterator iter;
        HashMap<Node, Node> value2 = new HashMap<Node, Node>();
        Iterator iterator = iter = mapping instanceof RubyHash ? ((RubyHash)mapping).directEntrySet().iterator() : mapping.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            value2.put(this.representData(entry.getKey()), this.representData(entry.getValue()));
        }
        return new MappingNode(tag, value2, flowStyle);
    }

    protected boolean ignoreAliases(Object data) {
        return data instanceof IRubyObject && ((IRubyObject)data).isNil() || super.ignoreAliases(data);
    }

    public static class IRubyObjectYAMLNodeCreator
    implements YAMLNodeCreator {
        private final IRubyObject data;
        private final RubyClass outClass;

        public IRubyObjectYAMLNodeCreator(Object data) {
            this.data = (IRubyObject)data;
            this.outClass = (RubyClass)((RubyModule)this.data.getRuntime().getModule("YAML").getConstant("JvYAML")).getConstant("Node");
        }

        public String taguri() {
            return this.data.callMethod(this.data.getRuntime().getCurrentContext(), "taguri").toString();
        }

        public Node toYamlNode(Representer representer) throws IOException {
            Ruby runtime2 = this.data.getRuntime();
            ThreadContext context = runtime2.getCurrentContext();
            if (this.data.getMetaClass().searchMethod("to_yaml") == runtime2.getObjectToYamlMethod() || this.data.getMetaClass().searchMethod("to_yaml").isUndefined()) {
                IRubyObject val = this.data.callMethod(context, "to_yaml_node", JavaEmbedUtils.javaToRuby(runtime2, representer));
                if (val instanceof Node) {
                    return (Node)((Object)val);
                }
                if (val instanceof IRubyObject) {
                    return (Node)JavaEmbedUtils.rubyToJava(val);
                }
            } else {
                IRubyObject val = this.data.callMethod(context, "to_yaml", JavaEmbedUtils.javaToRuby(runtime2, representer));
                if (!this.outClass.isInstance(val)) {
                    if (val instanceof RubyString && ((RubyString)val).getByteList().length() > 4) {
                        IRubyObject newObj = RubyYAML.load(this.data, val);
                        if (newObj instanceof RubyHash) {
                            return ((JRubyRepresenter)representer).map("tag:yaml.org,2002:map", (Map)((RubyHash)newObj), null);
                        }
                        if (newObj instanceof RubyArray) {
                            return ((JRubyRepresenter)representer).seq("tag:yaml.org,2002:seq", (List)((RubyArray)newObj), null);
                        }
                        ByteList bl = ((RubyString)val).getByteList();
                        int subst = 4;
                        if (bl.get(4) == 10) {
                            ++subst;
                        }
                        int len = bl.length() - subst - 1;
                        ResolverImpl res = new ResolverImpl();
                        res.descendResolver(null, null);
                        String detectedTag = res.resolve(ScalarNode.class, bl.makeShared(subst, len), new boolean[]{true, false});
                        return ((JRubyRepresenter)representer).scalar(detectedTag, bl.makeShared(subst, len), null);
                    }
                    throw runtime2.newTypeError("wrong argument type " + val.getMetaClass().getRealClass() + " (expected YAML::JvYAML::Node)");
                }
                IRubyObject value2 = val.callMethod(context, "value");
                IRubyObject style = val.callMethod(context, "style");
                IRubyObject type_id = val.callMethod(context, "type_id");
                String s = null;
                if (!style.isNil()) {
                    s = style.toString();
                }
                String t = type_id.toString();
                if (value2 instanceof RubyHash) {
                    return ((JRubyRepresenter)representer).map(t, (Map)((RubyHash)value2), s);
                }
                if (value2 instanceof RubyArray) {
                    return ((JRubyRepresenter)representer).seq(t, (List)((RubyArray)value2), s);
                }
                return ((JRubyRepresenter)representer).scalar(t, ((RubyString)value2).getByteList(), s);
            }
            return null;
        }
    }
}

