/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class JRubyObjectInputStream
extends RubyObject {
    JRubyObjectInputStreamImpl impl;
    private static final ObjectAllocator JROIS_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new JRubyObjectInputStream(runtime2, klass);
        }
    };

    public static RubyClass createJRubyObjectInputStream(Ruby runtime2) {
        RubyClass result = runtime2.defineClass("JRubyObjectInputStream", runtime2.getObject(), JROIS_ALLOCATOR);
        result.defineAnnotatedMethods(JRubyObjectInputStream.class);
        return result;
    }

    @JRubyMethod(name={"new"}, rest=true, meta=true)
    public static IRubyObject newInstance(IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject obj = ((RubyClass)recv2).allocate();
        obj.callMethod(recv2.getRuntime().getCurrentContext(), "initialize", args2, block);
        return obj;
    }

    public JRubyObjectInputStream(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    @JRubyMethod(name={"initialize"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject wrappedStream) throws IOException {
        InputStream stream = (InputStream)JavaUtil.convertRubyToJava(wrappedStream, InputStream.class);
        this.impl = new JRubyObjectInputStreamImpl(this.getRuntime(), stream);
        return this;
    }

    @JRubyMethod(name={"read_object"}, alias={"readObject"})
    public IRubyObject readObject() throws IOException, ClassNotFoundException {
        return JavaObject.wrap(this.getRuntime(), this.impl.readObject());
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() throws IOException {
        this.impl.close();
        return this;
    }

    class JRubyObjectInputStreamImpl
    extends ObjectInputStream {
        protected Ruby runtime;

        public JRubyObjectInputStreamImpl(Ruby rt, InputStream in) throws IOException {
            super(in);
            this.runtime = rt;
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            return Class.forName(desc.getName(), true, this.runtime.getJRubyClassLoader());
        }
    }
}

