/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.math.BigInteger;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Convert;
import org.jruby.util.TypeConverter;

public class Sprintf {
    private static final int FLAG_NONE = 0;
    private static final int FLAG_SPACE = 1;
    private static final int FLAG_ZERO = 2;
    private static final int FLAG_PLUS = 4;
    private static final int FLAG_MINUS = 8;
    private static final int FLAG_SHARP = 16;
    private static final int FLAG_WIDTH = 32;
    private static final int FLAG_PRECISION = 64;
    private static final byte[] PREFIX_OCTAL = new byte[]{48};
    private static final byte[] PREFIX_HEX_LC = new byte[]{48, 120};
    private static final byte[] PREFIX_HEX_UC = new byte[]{48, 88};
    private static final byte[] PREFIX_BINARY_LC = new byte[]{48, 98};
    private static final byte[] PREFIX_BINARY_UC = new byte[]{48, 66};
    private static final byte[] PREFIX_NEGATIVE = new byte[]{46, 46};
    private static final byte[] NAN_VALUE = new byte[]{78, 97, 78};
    private static final byte[] INFINITY_VALUE = new byte[]{73, 110, 102};
    private static final BigInteger BIG_32 = BigInteger.valueOf(0x100000000L);
    private static final BigInteger BIG_64 = BIG_32.shiftLeft(32);
    private static final BigInteger BIG_MINUS_32 = BigInteger.valueOf(-4294967296L);
    private static final BigInteger BIG_MINUS_64 = BIG_MINUS_32.shiftLeft(32);
    private static final String ERR_MALFORMED_FORMAT = "malformed format string";
    private static final String ERR_MALFORMED_NUM = "malformed format string - %[0-9]";
    private static final String ERR_MALFORMED_DOT_NUM = "malformed format string - %.[0-9]";
    private static final String ERR_MALFORMED_STAR_NUM = "malformed format string - %*[0-9]";
    private static final String ERR_ILLEGAL_FORMAT_CHAR = "illegal format character - %";

    private Sprintf() {
    }

    public static boolean sprintf(ByteList to, Locale locale, CharSequence format, IRubyObject args2) {
        return Sprintf.rubySprintfToBuffer(to, format, new Args(locale, args2));
    }

    public static boolean sprintf1_9(ByteList to, Locale locale, CharSequence format, IRubyObject args2) {
        return Sprintf.rubySprintfToBuffer(to, format, new Args(locale, args2), false);
    }

    public static boolean sprintf(ByteList to, CharSequence format, IRubyObject args2) {
        return Sprintf.rubySprintf(to, format, new Args(args2));
    }

    public static boolean sprintf(Ruby runtime2, ByteList to, CharSequence format, int arg2) {
        return Sprintf.rubySprintf(to, format, new Args(runtime2, arg2));
    }

    public static boolean sprintf(ByteList to, RubyString format, IRubyObject args2) {
        return Sprintf.rubySprintf(to, format.getByteList(), new Args(args2));
    }

    private static boolean rubySprintf(ByteList to, CharSequence charFormat, Args args2) {
        return Sprintf.rubySprintfToBuffer(to, charFormat, args2);
    }

    private static boolean rubySprintfToBuffer(ByteList buf, CharSequence charFormat, Args args2) {
        return Sprintf.rubySprintfToBuffer(buf, charFormat, args2, true);
    }

    /*
     * Unable to fully structure code
     */
    private static boolean rubySprintfToBuffer(ByteList buf, CharSequence charFormat, Args args, boolean usePrefixForZero) {
        tainted = false;
        if (charFormat instanceof ByteList) {
            list = (ByteList)charFormat;
            format = list.unsafeBytes();
            offset = begin = list.begin();
            length = begin + list.length();
            start = begin;
            mark = begin;
        } else {
            format = Sprintf.stringToBytes(charFormat, false);
            offset = 0;
            length = charFormat.length();
            start = 0;
            mark = 0;
        }
        while (offset < length) {
            start = offset;
            while (offset < length && format[offset] != 37) {
                ++offset;
            }
            if (offset > start) {
                buf.append(format, start, offset - start);
                start = offset;
            }
            if (offset++ >= length) break;
            arg = null;
            flags = 0;
            width = 0;
            precision = 0;
            number = 0;
            fchar = 0;
            incomplete = true;
            block59: while (incomplete && offset < length) {
                fchar = format[offset];
                switch (fchar) {
                    default: {
                        if (fchar == 0 && flags == 0) {
                            buf.append(37);
                            buf.append(fchar);
                            incomplete = false;
                            ++offset;
                            continue block59;
                        }
                        if (Sprintf.isPrintable(fchar)) {
                            Sprintf.raiseArgumentError(args, "malformed format string - %" + (char)fchar);
                            continue block59;
                        }
                        Sprintf.raiseArgumentError(args, "malformed format string");
                        continue block59;
                    }
                    case 32: {
                        flags |= 1;
                        ++offset;
                        continue block59;
                    }
                    case 48: {
                        flags |= 2;
                        ++offset;
                        continue block59;
                    }
                    case 43: {
                        flags |= 4;
                        ++offset;
                        continue block59;
                    }
                    case 45: {
                        flags |= 8;
                        ++offset;
                        continue block59;
                    }
                    case 35: {
                        flags |= 16;
                        ++offset;
                        continue block59;
                    }
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        number = 0;
                        while (offset < length && Sprintf.isDigit(fchar = format[offset])) {
                            number = Sprintf.extendWidth(args, number, fchar);
                            ++offset;
                        }
                        Sprintf.checkOffset(args, offset, length, "malformed format string - %[0-9]");
                        if (fchar == 36) {
                            if (arg != null) {
                                Sprintf.raiseArgumentError(args, "value given twice - " + number + "$");
                            }
                            arg = args.getNth(number);
                            ++offset;
                            continue block59;
                        }
                        width = number;
                        flags |= 32;
                        continue block59;
                    }
                    case 42: {
                        if ((flags & 32) != 0) {
                            Sprintf.raiseArgumentError(args, "width given twice");
                        }
                        flags |= 32;
                        Sprintf.checkOffset(args, ++offset, length, "malformed format string - %*[0-9]");
                        mark = offset;
                        number = 0;
                        while (offset < length && Sprintf.isDigit(fchar = format[offset])) {
                            number = Sprintf.extendWidth(args, number, fchar);
                            ++offset;
                        }
                        Sprintf.checkOffset(args, offset, length, "malformed format string - %*[0-9]");
                        if (fchar == 36) {
                            width = args.getNthInt(number);
                            if (width < 0) {
                                flags |= 8;
                                width = -width;
                            }
                            ++offset;
                            continue block59;
                        }
                        width = args.nextInt();
                        if (width < 0) {
                            flags |= 8;
                            width = -width;
                        }
                        offset = mark;
                        continue block59;
                    }
                    case 46: {
                        if ((flags & 64) != 0) {
                            Sprintf.raiseArgumentError(args, "precision given twice");
                        }
                        flags |= 64;
                        Sprintf.checkOffset(args, ++offset, length, "malformed format string - %.[0-9]");
                        fchar = format[offset];
                        if (fchar == 42) {
                            Sprintf.checkOffset(args, ++offset, length, "malformed format string - %*[0-9]");
                            mark = offset;
                            number = 0;
                            while (offset < length && Sprintf.isDigit(fchar = format[offset])) {
                                number = Sprintf.extendWidth(args, number, fchar);
                                ++offset;
                            }
                            Sprintf.checkOffset(args, offset, length, "malformed format string - %*[0-9]");
                            if (fchar == 36) {
                                precision = args.getNthInt(number);
                                if (precision < 0) {
                                    flags &= -65;
                                }
                                ++offset;
                                continue block59;
                            }
                            precision = args.nextInt();
                            if (precision < 0) {
                                flags &= -65;
                            }
                            offset = mark;
                            continue block59;
                        }
                        number = 0;
                        while (offset < length && Sprintf.isDigit(fchar = format[offset])) {
                            number = Sprintf.extendWidth(args, number, fchar);
                            ++offset;
                        }
                        Sprintf.checkOffset(args, offset, length, "malformed format string - %.[0-9]");
                        precision = number;
                        continue block59;
                    }
                    case 10: {
                        --offset;
                    }
                    case 37: {
                        if (flags != 0) {
                            Sprintf.raiseArgumentError(args, "illegal format character - %");
                        }
                        buf.append(37);
                        ++offset;
                        incomplete = false;
                        continue block59;
                    }
                    case 99: {
                        if (arg == null) {
                            arg = args.next();
                        }
                        c = 0;
                        if (arg instanceof RubyString) {
                            bytes = ((RubyString)arg).getByteList();
                            if (bytes.length() == 1) {
                                c = bytes.unsafeBytes()[bytes.begin()];
                            } else {
                                Sprintf.raiseArgumentError(args, "%c requires a character");
                            }
                        } else {
                            c = args.intValue(arg);
                        }
                        if ((flags & 32) != 0 && width > 1) {
                            if ((flags & 8) != 0) {
                                buf.append(c);
                                buf.fill(32, width - 1);
                            } else {
                                buf.fill(32, width - 1);
                                buf.append(c);
                            }
                        } else {
                            buf.append(c);
                        }
                        ++offset;
                        incomplete = false;
                        continue block59;
                    }
                    case 112: 
                    case 115: {
                        if (arg == null) {
                            arg = args.next();
                        }
                        if (fchar == 112) {
                            arg = arg.callMethod(arg.getRuntime().getCurrentContext(), "inspect");
                        }
                        bytes = arg.asString().getByteList();
                        len = bytes.length();
                        if (arg.isTaint()) {
                            tainted = true;
                        }
                        if ((flags & 64) != 0 && precision < len) {
                            len = precision;
                        }
                        if ((flags & 32) != 0 && width > len) {
                            width -= len;
                            if ((flags & 8) != 0) {
                                buf.append(bytes.unsafeBytes(), bytes.begin(), len);
                                buf.fill(32, width);
                            } else {
                                buf.fill(32, width);
                                buf.append(bytes.unsafeBytes(), bytes.begin(), len);
                            }
                        } else {
                            buf.append(bytes.unsafeBytes(), bytes.begin(), len);
                        }
                        ++offset;
                        incomplete = false;
                        continue block59;
                    }
                    case 66: 
                    case 88: 
                    case 98: 
                    case 100: 
                    case 105: 
                    case 111: 
                    case 117: 
                    case 120: {
                        if (arg == null) {
                            arg = args.next();
                        }
                        if ((type = arg.getMetaClass().index) != 1 && type != 2) {
                            switch (type) {
                                case 11: {
                                    arg = RubyNumeric.dbl2num(arg.getRuntime(), ((RubyFloat)arg).getValue());
                                    break;
                                }
                                case 4: {
                                    arg = RubyNumeric.str2inum(arg.getRuntime(), (RubyString)arg, 0, true);
                                    break;
                                }
                                default: {
                                    arg = arg.respondsTo("to_int") != false ? TypeConverter.convertToType(arg, arg.getRuntime().getInteger(), "to_int", true) : TypeConverter.convertToType(arg, arg.getRuntime().getInteger(), "to_i", true);
                                }
                            }
                            type = arg.getMetaClass().index;
                        }
                        bytes = null;
                        first = 0;
                        prefix = null;
                        signChar = 0;
                        leadChar = 0;
                        if (fchar == 105) {
                            fchar = 100;
                        }
                        if (fchar == 117 && (flags & 5) != 0) {
                            fchar = 100;
                        }
                        sign = fchar == 100 || (flags & 5) != 0;
                        switch (fchar) {
                            case 111: {
                                base = 8;
                                break;
                            }
                            case 88: 
                            case 120: {
                                base = 16;
                                break;
                            }
                            case 66: 
                            case 98: {
                                base = 2;
                                break;
                            }
                            default: {
                                base = 10;
                            }
                        }
                        if (type == 1) {
                            negative = ((RubyFixnum)arg).getLongValue() < 0L;
                            v0 = zero = ((RubyFixnum)arg).getLongValue() == 0L;
                            bytes = negative && fchar == 117 ? (Object)Sprintf.getUnsignedNegativeBytes((RubyFixnum)arg) : (Object)Sprintf.getFixnumBytes((RubyFixnum)arg, base, sign, fchar == 88);
                        } else {
                            negative = ((RubyBignum)arg).getValue().signum() < 0;
                            zero = ((RubyBignum)arg).getValue().equals(BigInteger.ZERO);
                            bytes = negative != false && fchar == 117 ? (Object)Sprintf.getUnsignedNegativeBytes((RubyBignum)arg) : (Object)Sprintf.getBignumBytes((RubyBignum)arg, base, sign, fchar == 88);
                        }
                        if ((flags & 16) != 0) {
                            if (!zero || usePrefixForZero) {
                                switch (fchar) {
                                    case 111: {
                                        prefix = Sprintf.PREFIX_OCTAL;
                                        break;
                                    }
                                    case 120: {
                                        prefix = Sprintf.PREFIX_HEX_LC;
                                        break;
                                    }
                                    case 88: {
                                        prefix = Sprintf.PREFIX_HEX_UC;
                                        break;
                                    }
                                    case 98: {
                                        prefix = Sprintf.PREFIX_BINARY_LC;
                                        break;
                                    }
                                    case 66: {
                                        prefix = Sprintf.PREFIX_BINARY_UC;
                                    }
                                }
                            }
                            if (prefix != null) {
                                width -= prefix.length;
                            }
                        }
                        len = 0;
                        if (sign) {
                            if (negative) {
                                signChar = 45;
                                --width;
                                first = 1;
                            } else if ((flags & 4) != 0) {
                                signChar = 43;
                                --width;
                            } else if ((flags & 1) != 0) {
                                signChar = 32;
                                --width;
                            }
                        } else if (negative) {
                            if (base == 10) {
                                Sprintf.warning(IRubyWarnings.ID.NEGATIVE_NUMBER_FOR_U, args, "negative number for %u specifier");
                                leadChar = 46;
                                len += 2;
                            } else {
                                if ((flags & 66) == 0) {
                                    len += 2;
                                }
                                first = Sprintf.skipSignBits((byte[])bytes, base);
                                switch (fchar) {
                                    case 66: 
                                    case 98: {
                                        leadChar = 49;
                                        break;
                                    }
                                    case 111: {
                                        leadChar = 55;
                                        break;
                                    }
                                    case 120: {
                                        leadChar = 102;
                                        break;
                                    }
                                    case 88: {
                                        leadChar = 70;
                                    }
                                }
                                if (leadChar != 0) {
                                    ++len;
                                }
                            }
                        }
                        numlen = ((Object)bytes).length - first;
                        len += numlen;
                        if ((flags & 66) == 2) {
                            precision = width;
                            width = 0;
                        } else {
                            if (precision < len) {
                                precision = len;
                            }
                            width -= precision;
                        }
                        if ((flags & 8) == 0) {
                            buf.fill(32, width);
                            width = 0;
                        }
                        if (signChar != 0) {
                            buf.append(signChar);
                        }
                        if (prefix != null) {
                            buf.append(prefix);
                        }
                        if (len < precision) {
                            if (leadChar == 0) {
                                buf.fill(48, precision - len);
                            } else if (leadChar == 46) {
                                buf.fill(leadChar, precision - len);
                                buf.append(Sprintf.PREFIX_NEGATIVE);
                            } else {
                                buf.fill(leadChar, precision - len + 1);
                            }
                        } else if (leadChar != 0) {
                            if ((flags & 66) == 0) {
                                buf.append(Sprintf.PREFIX_NEGATIVE);
                            }
                            if (leadChar != 46) {
                                buf.append(leadChar);
                            }
                        }
                        buf.append((byte[])bytes, first, numlen);
                        if (width > 0) {
                            buf.fill(32, width);
                        }
                        ++offset;
                        incomplete = false;
                        continue block59;
                    }
                    case 69: 
                    case 71: 
                    case 101: 
                    case 102: 
                    case 103: 
                }
                if (arg == null) {
                    arg = args.next();
                }
                if (!(arg instanceof RubyFloat)) {
                    arg = RubyKernel.new_float(arg, arg);
                }
                nan = (dval = ((RubyFloat)arg).getDoubleValue()) != dval;
                inf = dval == Infinity || dval == -Infinity;
                negative = dval < 0.0 || dval == 0.0 && new Float(dval).equals(new Float(-0.0)) != false;
                nDigits = 0;
                exponent = 0;
                len = 0;
                if (nan || inf) {
                    if (nan) {
                        digits = Sprintf.NAN_VALUE;
                        len = Sprintf.NAN_VALUE.length;
                    } else {
                        digits = Sprintf.INFINITY_VALUE;
                        len = Sprintf.INFINITY_VALUE.length;
                    }
                    if (negative) {
                        signChar = 45;
                        --width;
                    } else if ((flags & 4) != 0) {
                        signChar = 43;
                        --width;
                    } else if ((flags & 1) != 0) {
                        signChar = 32;
                        --width;
                    } else {
                        signChar = 0;
                    }
                    if ((width -= len) > 0 && (flags & 10) == 0) {
                        buf.fill(32, width);
                        width = 0;
                    }
                    if (signChar != 0) {
                        buf.append(signChar);
                    }
                    if (width > 0 && (flags & 8) == 0) {
                        buf.fill(48, width);
                        width = 0;
                    }
                    buf.append(digits);
                    if (width > 0) {
                        buf.fill(32, width);
                    }
                    ++offset;
                    incomplete = false;
                    continue;
                }
                str = Double.toString(dval);
                strlen = str.length();
                digits = new byte[strlen];
                nTrailingZeroes = 0;
                i = negative != false ? 1 : 0;
                decPos = 0;
                block64: while (i < strlen) {
                    ival = (byte)str.charAt(i++);
                    switch (ival) {
                        case 48: {
                            if (nDigits <= 0) ** GOTO lbl413
                            ++nTrailingZeroes;
                            ** GOTO lbl413
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            if (nTrailingZeroes > 0) {
                                while (nTrailingZeroes > 0) {
                                    digits[nDigits++] = 48;
                                    --nTrailingZeroes;
                                }
                            }
                            digits[nDigits++] = ival;
                            ** GOTO lbl413
                        }
                        case 46: {
                            break block64;
                        }
lbl413:
                        // 4 sources

                        default: {
                            continue block64;
                        }
                    }
                }
                decPos = nDigits + nTrailingZeroes;
                block66: while (i < strlen) {
                    ival = (byte)str.charAt(i++);
                    switch (ival) {
                        case 48: {
                            if (nDigits > 0) {
                                ++nTrailingZeroes;
                            } else {
                                --exponent;
                            }
                            ** GOTO lbl435
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            if (nTrailingZeroes > 0) {
                                while (nTrailingZeroes > 0) {
                                    digits[nDigits++] = 48;
                                    --nTrailingZeroes;
                                }
                            }
                            digits[nDigits++] = ival;
                            ** GOTO lbl435
                        }
                        case 69: {
                            break block66;
                        }
lbl435:
                        // 4 sources

                        default: {
                            continue block66;
                        }
                    }
                }
                if (i < strlen) {
                    expVal = 0;
                    if (str.charAt(i) == '-') {
                        expSign = -1;
                        ++i;
                    } else {
                        expSign = 1;
                    }
                    while (i < strlen) {
                        expVal = expVal * 10 + (str.charAt(i++) - 48);
                    }
                    exponent += expVal * expSign;
                }
                exponent += decPos - nDigits;
                if (nDigits == 0) {
                    digits[0] = 48;
                    nDigits = 1;
                    exponent = 0;
                }
                if (negative) {
                    signChar = 45;
                    --width;
                } else if ((flags & 4) != 0) {
                    signChar = 43;
                    --width;
                } else if ((flags & 1) != 0) {
                    signChar = 32;
                    --width;
                } else {
                    signChar = 0;
                }
                if ((flags & 64) == 0) {
                    precision = 6;
                }
                switch (fchar) {
                    case 69: 
                    case 71: {
                        expChar = 69;
                        break;
                    }
                    case 101: 
                    case 103: {
                        expChar = 101;
                        break;
                    }
                    default: {
                        expChar = 0;
                    }
                }
                switch (fchar) {
                    case 71: 
                    case 103: {
                        v1 = exponent + nDigits - 1 < -4 || exponent + nDigits > (precision == 0 ? 1 : precision) ? true : (expForm = false);
                        if (expForm) {
                            decDigits = nDigits - 1;
                            if ((precision = Math.max(0, precision - 1)) < decDigits) {
                                n = Sprintf.round(digits, nDigits, precision, precision != 0);
                                if (n > nDigits) {
                                    nDigits = n;
                                }
                                decDigits = Math.min(nDigits - 1, precision);
                            }
                            isSharp = (flags & 16) != 0;
                            ++len;
                            len = (exponent += nDigits - 1) > 99 ? (len += 5) : (len += 4);
                            if (isSharp) {
                                ++len;
                            }
                            if (precision > 0) {
                                if (!isSharp) {
                                    for (j = decDigits; j >= 1 && digits[j] == 48; --j) {
                                        --decDigits;
                                    }
                                    if (decDigits > 0) {
                                        ++len;
                                        len += decDigits;
                                    }
                                } else {
                                    len += precision;
                                }
                            }
                            if ((width -= len) > 0 && (flags & 10) == 0) {
                                buf.fill(32, width);
                                width = 0;
                            }
                            if (signChar != 0) {
                                buf.append(signChar);
                            }
                            if (width > 0 && (flags & 8) == 0) {
                                buf.fill(48, width);
                                width = 0;
                            }
                            buf.append(digits[0]);
                            v2 = dotToPrint = isSharp != false || precision > 0 && decDigits > 0;
                            if (dotToPrint) {
                                buf.append(args.getDecimalSeparator());
                            }
                            if (precision > 0 && decDigits > 0) {
                                buf.append(digits, 1, decDigits);
                                precision -= decDigits;
                            }
                            if (precision > 0 && isSharp) {
                                buf.fill(48, precision);
                            }
                            Sprintf.writeExp(buf, exponent, expChar);
                            if (width <= 0) break;
                            buf.fill(32, width);
                            break;
                        }
                        intDigits = Math.max(0, Math.min(nDigits + exponent, nDigits));
                        intZeroes = Math.max(0, exponent);
                        intLength = intDigits + intZeroes;
                        decDigits = nDigits - intDigits;
                        decZeroes = Math.max(0, -(decDigits + exponent));
                        decLength = decZeroes + decDigits;
                        if ((precision = Math.max(0, precision - intLength)) < decDigits) {
                            n = Sprintf.round(digits, nDigits, intDigits + precision - 1, precision != 0);
                            if (n > nDigits) {
                                nDigits = n;
                                intDigits = Math.max(0, Math.min(nDigits + exponent, nDigits));
                                intLength = intDigits + intZeroes;
                                decDigits = nDigits - intDigits;
                                decZeroes = Math.max(0, -(decDigits + exponent));
                                precision = Math.max(0, precision - 1);
                            }
                            decDigits = precision;
                            decLength = decZeroes + decDigits;
                        }
                        len += intLength;
                        if (decLength > 0) {
                            len += decLength + 1;
                        } else if ((flags & 16) != 0) {
                            ++len;
                            if (precision > 0) {
                                len += precision;
                            }
                        }
                        if ((width -= len) > 0 && (flags & 10) == 0) {
                            buf.fill(32, width);
                            width = 0;
                        }
                        if (signChar != 0) {
                            buf.append(signChar);
                        }
                        if (width > 0 && (flags & 8) == 0) {
                            buf.fill(48, width);
                            width = 0;
                        }
                        if (intLength > 0) {
                            if (intDigits > 0) {
                                buf.append(digits, 0, intDigits);
                            }
                            if (intZeroes > 0) {
                                buf.fill(48, intZeroes);
                            }
                        } else {
                            buf.append(48);
                        }
                        if (decLength > 0 || (flags & 16) != 0) {
                            buf.append(args.getDecimalSeparator());
                        }
                        if (decLength > 0) {
                            if (decZeroes > 0) {
                                buf.fill(48, decZeroes);
                                precision -= decZeroes;
                            }
                            if (decDigits > 0) {
                                buf.append(digits, intDigits, decDigits);
                                precision -= decDigits;
                            }
                            if ((flags & 16) != 0 && precision > 0) {
                                buf.fill(48, precision);
                            }
                        }
                        if ((flags & 16) != 0 && precision > 0) {
                            buf.fill(48, precision);
                        }
                        if (width <= 0) break;
                        buf.fill(32, width);
                        break;
                    }
                    case 102: {
                        intDigits = Math.max(0, Math.min(nDigits + exponent, nDigits));
                        intZeroes = Math.max(0, exponent);
                        intLength = intDigits + intZeroes;
                        decDigits = nDigits - intDigits;
                        decZeroes = Math.max(0, -(decDigits + exponent));
                        decLength = decZeroes + decDigits;
                        if (precision < decLength) {
                            if (precision < decZeroes) {
                                decDigits = 0;
                                decZeroes = precision;
                            } else {
                                n = Sprintf.round(digits, nDigits, intDigits + precision - decZeroes - 1, precision != 0);
                                if (n > nDigits) {
                                    nDigits = n;
                                    intDigits = Math.max(0, Math.min(nDigits + exponent, nDigits));
                                    intLength = intDigits + intZeroes;
                                    decDigits = nDigits - intDigits;
                                    decZeroes = Math.max(0, -(decDigits + exponent));
                                    decLength = decZeroes + decDigits;
                                }
                                decDigits = precision - decZeroes;
                            }
                            decLength = decZeroes + decDigits;
                        }
                        if (precision > 0) {
                            len += Math.max(1, intLength) + 1 + precision;
                        } else {
                            len += Math.max(1, intLength);
                            if ((flags & 16) != 0) {
                                ++len;
                            }
                        }
                        if ((width -= len) > 0 && (flags & 10) == 0) {
                            buf.fill(32, width);
                            width = 0;
                        }
                        if (signChar != 0) {
                            buf.append(signChar);
                        }
                        if (width > 0 && (flags & 8) == 0) {
                            buf.fill(48, width);
                            width = 0;
                        }
                        if (intLength > 0) {
                            if (intDigits > 0) {
                                buf.append(digits, 0, intDigits);
                            }
                            if (intZeroes > 0) {
                                buf.fill(48, intZeroes);
                            }
                        } else {
                            buf.append(48);
                        }
                        if (precision > 0 || (flags & 16) != 0) {
                            buf.append(args.getDecimalSeparator());
                        }
                        if (precision > 0) {
                            if (decZeroes > 0) {
                                buf.fill(48, decZeroes);
                                precision -= decZeroes;
                            }
                            if (decDigits > 0) {
                                buf.append(digits, intDigits, decDigits);
                                precision -= decDigits;
                            }
                            if (precision > 0) {
                                buf.fill(48, precision);
                            }
                        }
                        if (width <= 0) break;
                        buf.fill(32, width);
                        break;
                    }
                    case 69: 
                    case 101: {
                        decDigits = nDigits - 1;
                        if (precision < decDigits) {
                            n = Sprintf.round(digits, nDigits, precision, precision != 0);
                            if (n > nDigits) {
                                nDigits = n;
                            }
                            decDigits = Math.min(nDigits - 1, precision);
                        }
                        isSharp = (flags & 16) != 0;
                        ++len;
                        len = (exponent += nDigits - 1) > 99 ? (len += 5) : (len += 4);
                        if (precision > 0) {
                            len += 1 + precision;
                        } else if (isSharp) {
                            ++len;
                        }
                        if ((width -= len) > 0 && (flags & 10) == 0) {
                            buf.fill(32, width);
                            width = 0;
                        }
                        if (signChar != 0) {
                            buf.append(signChar);
                        }
                        if (width > 0 && (flags & 8) == 0) {
                            buf.fill(48, width);
                            width = 0;
                        }
                        buf.append(digits[0]);
                        if (precision > 0) {
                            buf.append(args.getDecimalSeparator());
                            if (decDigits > 0) {
                                buf.append(digits, 1, decDigits);
                                precision -= decDigits;
                            }
                            if (precision > 0) {
                                buf.fill(48, precision);
                            }
                        } else if ((flags & 16) != 0) {
                            buf.append(args.getDecimalSeparator());
                        }
                        Sprintf.writeExp(buf, exponent, expChar);
                        if (width <= 0) break;
                        buf.fill(32, width);
                    }
                }
                ++offset;
                incomplete = false;
            }
            if (!incomplete) continue;
            if (flags == 0) {
                buf.append(37);
                continue;
            }
            Sprintf.raiseArgumentError(args, "illegal format character - %");
        }
        if (Args.access$000(args) == 0 && Args.access$100(args) < Args.access$200(args)) {
            if (Args.access$300(args).getDebug().isTrue()) {
                args.raiseArgumentError("too many arguments for format string");
            } else if (Args.access$300(args).isVerbose()) {
                args.warn(IRubyWarnings.ID.TOO_MANY_ARGUMENTS, "too many arguments for format string");
            }
        }
        return tainted;
    }

    private static void writeExp(ByteList buf, int exponent2, byte expChar) {
        buf.append(expChar);
        buf.append(exponent2 >= 0 ? 43 : 45);
        if (exponent2 < 0) {
            exponent2 = -exponent2;
        }
        if (exponent2 > 99) {
            buf.append(exponent2 / 100 + 48);
            buf.append(exponent2 % 100 / 10 + 48);
        } else {
            buf.append(exponent2 / 10 + 48);
        }
        buf.append(exponent2 % 10 + 48);
    }

    private static final void raiseArgumentError(Args args2, String message2) {
        args2.raiseArgumentError(message2);
    }

    private static final void warning(IRubyWarnings.ID id2, Args args2, String message2) {
        args2.warning(id2, message2);
    }

    private static final void checkOffset(Args args2, int offset2, int length2, String message2) {
        if (offset2 >= length2) {
            Sprintf.raiseArgumentError(args2, message2);
        }
    }

    private static final int extendWidth(Args args2, int oldWidth, byte newChar) {
        int newWidth = oldWidth * 10 + (newChar - 48);
        if (newWidth / 10 != oldWidth) {
            Sprintf.raiseArgumentError(args2, "width too big");
        }
        return newWidth;
    }

    private static final boolean isDigit(byte aChar) {
        return aChar >= 48 && aChar <= 57;
    }

    private static final boolean isPrintable(byte aChar) {
        return aChar > 32 && aChar < 127;
    }

    private static final int skipSignBits(byte[] bytes2, int base) {
        int skip2;
        int length2 = bytes2.length;
        switch (base) {
            case 2: {
                for (skip2 = 0; skip2 < length2 && bytes2[skip2] == 49; ++skip2) {
                }
                break;
            }
            case 8: {
                if (length2 > 0 && bytes2[0] == 51) {
                    ++skip2;
                }
                while (skip2 < length2 && bytes2[skip2] == 55) {
                    ++skip2;
                }
                break;
            }
            case 10: {
                if (length2 <= 0 || bytes2[0] != 45) break;
                ++skip2;
                break;
            }
            case 16: {
                byte b;
                while (skip2 < length2 && ((b = bytes2[skip2]) == 102 || b == 70)) {
                    ++skip2;
                }
                break;
            }
        }
        return skip2;
    }

    private static final int round(byte[] bytes2, int nDigits, int roundPos, boolean roundDown) {
        int next2 = roundPos + 1;
        if (next2 >= nDigits || bytes2[next2] < 53 || roundDown && bytes2[next2] == 53 && next2 == nDigits - 1) {
            return nDigits;
        }
        if (roundPos < 0) {
            System.arraycopy(bytes2, 0, bytes2, 1, nDigits);
            bytes2[0] = 49;
            return nDigits + 1;
        }
        int n = roundPos;
        bytes2[n] = (byte)(bytes2[n] + 1);
        while (bytes2[roundPos] > 57) {
            bytes2[roundPos] = 48;
            if (--roundPos >= 0) {
                int n2 = roundPos;
                bytes2[n2] = (byte)(bytes2[n2] + 1);
                continue;
            }
            System.arraycopy(bytes2, 0, bytes2, 1, nDigits);
            bytes2[0] = 49;
            return nDigits + 1;
        }
        return nDigits;
    }

    private static final byte[] getFixnumBytes(RubyFixnum arg2, int base, boolean sign2, boolean upper) {
        long val = arg2.getLongValue();
        if (val >= Integer.MIN_VALUE && val <= Integer.MAX_VALUE) {
            if (sign2) {
                return Convert.intToByteArray((int)val, base, upper);
            }
            switch (base) {
                case 2: {
                    return Convert.intToBinaryBytes((int)val);
                }
                case 8: {
                    return Convert.intToOctalBytes((int)val);
                }
                default: {
                    return Convert.intToCharBytes((int)val);
                }
                case 16: 
            }
            return Convert.intToHexBytes((int)val, upper);
        }
        if (sign2) {
            return Convert.longToByteArray(val, base, upper);
        }
        switch (base) {
            case 2: {
                return Convert.longToBinaryBytes(val);
            }
            case 8: {
                return Convert.longToOctalBytes(val);
            }
            default: {
                return Convert.longToCharBytes(val);
            }
            case 16: 
        }
        return Convert.longToHexBytes(val, upper);
    }

    private static final byte[] getBignumBytes(RubyBignum arg2, int base, boolean sign2, boolean upper) {
        BigInteger val = arg2.getValue();
        if (sign2 || base == 10 || val.signum() >= 0) {
            return Sprintf.stringToBytes(val.toString(base), upper);
        }
        byte[] bytes2 = val.toByteArray();
        switch (base) {
            case 2: {
                return Convert.twosComplementToBinaryBytes(bytes2);
            }
            case 8: {
                return Convert.twosComplementToOctalBytes(bytes2);
            }
            case 16: {
                return Convert.twosComplementToHexBytes(bytes2, upper);
            }
        }
        return Sprintf.stringToBytes(val.toString(base), upper);
    }

    private static final byte[] getUnsignedNegativeBytes(RubyInteger arg2) {
        BigInteger bigval;
        if (arg2 instanceof RubyFixnum) {
            long longval = ((RubyFixnum)arg2).getLongValue();
            if (longval >= 0L) {
                return Convert.longToCharBytes(0L + longval);
            }
            bigval = BigInteger.valueOf(longval);
        } else {
            bigval = ((RubyBignum)arg2).getValue();
        }
        int shift2 = 0;
        BigInteger minus = BIG_MINUS_64;
        while (bigval.compareTo(minus) < 0) {
            minus = minus.shiftLeft(32);
            ++shift2;
        }
        BigInteger nPower32 = shift2 > 0 ? BIG_64.shiftLeft(32 * shift2) : BIG_64;
        return Sprintf.stringToBytes(nPower32.add(bigval).toString(), false);
    }

    private static final byte[] stringToBytes(CharSequence s, boolean upper) {
        int len = s.length();
        byte[] bytes2 = new byte[len];
        if (upper) {
            int i = len;
            while (--i >= 0) {
                byte b = (byte)(s.charAt(i) & 0xFF);
                if (b >= 97 && b <= 122) {
                    bytes2[i] = (byte)(b & 0xFFFFFFDF);
                    continue;
                }
                bytes2[i] = b;
            }
        } else {
            int i = len;
            while (--i >= 0) {
                bytes2[i] = (byte)(s.charAt(i) & 0xFF);
            }
        }
        return bytes2;
    }

    private static final class Args {
        private final Ruby runtime;
        private final Locale locale;
        private final IRubyObject rubyObject;
        private final RubyArray rubyArray;
        private final int length;
        private int unnumbered;
        private int numbered;

        Args(Locale locale, IRubyObject rubyObject) {
            if (rubyObject == null) {
                throw new IllegalArgumentException("null IRubyObject passed to sprintf");
            }
            this.locale = locale == null ? Locale.getDefault() : locale;
            this.rubyObject = rubyObject;
            if (rubyObject instanceof RubyArray) {
                this.rubyArray = (RubyArray)rubyObject;
                this.length = this.rubyArray.size();
            } else {
                this.length = 1;
                this.rubyArray = null;
            }
            this.runtime = rubyObject.getRuntime();
        }

        Args(IRubyObject rubyObject) {
            this(Locale.getDefault(), rubyObject);
        }

        Args(Ruby runtime2, long value2) {
            this(RubyFixnum.newFixnum(runtime2, value2));
        }

        void raiseArgumentError(String message2) {
            throw this.runtime.newArgumentError(message2);
        }

        void warn(IRubyWarnings.ID id2, String message2) {
            this.runtime.getWarnings().warn(id2, message2, new Object[0]);
        }

        void warning(IRubyWarnings.ID id2, String message2) {
            if (this.runtime.isVerbose()) {
                this.runtime.getWarnings().warning(id2, message2, new Object[0]);
            }
        }

        IRubyObject next() {
            if (this.numbered > 0) {
                this.raiseArgumentError("unnumbered" + (this.unnumbered + 1) + "mixed with numbered");
            }
            if (this.unnumbered >= this.length) {
                this.raiseArgumentError("too few arguments");
            }
            IRubyObject object = this.rubyArray == null ? this.rubyObject : this.rubyArray.eltInternal(this.unnumbered);
            ++this.unnumbered;
            return object;
        }

        IRubyObject get(int index2) {
            if (this.unnumbered > 0) {
                this.raiseArgumentError("numbered(" + this.numbered + ") after unnumbered(" + this.unnumbered + ")");
            }
            if (index2 < 0) {
                this.raiseArgumentError("invalid index - " + (index2 + 1) + '$');
            }
            if (index2 >= this.length) {
                this.raiseArgumentError("too few arguments");
            }
            this.numbered = index2 + 1;
            return this.rubyArray == null ? this.rubyObject : this.rubyArray.eltInternal(index2);
        }

        IRubyObject getNth(int formatIndex) {
            return this.get(formatIndex - 1);
        }

        int nextInt() {
            return this.intValue(this.next());
        }

        int getInt(int index2) {
            return this.intValue(this.get(index2));
        }

        int getNthInt(int formatIndex) {
            return this.intValue(this.get(formatIndex - 1));
        }

        int intValue(IRubyObject obj) {
            if (obj instanceof RubyNumeric) {
                return (int)((RubyNumeric)obj).getLongValue();
            }
            obj = TypeConverter.convertToType(obj, obj.getRuntime().getFixnum(), "to_int", true);
            return (int)((RubyFixnum)obj).getLongValue();
        }

        byte getDecimalSeparator() {
            return (byte)new DecimalFormatSymbols(this.locale).getDecimalSeparator();
        }

        static /* synthetic */ int access$000(Args x0) {
            return x0.numbered;
        }

        static /* synthetic */ int access$100(Args x0) {
            return x0.unnumbered;
        }

        static /* synthetic */ int access$200(Args x0) {
            return x0.length;
        }

        static /* synthetic */ Ruby access$300(Args x0) {
            return x0.runtime;
        }
    }
}

