/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public final class Block {
    private RubyProc proc = null;
    public Type type = Type.NORMAL;
    private final Binding binding;
    private final BlockBody body;
    private boolean[] escaped = new boolean[]{false};
    public static final Block NULL_BLOCK = new Block(BlockBody.NULL_BODY);

    public Block(BlockBody body, Binding binding2) {
        this.body = body;
        this.binding = binding2;
    }

    public Block(BlockBody body) {
        this.body = body;
        this.binding = null;
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2) {
        return this.body.call(context, args2, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.body.call(context, args2, this.binding, this.type, block);
    }

    public IRubyObject call(ThreadContext context) {
        return this.body.call(context, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, Block block) {
        return this.body.call(context, this.binding, this.type, block);
    }

    public IRubyObject yieldSpecific(ThreadContext context) {
        return this.body.yieldSpecific(context, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0) {
        return this.body.call(context, arg0, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, Block block) {
        return this.body.call(context, arg0, this.binding, this.type, block);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0) {
        return this.body.yieldSpecific(context, arg0, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return this.body.call(context, arg0, arg1, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.body.call(context, arg0, arg1, this.binding, this.type, block);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return this.body.yieldSpecific(context, arg0, arg1, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return this.body.call(context, arg0, arg1, arg2, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.body.call(context, arg0, arg1, arg2, this.binding, this.type, block);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return this.body.yieldSpecific(context, arg0, arg1, arg2, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        return this.body.call(context, arg0, arg1, arg2, arg3, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        return this.body.call(context, arg0, arg1, arg2, arg3, this.binding, this.type, block);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        return this.body.yieldSpecific(context, arg0, arg1, arg2, arg3, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4) {
        return this.body.call(context, arg0, arg1, arg2, arg3, arg4, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, Block block) {
        return this.body.call(context, arg0, arg1, arg2, arg3, arg4, this.binding, this.type, block);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4) {
        return this.body.yieldSpecific(context, arg0, arg1, arg2, arg3, arg4, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5) {
        return this.body.call(context, arg0, arg1, arg2, arg3, arg4, arg5, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, Block block) {
        return this.body.call(context, arg0, arg1, arg2, arg3, arg4, arg5, this.binding, this.type, block);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5) {
        return this.body.yieldSpecific(context, arg0, arg1, arg2, arg3, arg4, arg5, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6) {
        return this.body.call(context, arg0, arg1, arg2, arg3, arg4, arg5, arg6, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, Block block) {
        return this.body.call(context, arg0, arg1, arg2, arg3, arg4, arg5, arg6, this.binding, this.type, block);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6) {
        return this.body.yieldSpecific(context, arg0, arg1, arg2, arg3, arg4, arg5, arg6, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7) {
        return this.body.call(context, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, Block block) {
        return this.body.call(context, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, this.binding, this.type, block);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7) {
        return this.body.yieldSpecific(context, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, IRubyObject arg8) {
        return this.body.call(context, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, IRubyObject arg8, Block block) {
        return this.body.call(context, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, this.binding, this.type, block);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, IRubyObject arg8) {
        return this.body.yieldSpecific(context, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, IRubyObject arg8, IRubyObject arg9) {
        return this.body.call(context, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, IRubyObject arg8, IRubyObject arg9, Block block) {
        return this.body.call(context, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, this.binding, this.type, block);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, IRubyObject arg8, IRubyObject arg9) {
        return this.body.yieldSpecific(context, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, this.binding, this.type);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value2) {
        return this.body.yield(context, value2, this.binding, this.type);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value2, IRubyObject self, RubyModule klass, boolean aValue) {
        return this.body.yield(context, value2, self, klass, aValue, this.binding, this.type);
    }

    @Deprecated
    public IRubyObject yield(ThreadContext context, IRubyObject value2, boolean aValue) {
        return this.body.yield(context, value2, null, null, aValue, this.binding, this.type);
    }

    @Deprecated
    public IRubyObject yield(ThreadContext context, boolean aValue) {
        return this.body.yield(context, null, null, null, aValue, this.binding, this.type);
    }

    public Block cloneBlock() {
        Block newBlock = this.body.cloneBlock(this.binding);
        newBlock.type = this.type;
        newBlock.escaped = this.escaped;
        return newBlock;
    }

    public Arity arity() {
        return this.body.arity();
    }

    public RubyProc getProcObject() {
        return this.proc;
    }

    public void setProcObject(RubyProc procObject) {
        this.proc = procObject;
    }

    public final boolean isGiven() {
        return this != NULL_BLOCK;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public BlockBody getBody() {
        return this.body;
    }

    public Frame getFrame() {
        return this.binding.getFrame();
    }

    public boolean isEscaped() {
        return this.escaped[0];
    }

    public void escape() {
        this.escaped[0] = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NORMAL,
        PROC,
        LAMBDA,
        THREAD;

    }
}

