/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import java.io.File;
import java.io.IOException;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.JavaSecuredFile;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXHandler;

public class JavaFileStat
implements FileStat {
    private POSIXHandler handler;
    short st_mode;
    int st_blksize;
    long st_size;
    int st_ctime;
    int st_mtime;
    POSIX posix;

    public JavaFileStat(POSIX posix, POSIXHandler handler) {
        this.handler = handler;
        this.posix = posix;
    }

    public void setup(String path2) {
        JavaSecuredFile file2 = new JavaSecuredFile(path2);
        this.st_blksize = 4096;
        this.st_mode = this.calculateMode(file2, this.st_mode);
        this.st_size = ((File)file2).length();
        this.st_mtime = (int)(((File)file2).lastModified() / 1000L);
        this.st_ctime = ((File)file2).getParentFile() != null ? (int)(((File)file2).getParentFile().lastModified() / 1000L) : this.st_mtime;
    }

    private short calculateMode(File file2, short st_mode) {
        if (file2.canRead()) {
            st_mode = (short)(st_mode | 0x124);
        }
        if (file2.canWrite()) {
            st_mode = (short)(st_mode | 0x92);
        }
        if (file2.isDirectory()) {
            st_mode = (short)(st_mode | 0x4000);
        } else if (file2.isFile()) {
            st_mode = (short)(st_mode | 0x8000);
        }
        try {
            st_mode = this.calculateSymlink(file2, st_mode);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return st_mode;
    }

    private short calculateSymlink(File file2, short st_mode) throws IOException {
        if (file2.getAbsoluteFile().getParentFile() == null) {
            return st_mode;
        }
        File absoluteParent = file2.getAbsoluteFile().getParentFile();
        File canonicalParent = absoluteParent.getCanonicalFile();
        if (canonicalParent.getAbsolutePath().equals(absoluteParent.getAbsolutePath()) && !file2.getAbsolutePath().equalsIgnoreCase(file2.getCanonicalPath())) {
            st_mode = (short)(st_mode | 0xA000);
            return st_mode;
        }
        file2 = new JavaSecuredFile(canonicalParent.getAbsolutePath() + "/" + file2.getName());
        if (!file2.getAbsolutePath().equalsIgnoreCase(file2.getCanonicalPath())) {
            st_mode = (short)(st_mode | 0xA000);
        }
        return st_mode;
    }

    public long atime() {
        return this.st_mtime;
    }

    public long blocks() {
        this.handler.unimplementedError("stat.st_blocks");
        return -1L;
    }

    public long blockSize() {
        return this.st_blksize;
    }

    public long ctime() {
        return this.st_ctime;
    }

    public long dev() {
        this.handler.unimplementedError("stat.st_dev");
        return -1L;
    }

    public String ftype() {
        if (this.isFile()) {
            return "file";
        }
        if (this.isDirectory()) {
            return "directory";
        }
        return "unknown";
    }

    public int gid() {
        this.handler.unimplementedError("stat.st_gid");
        return -1;
    }

    public boolean groupMember(int gid2) {
        return this.posix.getgid() == gid2 || this.posix.getegid() == gid2;
    }

    public long ino() {
        return 0L;
    }

    public boolean isBlockDev() {
        this.handler.unimplementedError("block device detection");
        return false;
    }

    public boolean isCharDev() {
        return false;
    }

    public boolean isDirectory() {
        return (this.mode() & 0x4000) != 0;
    }

    public boolean isEmpty() {
        return this.st_size() == 0L;
    }

    public boolean isExecutable() {
        this.handler.warn(POSIXHandler.WARNING_ID.DUMMY_VALUE_USED, "executable? does not in this environment and will return a dummy value", "executable");
        return true;
    }

    public boolean isExecutableReal() {
        this.handler.warn(POSIXHandler.WARNING_ID.DUMMY_VALUE_USED, "executable_real? does not work in this environmnt and will return a dummy value", "executable_real");
        return true;
    }

    public boolean isFifo() {
        this.handler.unimplementedError("fifo file detection");
        return false;
    }

    public boolean isFile() {
        return (this.mode() & 0x8000) != 0;
    }

    public boolean isGroupOwned() {
        return this.groupMember(this.gid());
    }

    public boolean isIdentical(FileStat other) {
        this.handler.unimplementedError("identical file detection");
        return false;
    }

    public boolean isNamedPipe() {
        this.handler.unimplementedError("piped file detection");
        return false;
    }

    public boolean isOwned() {
        return this.posix.geteuid() == this.uid();
    }

    public boolean isROwned() {
        return this.posix.getuid() == this.uid();
    }

    public boolean isReadable() {
        int mode2 = this.mode();
        if ((mode2 & 0x100) != 0) {
            return true;
        }
        if ((mode2 & 0x20) != 0) {
            return true;
        }
        return (mode2 & 4) != 0;
    }

    public boolean isReadableReal() {
        return this.isReadable();
    }

    public boolean isSymlink() {
        return (this.mode() & 0xA000) == 40960;
    }

    public boolean isWritable() {
        int mode2 = this.mode();
        if ((mode2 & 0x80) != 0) {
            return true;
        }
        if ((mode2 & 0x10) != 0) {
            return true;
        }
        return (mode2 & 2) != 0;
    }

    public boolean isWritableReal() {
        return this.isWritable();
    }

    public boolean isSetgid() {
        this.handler.unimplementedError("setgid detection");
        return false;
    }

    public boolean isSetuid() {
        this.handler.unimplementedError("setuid detection");
        return false;
    }

    public boolean isSocket() {
        this.handler.unimplementedError("socket file type detection");
        return false;
    }

    public boolean isSticky() {
        this.handler.unimplementedError("sticky bit detection");
        return false;
    }

    public int major(long dev2) {
        this.handler.unimplementedError("major device");
        return -1;
    }

    public int minor(long dev2) {
        this.handler.unimplementedError("minor device");
        return -1;
    }

    public int mode() {
        return this.st_mode & 0xFFFF;
    }

    public long mtime() {
        return this.st_mtime;
    }

    public int nlink() {
        this.handler.unimplementedError("stat.nlink");
        return -1;
    }

    public long rdev() {
        this.handler.unimplementedError("stat.rdev");
        return -1L;
    }

    public long st_size() {
        return this.st_size;
    }

    public int uid() {
        return -1;
    }
}

