/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.experimental.mediators.seda;

import java.util.AbstractQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import org.apache.synapse.MessageContext;
import org.apache.synapse.experimental.mediators.seda.SEDAQueueConsumerWorkerFactory;
import org.apache.synapse.experimental.mediators.seda.SEDAQueuePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SEDAQueue {
    private SEDAQueuePolicy queuePolicy;
    private final BlockingQueue<MessageContext> queue;
    private SEDAQueueConsumerWorkerFactory workerFactory;
    private boolean initialized;
    private static final Executor EXECUTOR = Executors.newFixedThreadPool(10);

    public SEDAQueue(SEDAQueuePolicy queuePolicy, SEDAQueueConsumerWorkerFactory workerFactory) {
        this.queuePolicy = queuePolicy;
        this.queue = this.createBlockingQueue(queuePolicy);
        this.workerFactory = workerFactory;
    }

    private BlockingQueue<MessageContext> createBlockingQueue(SEDAQueuePolicy queuePolicy) {
        String queueType = queuePolicy.getQueueType();
        int capacity = queuePolicy.getQueueSize();
        AbstractQueue queue = "PriorityBlocking".equals(queueType) ? new PriorityBlockingQueue<MessageContext>(capacity) : ("Synchronous".equals(queueType) ? new SynchronousQueue() : new LinkedBlockingQueue(capacity));
        return queue;
    }

    public void init() {
        EXECUTOR.execute(this.workerFactory.createSEDAQueueConsumerWorker(this));
    }

    public void destory() {
    }

    public BlockingQueue<MessageContext> getQueue() {
        return this.queue;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public SEDAQueuePolicy getQueuePolicy() {
        return this.queuePolicy;
    }
}

