/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axiom.attachments.SizeAwareDataSource;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;

public class FileObjectDataSource
implements SizeAwareDataSource {
    private final FileObject file;
    private final String contentType;

    public FileObjectDataSource(FileObject file, String contentType) {
        this.file = file;
        this.contentType = contentType;
    }

    public long getSize() {
        try {
            return this.file.getContent().getSize();
        }
        catch (FileSystemException ex) {
            return -1L;
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.file.getName().getURI();
    }

    public InputStream getInputStream() throws IOException {
        return this.file.getContent().getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.file.getContent().getOutputStream();
    }
}

