/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.builder;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.EncryptedKeyToken;
import org.apache.rahas.TrustException;
import org.apache.rampart.RampartException;
import org.apache.rampart.RampartMessageData;
import org.apache.rampart.builder.BindingBuilder;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.util.RampartUtil;
import org.apache.ws.secpolicy.model.AlgorithmSuite;
import org.apache.ws.secpolicy.model.IssuedToken;
import org.apache.ws.secpolicy.model.SecureConversationToken;
import org.apache.ws.secpolicy.model.SupportingToken;
import org.apache.ws.secpolicy.model.Token;
import org.apache.ws.secpolicy.model.X509Token;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.WSSecDKEncrypt;
import org.apache.ws.security.message.WSSecEncrypt;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SymmetricBindingBuilder
extends BindingBuilder {
    private static Log log = LogFactory.getLog(SymmetricBindingBuilder.class);
    private static Log tlog = LogFactory.getLog((String)"org.apache.rampart.TIME");
    private boolean dotDebug = tlog.isDebugEnabled();

    public void build(RampartMessageData rmd) throws RampartException {
        log.debug((Object)"SymmetricBindingBuilder build invoked");
        RampartPolicyData rpd = rmd.getPolicyData();
        if (rpd.isIncludeTimestamp()) {
            this.addTimestamp(rmd);
        }
        if (rmd.isInitiator()) {
            this.initializeTokens(rmd);
        }
        if ("EncryptBeforeSigning".equals(rpd.getProtectionOrder())) {
            this.doEncryptBeforeSig(rmd);
        } else {
            this.doSignBeforeEncrypt(rmd);
        }
        log.debug((Object)"SymmetricBindingBuilder build invoked : DONE");
    }

    private void doEncryptBeforeSig(RampartMessageData rmd) throws RampartException {
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        RampartPolicyData rpd = rmd.getPolicyData();
        Vector<Object> signatureValues = new Vector<Object>();
        if (this.dotDebug) {
            t0 = System.currentTimeMillis();
        }
        Token encryptionToken = rpd.getEncryptionToken();
        Vector encrParts = RampartUtil.getEncryptedParts(rmd);
        Vector sigParts = RampartUtil.getSignedParts(rmd);
        if (encryptionToken == null && encrParts.size() > 0) {
            throw new RampartException("encryptionTokenMissing");
        }
        if (encryptionToken != null && encrParts.size() > 0) {
            String tokenId = null;
            org.apache.rahas.Token tok = null;
            if (encryptionToken instanceof IssuedToken) {
                tokenId = rmd.getIssuedEncryptionTokenId();
                log.debug((Object)("Issued EncryptionToken Id : " + tokenId));
            } else if (encryptionToken instanceof SecureConversationToken) {
                tokenId = rmd.getSecConvTokenId();
                log.debug((Object)("SCT Id : " + tokenId));
            } else if (encryptionToken instanceof X509Token) {
                tokenId = rmd.isInitiator() ? this.setupEncryptedKey(rmd, encryptionToken) : this.getEncryptedKey(rmd);
            }
            if (tokenId == null || tokenId.length() == 0) {
                throw new RampartException("noSecurityToken");
            }
            if (tokenId.startsWith("#")) {
                tokenId = tokenId.substring(1);
            }
            tok = this.getToken(rmd, tokenId);
            boolean attached = false;
            Element encrTokenElement = null;
            Element refList = null;
            WSSecDKEncrypt dkEncr = null;
            WSSecEncrypt encr = null;
            Element encrDKTokenElem = null;
            if (5 == encryptionToken.getInclusion() || 2 == encryptionToken.getInclusion() || rmd.isInitiator() && 3 == encryptionToken.getInclusion()) {
                encrTokenElement = RampartUtil.appendChildToSecHeader(rmd, tok.getToken());
                attached = true;
            } else if (encryptionToken instanceof X509Token && rmd.isInitiator()) {
                encrTokenElement = RampartUtil.appendChildToSecHeader(rmd, tok.getToken());
            }
            Document doc = rmd.getDocument();
            AlgorithmSuite algorithmSuite = rpd.getAlgorithmSuite();
            if (encryptionToken.isDerivedKeys()) {
                log.debug((Object)"Use drived keys");
                dkEncr = new WSSecDKEncrypt();
                if (attached && tok.getAttachedReference() != null) {
                    dkEncr.setExternalKey(tok.getSecret(), (Element)doc.importNode((Element)tok.getAttachedReference(), true));
                } else if (tok.getUnattachedReference() != null) {
                    dkEncr.setExternalKey(tok.getSecret(), (Element)doc.importNode((Element)tok.getUnattachedReference(), true));
                } else {
                    dkEncr.setExternalKey(tok.getSecret(), tok.getId());
                }
                try {
                    dkEncr.setSymmetricEncAlgorithm(algorithmSuite.getEncryption());
                    dkEncr.setDerivedKeyLength(algorithmSuite.getEncryptionDerivedKeyLength() / 8);
                    dkEncr.prepare(doc);
                    encrDKTokenElem = dkEncr.getdktElement();
                    RampartUtil.appendChildToSecHeader(rmd, encrDKTokenElem);
                    refList = dkEncr.encryptForExternalRef(null, encrParts);
                }
                catch (WSSecurityException e) {
                    throw new RampartException("errorInDKEncr");
                }
                catch (ConversationException e) {
                    throw new RampartException("errorInDKEncr");
                }
            }
            log.debug((Object)"NO derived keys, use the shared secret");
            encr = new WSSecEncrypt();
            encr.setWsConfig(rmd.getConfig());
            encr.setEncKeyId(tokenId);
            RampartUtil.setEncryptionUser(rmd, (WSSecEncryptedKey)encr);
            encr.setEphemeralKey(tok.getSecret());
            encr.setDocument(doc);
            encr.setSymmetricEncAlgorithm(algorithmSuite.getEncryption());
            encr.setEncryptSymmKey(false);
            if (!rmd.isInitiator() && tok instanceof EncryptedKeyToken) {
                encr.setUseKeyIdentifier(true);
                encr.setCustomReferenceValue(((EncryptedKeyToken)tok).getSHA1());
                encr.setKeyIdentifierType(10);
            }
            try {
                encr.prepare(doc, RampartUtil.getEncryptionCrypto(rpd.getRampartConfig(), rmd.getCustomClassLoader()));
                refList = encr.encryptForExternalRef(null, encrParts);
            }
            catch (WSSecurityException e) {
                throw new RampartException("errorInEncryption", e);
            }
            this.mainRefListElement = RampartUtil.appendChildToSecHeader(rmd, refList);
            if (this.dotDebug) {
                t1 = System.currentTimeMillis();
            }
            if (encrTokenElement != null) {
                this.setInsertionLocation(encrTokenElement);
            } else if (this.timestampElement != null) {
                this.setInsertionLocation(this.timestampElement);
            }
            RampartUtil.handleEncryptedSignedHeaders(encrParts, sigParts, doc);
            HashMap sigSuppTokMap = null;
            HashMap endSuppTokMap = null;
            HashMap sgndEndSuppTokMap = null;
            HashMap sgndEncSuppTokMap = null;
            HashMap endEncSuppTokMap = null;
            HashMap sgndEndEncSuppTokMap = null;
            if (this.timestampElement != null) {
                sigParts.add(new WSEncryptionPart(RampartUtil.addWsuIdToElement((OMElement)this.timestampElement)));
            }
            if (rmd.isInitiator()) {
                SupportingToken sgndSuppTokens = rpd.getSignedSupportingTokens();
                sigSuppTokMap = this.handleSupportingTokens(rmd, sgndSuppTokens);
                SupportingToken endSuppTokens = rpd.getEndorsingSupportingTokens();
                endSuppTokMap = this.handleSupportingTokens(rmd, endSuppTokens);
                SupportingToken sgndEndSuppTokens = rpd.getSignedEndorsingSupportingTokens();
                sgndEndSuppTokMap = this.handleSupportingTokens(rmd, sgndEndSuppTokens);
                SupportingToken sgndEncryptedSuppTokens = rpd.getSignedEncryptedSupportingTokens();
                sgndEncSuppTokMap = this.handleSupportingTokens(rmd, sgndEncryptedSuppTokens);
                SupportingToken endorsingEncryptedSuppTokens = rpd.getEndorsingEncryptedSupportingTokens();
                endEncSuppTokMap = this.handleSupportingTokens(rmd, endorsingEncryptedSuppTokens);
                SupportingToken sgndEndEncSuppTokens = rpd.getSignedEndorsingEncryptedSupportingTokens();
                sgndEndEncSuppTokMap = this.handleSupportingTokens(rmd, sgndEndEncSuppTokens);
                Vector supportingToks = rpd.getSupportingTokensList();
                for (int i = 0; i < supportingToks.size(); ++i) {
                    this.handleSupportingTokens(rmd, (SupportingToken)supportingToks.get(i));
                }
                SupportingToken encryptedSupportingToks = rpd.getEncryptedSupportingTokens();
                this.handleSupportingTokens(rmd, encryptedSupportingToks);
                sigParts = this.addSignatureParts(sigSuppTokMap, sigParts);
                sigParts = this.addSignatureParts(sgndEncSuppTokMap, sigParts);
                sigParts = this.addSignatureParts(sgndEndSuppTokMap, sigParts);
                sigParts = this.addSignatureParts(sgndEndEncSuppTokMap, sigParts);
            } else {
                this.addSignatureConfirmation(rmd, sigParts);
            }
            if (sigParts.size() > 0) {
                signatureValues.add(this.doSymmSignature(rmd, encryptionToken, tok, sigParts));
                this.mainSigId = RampartUtil.addWsuIdToElement((OMElement)this.getInsertionLocation());
            }
            if (rmd.isInitiator()) {
                endSuppTokMap.putAll(endEncSuppTokMap);
                Vector endSigVals = this.doEndorsedSignatures(rmd, endSuppTokMap);
                Iterator iter = endSigVals.iterator();
                while (iter.hasNext()) {
                    signatureValues.add(iter.next());
                }
                sgndEndSuppTokMap.putAll(sgndEndEncSuppTokMap);
                Vector sigEndSigVals = this.doEndorsedSignatures(rmd, sgndEndSuppTokMap);
                Iterator iter2 = sigEndSigVals.iterator();
                while (iter2.hasNext()) {
                    signatureValues.add(iter2.next());
                }
            }
            if (this.dotDebug) {
                t2 = System.currentTimeMillis();
                tlog.debug((Object)("Encryption took :" + (t1 - t0) + ", Signature tool :" + (t2 - t1)));
            }
            if (rpd.isSignatureProtection() && this.mainSigId != null || this.encryptedTokensIdList.size() > 0 && rmd.isInitiator()) {
                long t3 = 0L;
                long t4 = 0L;
                if (this.dotDebug) {
                    t3 = System.currentTimeMillis();
                }
                log.debug((Object)"Signature protection");
                Vector<WSEncryptionPart> secondEncrParts = new Vector<WSEncryptionPart>();
                if (rpd.isSignatureProtection()) {
                    secondEncrParts.add(new WSEncryptionPart(this.mainSigId, "Element"));
                }
                if (rmd.isInitiator()) {
                    for (int i = 0; i < this.encryptedTokensIdList.size(); ++i) {
                        secondEncrParts.add(new WSEncryptionPart((String)this.encryptedTokensIdList.get(i), "Element"));
                    }
                }
                Element secondRefList = null;
                if (encryptionToken.isDerivedKeys()) {
                    try {
                        secondRefList = dkEncr.encryptForExternalRef(null, secondEncrParts);
                        RampartUtil.insertSiblingAfter(rmd, encrDKTokenElem, secondRefList);
                    }
                    catch (WSSecurityException e) {
                        throw new RampartException("errorInDKEncr");
                    }
                }
                try {
                    secondRefList = encr.encryptForExternalRef(null, encrParts);
                    RampartUtil.insertSiblingAfter(rmd, encrTokenElement, secondRefList);
                }
                catch (WSSecurityException e) {
                    throw new RampartException("errorInEncryption", e);
                }
                if (this.dotDebug) {
                    t4 = System.currentTimeMillis();
                    tlog.debug((Object)("Signature protection took :" + (t4 - t3)));
                }
            }
        } else {
            throw new RampartException("encryptionTokenMissing");
        }
    }

    private void doSignBeforeEncrypt(RampartMessageData rmd) throws RampartException {
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        RampartPolicyData rpd = rmd.getPolicyData();
        Document doc = rmd.getDocument();
        if (this.dotDebug) {
            t0 = System.currentTimeMillis();
        }
        Token sigToken = rpd.getSignatureToken();
        String encrTokId = null;
        String sigTokId = null;
        org.apache.rahas.Token encrTok = null;
        org.apache.rahas.Token sigTok = null;
        Element sigTokElem = null;
        Vector<Object> signatureValues = new Vector<Object>();
        if (sigToken != null) {
            if (sigToken instanceof SecureConversationToken) {
                sigTokId = rmd.getSecConvTokenId();
            } else if (sigToken instanceof IssuedToken) {
                sigTokId = rmd.getIssuedSignatureTokenId();
            } else if (sigToken instanceof X509Token) {
                sigTokId = rmd.isInitiator() ? this.setupEncryptedKey(rmd, sigToken) : this.getEncryptedKey(rmd);
            }
        } else {
            throw new RampartException("signatureTokenMissing");
        }
        if (sigTokId == null || sigTokId.length() == 0) {
            throw new RampartException("noSecurityToken");
        }
        sigTok = this.getToken(rmd, sigTokId);
        if (5 == sigToken.getInclusion() || 2 == sigToken.getInclusion() || rmd.isInitiator() && 3 == sigToken.getInclusion()) {
            sigTokElem = RampartUtil.appendChildToSecHeader(rmd, sigTok.getToken());
            this.setInsertionLocation(sigTokElem);
        } else if (rmd.isInitiator() && sigToken instanceof X509Token || sigToken instanceof SecureConversationToken) {
            sigTokElem = RampartUtil.appendChildToSecHeader(rmd, sigTok.getToken());
            this.setInsertionLocation(sigTokElem);
        }
        HashMap sigSuppTokMap = null;
        HashMap endSuppTokMap = null;
        HashMap sgndEndSuppTokMap = null;
        HashMap sgndEncSuppTokMap = null;
        HashMap endEncSuppTokMap = null;
        HashMap sgndEndEncSuppTokMap = null;
        Vector sigParts = RampartUtil.getSignedParts(rmd);
        if (this.timestampElement != null) {
            sigParts.add(new WSEncryptionPart(RampartUtil.addWsuIdToElement((OMElement)this.timestampElement)));
        }
        if (rmd.isInitiator()) {
            SupportingToken sgndSuppTokens = rpd.getSignedSupportingTokens();
            sigSuppTokMap = this.handleSupportingTokens(rmd, sgndSuppTokens);
            SupportingToken endSuppTokens = rpd.getEndorsingSupportingTokens();
            endSuppTokMap = this.handleSupportingTokens(rmd, endSuppTokens);
            SupportingToken sgndEndSuppTokens = rpd.getSignedEndorsingSupportingTokens();
            sgndEndSuppTokMap = this.handleSupportingTokens(rmd, sgndEndSuppTokens);
            SupportingToken sgndEncryptedSuppTokens = rpd.getSignedEncryptedSupportingTokens();
            sgndEncSuppTokMap = this.handleSupportingTokens(rmd, sgndEncryptedSuppTokens);
            SupportingToken endorsingEncryptedSuppTokens = rpd.getEndorsingEncryptedSupportingTokens();
            endEncSuppTokMap = this.handleSupportingTokens(rmd, endorsingEncryptedSuppTokens);
            SupportingToken sgndEndEncSuppTokens = rpd.getSignedEndorsingEncryptedSupportingTokens();
            sgndEndEncSuppTokMap = this.handleSupportingTokens(rmd, sgndEndEncSuppTokens);
            Vector supportingToks = rpd.getSupportingTokensList();
            for (int i = 0; i < supportingToks.size(); ++i) {
                this.handleSupportingTokens(rmd, (SupportingToken)supportingToks.get(i));
            }
            SupportingToken encryptedSupportingToks = rpd.getEncryptedSupportingTokens();
            this.handleSupportingTokens(rmd, encryptedSupportingToks);
            sigParts = this.addSignatureParts(sigSuppTokMap, sigParts);
            sigParts = this.addSignatureParts(sgndEncSuppTokMap, sigParts);
            sigParts = this.addSignatureParts(sgndEndSuppTokMap, sigParts);
            sigParts = this.addSignatureParts(sgndEndEncSuppTokMap, sigParts);
        } else {
            this.addSignatureConfirmation(rmd, sigParts);
        }
        if (sigParts.size() > 0) {
            signatureValues.add(this.doSymmSignature(rmd, sigToken, sigTok, sigParts));
            this.mainSigId = RampartUtil.addWsuIdToElement((OMElement)this.getInsertionLocation());
        }
        if (rmd.isInitiator()) {
            endSuppTokMap.putAll(endEncSuppTokMap);
            Vector endSigVals = this.doEndorsedSignatures(rmd, endSuppTokMap);
            Iterator iter = endSigVals.iterator();
            while (iter.hasNext()) {
                signatureValues.add(iter.next());
            }
            sgndEndSuppTokMap.putAll(sgndEndEncSuppTokMap);
            Vector sigEndSigVals = this.doEndorsedSignatures(rmd, sgndEndSuppTokMap);
            Iterator iter2 = sigEndSigVals.iterator();
            while (iter2.hasNext()) {
                signatureValues.add(iter2.next());
            }
        }
        if (this.dotDebug) {
            t1 = System.currentTimeMillis();
        }
        Token encrToken = rpd.getEncryptionToken();
        Element encrTokElem = null;
        if (sigToken.equals(encrToken)) {
            encrTokId = sigTokId;
            encrTok = sigTok;
            encrTokElem = sigTokElem;
        } else {
            encrTokId = rmd.getIssuedEncryptionTokenId();
            encrTok = this.getToken(rmd, encrTokId);
            if (5 == encrToken.getInclusion() || 2 == encrToken.getInclusion() || rmd.isInitiator() && 3 == encrToken.getInclusion()) {
                encrTokElem = (Element)encrTok.getToken();
                RampartUtil.insertSiblingBefore(rmd, sigTokElem, encrTokElem);
            }
        }
        Vector encrParts = RampartUtil.getEncryptedParts(rmd);
        if (rpd.isSignatureProtection() && this.mainSigId != null) {
            encrParts.add(new WSEncryptionPart(this.mainSigId, "Element"));
        }
        if (rmd.isInitiator()) {
            for (int i = 0; i < this.encryptedTokensIdList.size(); ++i) {
                encrParts.add(new WSEncryptionPart((String)this.encryptedTokensIdList.get(i), "Element"));
            }
        }
        Element refList = null;
        if (encrParts.size() > 0) {
            if (encrToken.isDerivedKeys()) {
                try {
                    WSSecDKEncrypt dkEncr = new WSSecDKEncrypt();
                    if (2 == encrToken.getVersion()) {
                        dkEncr.setWscVersion(2);
                    }
                    if (encrTokElem != null && encrTok.getAttachedReference() != null) {
                        dkEncr.setExternalKey(encrTok.getSecret(), (Element)doc.importNode((Element)encrTok.getAttachedReference(), true));
                    } else if (encrTok.getUnattachedReference() != null) {
                        dkEncr.setExternalKey(encrTok.getSecret(), (Element)doc.importNode((Element)encrTok.getUnattachedReference(), true));
                    } else if (!rmd.isInitiator() && encrToken.isDerivedKeys()) {
                        SecurityTokenReference tokenRef = new SecurityTokenReference(doc);
                        if (encrTok instanceof EncryptedKeyToken) {
                            tokenRef.setKeyIdentifierEncKeySHA1(((EncryptedKeyToken)encrTok).getSHA1());
                        }
                        dkEncr.setExternalKey(encrTok.getSecret(), tokenRef.getElement());
                    } else {
                        dkEncr.setExternalKey(encrTok.getSecret(), encrTok.getId());
                    }
                    if (encrTok instanceof EncryptedKeyToken) {
                        dkEncr.setCustomValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                    }
                    dkEncr.setSymmetricEncAlgorithm(rpd.getAlgorithmSuite().getEncryption());
                    dkEncr.setDerivedKeyLength(rpd.getAlgorithmSuite().getEncryptionDerivedKeyLength() / 8);
                    dkEncr.prepare(doc);
                    Element encrDKTokenElem = null;
                    encrDKTokenElem = dkEncr.getdktElement();
                    if (encrTokElem != null) {
                        RampartUtil.insertSiblingAfter(rmd, encrTokElem, encrDKTokenElem);
                    } else if (this.timestampElement != null) {
                        RampartUtil.insertSiblingAfter(rmd, this.timestampElement, encrDKTokenElem);
                    } else {
                        RampartUtil.insertSiblingBefore(rmd, this.getInsertionLocation(), encrDKTokenElem);
                    }
                    refList = dkEncr.encryptForExternalRef(null, encrParts);
                    RampartUtil.insertSiblingAfter(rmd, encrDKTokenElem, refList);
                }
                catch (WSSecurityException e) {
                    throw new RampartException("errorInDKEncr");
                }
                catch (ConversationException e) {
                    throw new RampartException("errorInDKEncr");
                }
            }
            try {
                WSSecEncrypt encr = new WSSecEncrypt();
                encr.setWsConfig(rmd.getConfig());
                if (encrTokId.startsWith("#")) {
                    encrTokId = encrTokId.substring(1);
                }
                encr.setEncKeyId(encrTokId);
                encr.setEphemeralKey(encrTok.getSecret());
                RampartUtil.setEncryptionUser(rmd, (WSSecEncryptedKey)encr);
                encr.setDocument(doc);
                encr.setEncryptSymmKey(false);
                encr.setSymmetricEncAlgorithm(rpd.getAlgorithmSuite().getEncryption());
                if (!rmd.isInitiator() && encrTok instanceof EncryptedKeyToken) {
                    encr.setUseKeyIdentifier(true);
                    encr.setCustomReferenceValue(((EncryptedKeyToken)encrTok).getSHA1());
                    encr.setKeyIdentifierType(10);
                }
                encr.prepare(doc, RampartUtil.getEncryptionCrypto(rpd.getRampartConfig(), rmd.getCustomClassLoader()));
                refList = encr.encryptForExternalRef(null, encrParts);
                if (encrTokElem != null) {
                    RampartUtil.insertSiblingAfter(rmd, encrTokElem, refList);
                } else {
                    RampartUtil.insertSiblingBeforeOrPrepend(rmd, this.getInsertionLocation(), refList);
                }
            }
            catch (WSSecurityException e) {
                throw new RampartException("errorInEncryption", e);
            }
        }
        if (this.dotDebug) {
            t2 = System.currentTimeMillis();
            tlog.debug((Object)("Signature took :" + (t1 - t0) + ", Encryption took :" + (t2 - t1)));
        }
    }

    private String setupEncryptedKey(RampartMessageData rmd, Token sigToken) throws RampartException {
        try {
            WSSecEncryptedKey encrKey = this.getEncryptedKeyBuilder(rmd, sigToken);
            String id = encrKey.getId();
            byte[] secret = encrKey.getEphemeralKey();
            Date created = new Date();
            Date expires = new Date();
            expires.setTime(System.currentTimeMillis() + 300000L);
            EncryptedKeyToken tempTok = new EncryptedKeyToken(id, (OMElement)encrKey.getEncryptedKeyElement(), created, expires);
            tempTok.setSecret(secret);
            tempTok.setSHA1(this.getSHA1(encrKey.getEncryptedEphemeralKey()));
            rmd.getTokenStorage().add((org.apache.rahas.Token)tempTok);
            String bstTokenId = encrKey.getBSTTokenId();
            if (bstTokenId != null && bstTokenId.length() > 0) {
                RampartUtil.appendChildToSecHeader(rmd, encrKey.getBinarySecurityTokenElement());
            }
            return id;
        }
        catch (TrustException e) {
            throw new RampartException("errorInAddingTokenIntoStore");
        }
    }

    private String getSHA1(byte[] input) throws RampartException {
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e1) {
            throw new RampartException("noSHA1availabe", e1);
        }
        sha.reset();
        sha.update(input);
        byte[] data = sha.digest();
        return Base64.encode((byte[])data);
    }

    private String getEncryptedKey(RampartMessageData rmd) throws RampartException {
        Vector results = (Vector)rmd.getMsgContext().getProperty("RECV_RESULTS");
        for (int i = 0; i < results.size(); ++i) {
            WSHandlerResult rResult = (WSHandlerResult)results.get(i);
            Vector wsSecEngineResults = rResult.getResults();
            for (int j = 0; j < wsSecEngineResults.size(); ++j) {
                WSSecurityEngineResult wser = (WSSecurityEngineResult)wsSecEngineResults.get(j);
                Integer actInt = (Integer)wser.get((Object)"action");
                if (actInt != 4 || wser.get((Object)"encrypted-key-id") == null || ((String)wser.get((Object)"encrypted-key-id")).length() == 0) continue;
                try {
                    String encryptedKeyID = (String)wser.get((Object)"encrypted-key-id");
                    Date created = new Date();
                    Date expires = new Date();
                    expires.setTime(System.currentTimeMillis() + 300000L);
                    EncryptedKeyToken tempTok = new EncryptedKeyToken(encryptedKeyID, created, expires);
                    tempTok.setSecret((byte[])wser.get((Object)"decrypted-key"));
                    tempTok.setSHA1(this.getSHA1((byte[])wser.get(WSSecurityEngineResult.TAG_ENCRYPTED_EPHEMERAL_KEY)));
                    rmd.getTokenStorage().add((org.apache.rahas.Token)tempTok);
                    return encryptedKeyID;
                }
                catch (TrustException e) {
                    throw new RampartException("errorInAddingTokenIntoStore");
                }
            }
        }
        return null;
    }

    private void initializeTokens(RampartMessageData rmd) throws RampartException {
        RampartPolicyData rpd = rmd.getPolicyData();
        MessageContext msgContext = rmd.getMsgContext();
        if (rpd.isSymmetricBinding() && !msgContext.isServerSide()) {
            String id;
            IssuedToken issuedToken;
            log.debug((Object)"Processing symmetric binding: Setting up encryption token and signature token");
            Token sigTok = rpd.getSignatureToken();
            Token encrTok = rpd.getEncryptionToken();
            if (sigTok instanceof IssuedToken) {
                log.debug((Object)"SignatureToken is an IssuedToken");
                if (rmd.getIssuedSignatureTokenId() == null) {
                    log.debug((Object)"No Issuedtoken found, requesting a new token");
                    issuedToken = (IssuedToken)sigTok;
                    id = RampartUtil.getIssuedToken(rmd, issuedToken);
                    rmd.setIssuedSignatureTokenId(id);
                }
            } else if (sigTok instanceof SecureConversationToken) {
                boolean cancelReqResp;
                log.debug((Object)"SignatureToken is a SecureConversationToken");
                String secConvTokenId = rmd.getSecConvTokenId();
                String action = msgContext.getOptions().getAction();
                boolean bl = cancelReqResp = action.equals("http://schemas.xmlsoap.org/ws/2005/02/trust/RSTR/SCT/Cancel") || action.equals("http://schemas.xmlsoap.org/ws/2005/02/trust/RSTR/SCT/Cancel") || action.equals("http://schemas.xmlsoap.org/ws/2005/02/trust/RST/SCT/Cancel") || action.equals("http://schemas.xmlsoap.org/ws/2005/02/trust/RST/SCT/Cancel");
                if (secConvTokenId != null && cancelReqResp) {
                    try {
                        rmd.getTokenStorage().getToken(secConvTokenId).setState(3);
                        msgContext.setProperty("sctID", (Object)secConvTokenId);
                        String contextIdentifierKey = RampartUtil.getContextIdentifierKey(msgContext);
                        RampartUtil.getContextMap(msgContext).remove(contextIdentifierKey);
                    }
                    catch (TrustException e) {
                        throw new RampartException("errorExtractingToken");
                    }
                }
                if (secConvTokenId == null || secConvTokenId != null && !RampartUtil.isTokenValid(rmd, secConvTokenId) && !cancelReqResp) {
                    log.debug((Object)"No SecureConversationToken found, requesting a new token");
                    SecureConversationToken secConvTok = (SecureConversationToken)sigTok;
                    try {
                        String id2 = RampartUtil.getSecConvToken(rmd, secConvTok);
                        rmd.setSecConvTokenId(id2);
                    }
                    catch (TrustException e) {
                        throw new RampartException("errorInObtainingSct", e);
                    }
                }
            }
            if (sigTok.equals(encrTok) && sigTok instanceof IssuedToken) {
                log.debug((Object)"Symmetric binding uses a ProtectionToken, both SignatureToken and EncryptionToken are the same");
                rmd.setIssuedEncryptionTokenId(rmd.getIssuedEncryptionTokenId());
            } else {
                log.debug((Object)"Obtaining the Encryption Token");
                if (rmd.getIssuedEncryptionTokenId() != null) {
                    log.debug((Object)"EncrytionToken not alredy set");
                    issuedToken = (IssuedToken)encrTok;
                    id = RampartUtil.getIssuedToken(rmd, issuedToken);
                    rmd.setIssuedEncryptionTokenId(id);
                }
            }
        }
    }
}

