/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.throttle;

import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.All;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.builders.xml.XmlPrimtiveAssertion;
import org.wso2.throttle.CallerConfiguration;
import org.wso2.throttle.ConcurrentAccessController;
import org.wso2.throttle.Throttle;
import org.wso2.throttle.ThrottleConfiguration;
import org.wso2.throttle.ThrottleConstants;
import org.wso2.throttle.ThrottleException;
import org.wso2.throttle.factory.CallerConfigurationFactory;
import org.wso2.throttle.factory.ThrottleConfigurationFactory;
import org.wso2.throttle.factory.ThrottleContextFactory;

public class ThrottlePolicyProcessor {
    private static Log log = LogFactory.getLog((String)ThrottlePolicyProcessor.class.getName());

    public static Throttle processPolicy(Policy policy) throws ThrottleException {
        if (policy == null) {
            return null;
        }
        Throttle th = new Throttle();
        ThrottleConfiguration tc = null;
        List al = policy.getPolicyComponents();
        if (al == null || al != null && al.isEmpty()) {
            ThrottlePolicyProcessor.handleException("Empty the policy components as ThrottleAssertion's children");
        }
        Iterator i = al.iterator();
        while (i.hasNext()) {
            Object tp = i.next();
            if (tp instanceof All) {
                CallerConfiguration cn = null;
                boolean isIPRangeFound = false;
                boolean isExactlyOneFound = false;
                ExactlyOne cp = null;
                List cL = ((All)tp).getAssertions();
                if (cL != null) {
                    Iterator ci = cL.iterator();
                    while (ci.hasNext()) {
                        Object ca = ci.next();
                        if (ca instanceof XmlPrimtiveAssertion) {
                            XmlPrimtiveAssertion id = (XmlPrimtiveAssertion)ca;
                            OMElement el = id.getValue();
                            String t = el.getAttributeValue(ThrottleConstants.THROTTLE_TYPE_ATTRIBUTE_QNAME);
                            if (t == null) {
                                ThrottlePolicyProcessor.handleException("Type of Throtle in the policy cannot be null");
                            }
                            if (t.equals("IP")) {
                                tc = th.getThrottleConfiguration("key_of_ip_based_throttle");
                                if (tc == null) {
                                    tc = ThrottleConfigurationFactory.createThrottleConfiguration(0);
                                    th.addThrottleContext("key_of_ip_based_throttle", ThrottleContextFactory.createThrottleContext(0, tc));
                                    th.addThrottleConfiguration("key_of_ip_based_throttle", tc);
                                }
                                cn = CallerConfigurationFactory.createCallerConfiguration(0);
                            } else if (t.equals("DOMAIN")) {
                                tc = th.getThrottleConfiguration("key_of_domain_based_throttle");
                                if (tc == null) {
                                    tc = ThrottleConfigurationFactory.createThrottleConfiguration(1);
                                    th.addThrottleContext("key_of_domain_based_throttle", ThrottleContextFactory.createThrottleContext(1, tc));
                                    th.addThrottleConfiguration("key_of_domain_based_throttle", tc);
                                }
                                cn = CallerConfigurationFactory.createCallerConfiguration(1);
                            } else {
                                ThrottlePolicyProcessor.handleException("Unsupported throttle type : " + t);
                            }
                            if (cn == null) continue;
                            String n = el.getLocalName();
                            String v = el.getText();
                            if (n == null || v == null) {
                                ThrottlePolicyProcessor.handleException("Either Value or Name of the policy cannot be null");
                                continue;
                            }
                            if (n.equals("ID")) {
                                if (!v.equals("")) {
                                    isIPRangeFound = true;
                                    cn.setID(v);
                                    continue;
                                }
                                ThrottlePolicyProcessor.handleException("Value of ID cannot find - invalid configuration");
                                continue;
                            }
                            ThrottlePolicyProcessor.handleException("Undefined pocilcy property for throttle - Expect ID  ");
                            continue;
                        }
                        if (!(ca instanceof ExactlyOne)) continue;
                        cp = (ExactlyOne)ca;
                    }
                }
                if (cn != null) {
                    if (cp != null) {
                        List cal = cp.getPolicyComponents();
                        boolean haveSelectOneFromExactlyOne = false;
                        Iterator ci = cal.iterator();
                        while (ci.hasNext() && !haveSelectOneFromExactlyOne) {
                            Object co = ci.next();
                            if (co instanceof All) {
                                haveSelectOneFromExactlyOne = true;
                                boolean isFoundMaxCount = false;
                                boolean isFoundUnitTime = false;
                                All childAll = (All)co;
                                List cd = childAll.getPolicyComponents();
                                Iterator cdl = cd.iterator();
                                while (cdl.hasNext()) {
                                    Object d = cdl.next();
                                    if (!(d instanceof XmlPrimtiveAssertion)) continue;
                                    XmlPrimtiveAssertion adx = (XmlPrimtiveAssertion)d;
                                    OMElement el = adx.getValue();
                                    String n = el.getLocalName();
                                    String v = el.getText();
                                    if (n == null || v == null) {
                                        ThrottlePolicyProcessor.handleException("Either Value or Name of the policy cannot be null");
                                    }
                                    if (!v.equals("")) {
                                        if (n.equals("MaximumCount")) {
                                            isFoundMaxCount = true;
                                            try {
                                                cn.setMaximumRequestPerUnitTime(Integer.parseInt(v.trim()));
                                            }
                                            catch (NumberFormatException ignored) {
                                                log.error((Object)"Error occurred - Invalid number for maximum request number ", (Throwable)ignored);
                                                if (log.isDebugEnabled()) {
                                                    log.debug((Object)"Access will be fully allowed");
                                                }
                                                cn.setAccessState(2);
                                            }
                                            continue;
                                        }
                                        if (n.equals("UnitTime")) {
                                            long timeInMiliSec = 0L;
                                            try {
                                                timeInMiliSec = Long.parseLong(v.trim());
                                            }
                                            catch (NumberFormatException ignored) {
                                                log.error((Object)"Error occurred - Invalid number for unit time", (Throwable)ignored);
                                            }
                                            if (timeInMiliSec == 0L) {
                                                ThrottlePolicyProcessor.handleException("Unit Time cannot find - invalid throttle policy configuration");
                                            }
                                            isFoundUnitTime = true;
                                            cn.setUnitTime(timeInMiliSec);
                                            continue;
                                        }
                                        if (n.equals("ProhibitTimePeriod")) {
                                            try {
                                                cn.setProhibitTimePeriod(Long.parseLong(v.trim()));
                                            }
                                            catch (NumberFormatException ignored) {
                                                log.error((Object)"Error occurred - Invalid number for prohibit time ", (Throwable)ignored);
                                            }
                                            continue;
                                        }
                                        ThrottlePolicyProcessor.handleException("Undefined Policy property for Throttle Policy");
                                        continue;
                                    }
                                    if (n.equals("ProhibitTimePeriod")) continue;
                                    ThrottlePolicyProcessor.handleException("The policy which have  defined as optional should have value ");
                                }
                                if (isFoundUnitTime && isFoundMaxCount) {
                                    isExactlyOneFound = true;
                                    continue;
                                }
                                ThrottlePolicyProcessor.handleException("Maximum Count and UnitTime are Mandatory in Throttle Policy ");
                                continue;
                            }
                            if (!(co instanceof XmlPrimtiveAssertion)) continue;
                            haveSelectOneFromExactlyOne = true;
                            XmlPrimtiveAssertion alx = (XmlPrimtiveAssertion)co;
                            OMElement ele = alx.getValue();
                            String n = ele.getLocalName();
                            String v = ele.getText();
                            if (n == null || v == null) {
                                ThrottlePolicyProcessor.handleException("Either Value or Name of the policy cannot be null");
                                continue;
                            }
                            if (n.equals("IsAllow")) {
                                if (v.equals(Boolean.toString(true))) {
                                    isExactlyOneFound = true;
                                    cn.setAccessState(2);
                                    continue;
                                }
                                if (v.equals(Boolean.toString(false))) {
                                    isExactlyOneFound = true;
                                    cn.setAccessState(1);
                                    continue;
                                }
                                ThrottlePolicyProcessor.handleException("Value for isAllow  component is invalied");
                                continue;
                            }
                            ThrottlePolicyProcessor.handleException("Invalied Throttle Policy configuration");
                        }
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"Couldn't find a cn for a throttle configuration for an one caller  ");
                }
                if (isIPRangeFound && isExactlyOneFound) {
                    tc.addCallerConfiguration(cn);
                    continue;
                }
                ThrottlePolicyProcessor.handleException("ID and one of Valid Control policy component are Mandatory in Throttle Policy");
                continue;
            }
            if (!(tp instanceof XmlPrimtiveAssertion)) continue;
            XmlPrimtiveAssertion mca = (XmlPrimtiveAssertion)tp;
            OMElement ele = mca.getValue();
            String n = ele.getLocalName();
            String v = ele.getText();
            if (n == null || v == null) {
                ThrottlePolicyProcessor.handleException("Either Value or Name of the policy cannot be null");
                continue;
            }
            if (n.equals("MaximumConcurrentAccess")) {
                int intvalue = 0;
                try {
                    intvalue = Integer.parseInt(v.trim());
                }
                catch (NumberFormatException ignored) {
                    log.error((Object)"Error occurred - Invalid number for maximum concurrent access ", (Throwable)ignored);
                }
                if (intvalue <= 0) continue;
                th.setConcurrentAccessController(new ConcurrentAccessController(intvalue));
                continue;
            }
            ThrottlePolicyProcessor.handleException("Invalied Throttle Policy configuration");
        }
        return th;
    }

    private static void handleException(String message) throws ThrottleException {
        String msg = "Error was occurred during throttle policy processing  " + message;
        log.error((Object)msg);
        throw new ThrottleException(msg);
    }
}

