/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.http;

import java.util.Collection;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.commons.vfs.provider.http.HttpFileObject;
import org.apache.commons.vfs.provider.http.HttpFileProvider;
import org.apache.commons.vfs.provider.http.ThreadLocalHttpConnectionManager;

public class HttpFileSystem
extends AbstractFileSystem
implements FileSystem {
    private final HttpClient client;

    protected HttpFileSystem(GenericFileName rootName, HttpClient client, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
        this.client = client;
    }

    protected void addCapabilities(Collection caps) {
        caps.addAll(HttpFileProvider.capabilities);
    }

    protected HttpClient getClient() {
        return this.client;
    }

    public void closeCommunicationLink() {
        if (this.getClient() != null) {
            HttpConnectionManager mgr = this.getClient().getHttpConnectionManager();
            if (mgr instanceof ThreadLocalHttpConnectionManager) {
                ((ThreadLocalHttpConnectionManager)mgr).releaseLocalConnection();
            }
            if (mgr instanceof MultiThreadedHttpConnectionManager) {
                ((MultiThreadedHttpConnectionManager)mgr).shutdown();
            }
        }
    }

    protected FileObject createFile(FileName name) throws Exception {
        return new HttpFileObject(name, this);
    }
}

