/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.util.Messages;

public class FileSystemException
extends IOException {
    private static final Pattern URL_PATTERN = Pattern.compile("[a-z]+://.*");
    private static final Pattern PASSWORD_PATTERN = Pattern.compile(":(?:[^/]+)@");
    private final Throwable throwable;
    private final String code;
    private final String[] info;

    public FileSystemException(String code) {
        this(code, null, null);
    }

    public FileSystemException(String code, Object info0) {
        this(code, new Object[]{info0}, (Throwable)null);
    }

    public FileSystemException(String code, Object info0, Throwable throwable) {
        this(code, new Object[]{info0}, throwable);
    }

    public FileSystemException(String code, Object[] info) {
        this(code, info, (Throwable)null);
    }

    public FileSystemException(String code, Throwable throwable) {
        this(code, null, throwable);
    }

    public FileSystemException(String code, Object[] info, Throwable throwable) {
        super(code);
        if (info == null) {
            this.info = new String[0];
        } else {
            this.info = new String[info.length];
            for (int i = 0; i < info.length; ++i) {
                String value = String.valueOf(info[i]);
                Matcher urlMatcher = URL_PATTERN.matcher(value);
                if (urlMatcher.find()) {
                    Matcher pwdMatcher = PASSWORD_PATTERN.matcher(value);
                    value = pwdMatcher.replaceFirst(":***@");
                }
                this.info[i] = value;
            }
        }
        this.code = code;
        this.throwable = throwable;
    }

    public FileSystemException(Throwable throwable) {
        this(throwable.getMessage(), null, throwable);
    }

    public String getMessage() {
        return Messages.getString(super.getMessage(), this.getInfo());
    }

    public final Throwable getCause() {
        return this.throwable;
    }

    public String getCode() {
        return this.code;
    }

    public String[] getInfo() {
        return this.info;
    }
}

