/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.Factory;
import org.jruby.ext.ffi.NativeType;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::Type"}, parent="Object")
public abstract class Type
extends RubyObject {
    protected final NativeType nativeType;
    protected final int size;
    protected final int alignment;

    public static RubyClass createTypeClass(Ruby runtime2, RubyModule ffiModule) {
        RubyClass typeClass = ffiModule.defineClassUnder("Type", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        typeClass.defineAnnotatedMethods(Type.class);
        typeClass.defineAnnotatedConstants(Type.class);
        RubyClass builtinClass = typeClass.defineClassUnder("Builtin", typeClass, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        builtinClass.defineAnnotatedMethods(Builtin.class);
        RubyModule nativeType = ffiModule.defineModuleUnder("NativeType");
        for (NativeType t : NativeType.values()) {
            try {
                Builtin b = new Builtin(runtime2, builtinClass, t);
                typeClass.fastSetConstant(t.name(), b);
                nativeType.fastSetConstant(t.name(), b);
                ffiModule.fastSetConstant("TYPE_" + t.name(), b);
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
        }
        return typeClass;
    }

    protected Type(Ruby runtime2, RubyClass klass, NativeType type2, int size2, int alignment2) {
        super(runtime2, klass);
        this.nativeType = type2;
        this.size = size2;
        this.alignment = alignment2;
    }

    protected Type(Ruby runtime2, RubyClass klass, NativeType type2) {
        super(runtime2, klass);
        this.nativeType = type2;
        this.size = Type.getNativeSize(type2);
        this.alignment = Type.getNativeAlignment(type2);
    }

    public final NativeType getNativeType() {
        return this.nativeType;
    }

    public final int getNativeSize() {
        return this.size;
    }

    public final int getNativeAlignment() {
        return this.alignment;
    }

    @JRubyMethod(name={"size"})
    public IRubyObject size(ThreadContext context) {
        return context.getRuntime().newFixnum(this.getNativeSize());
    }

    @JRubyMethod(name={"alignment"})
    public IRubyObject alignment(ThreadContext context) {
        return context.getRuntime().newFixnum(this.getNativeAlignment());
    }

    private static final boolean isPrimitive(NativeType type2) {
        switch (type2) {
            case VOID: 
            case INT8: 
            case UINT8: 
            case INT16: 
            case UINT16: 
            case INT32: 
            case UINT32: 
            case INT64: 
            case UINT64: 
            case LONG: 
            case ULONG: 
            case FLOAT32: 
            case FLOAT64: 
            case BUFFER_IN: 
            case BUFFER_INOUT: 
            case BUFFER_OUT: 
            case POINTER: 
            case STRING: 
            case RBXSTRING: {
                return true;
            }
        }
        return false;
    }

    private static final int getNativeAlignment(NativeType type2) {
        return Type.isPrimitive(type2) ? Factory.getInstance().alignmentOf(type2) : 1;
    }

    private static final int getNativeSize(NativeType type2) {
        return Type.isPrimitive(type2) ? Factory.getInstance().sizeOf(type2) : 0;
    }

    @JRubyClass(name={"FFI::Type::Builtin"}, parent="FFI::Type")
    public static final class Builtin
    extends Type {
        private Builtin(Ruby runtime2, RubyClass klass, NativeType nativeType) {
            super(runtime2, klass, nativeType, Type.getNativeSize(nativeType), Type.getNativeAlignment(nativeType));
        }

        @JRubyMethod(name={"to_s"})
        public final IRubyObject to_s(ThreadContext context) {
            return RubyString.newString(context.getRuntime(), String.format("#<FFI::Type::Builtin:%s size=%d alignment=%d>", this.nativeType.name(), this.size, this.alignment));
        }

        public final String toString() {
            return this.nativeType.name();
        }

        public boolean equals(Object obj) {
            return obj instanceof Builtin && ((Builtin)obj).nativeType.equals(this.nativeType);
        }

        public int hashCode() {
            int hash2 = 5;
            hash2 = 23 * hash2 + this.nativeType.hashCode();
            return hash2;
        }
    }
}

