/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YieldNode
extends Node {
    private final Node argsNode;
    private final boolean expandedArguments;

    public YieldNode(ISourcePosition position, Node argsNode, boolean expandedArguments) {
        super(position);
        this.argsNode = argsNode;
        if (argsNode instanceof ArrayNode) {
            ((ArrayNode)argsNode).setLightweight(true);
        }
        this.expandedArguments = expandedArguments;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.YIELDNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitYieldNode(this);
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    @Deprecated
    public boolean getCheckState() {
        return this.expandedArguments;
    }

    public boolean getExpandArguments() {
        return this.expandedArguments;
    }

    @Override
    public List<Node> childNodes() {
        return YieldNode.createList(this.argsNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject result = null;
        Block block = context.getCurrentFrame().getBlock();
        if (this.expandedArguments) {
            if (this.argsNode != null && this.argsNode instanceof ArrayNode) {
                ArrayNode args2 = (ArrayNode)this.argsNode;
                switch (args2.size()) {
                    case 0: {
                        return block.yieldSpecific(context);
                    }
                    case 1: {
                        return block.yieldSpecific(context, args2.get(0).interpret(runtime2, context, self, aBlock));
                    }
                    case 2: {
                        return block.yieldSpecific(context, args2.get(0).interpret(runtime2, context, self, aBlock), args2.get(1).interpret(runtime2, context, self, aBlock));
                    }
                    case 3: {
                        return block.yieldSpecific(context, args2.get(0).interpret(runtime2, context, self, aBlock), args2.get(1).interpret(runtime2, context, self, aBlock), args2.get(2).interpret(runtime2, context, self, aBlock));
                    }
                }
            }
            if (this.argsNode != null) {
                result = this.argsNode.interpret(runtime2, context, self, aBlock);
            }
            return context.getCurrentFrame().getBlock().yield(context, result, null, null, true);
        }
        if (this.argsNode != null) {
            result = this.argsNode.interpret(runtime2, context, self, aBlock);
        }
        return context.getCurrentFrame().getBlock().yield(context, result);
    }

    @Override
    public String definition(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        return aBlock.isGiven() ? "yield" : null;
    }
}

