/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.base.MetricsCollector;
import org.apache.axis2.transport.http.HTTPTransportReceiver;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.synapse.transport.nhttp.HttpCoreRequestResponseTransport;
import org.apache.synapse.transport.nhttp.NHttpConfiguration;
import org.apache.synapse.transport.nhttp.ServerHandler;
import org.apache.synapse.transport.nhttp.util.NhttpUtil;
import org.apache.synapse.transport.nhttp.util.RESTUtil;
import org.apache.ws.commons.schema.XmlSchema;

public class ServerWorker
implements Runnable {
    private static final Log log = LogFactory.getLog(ServerWorker.class);
    private MessageContext msgContext = null;
    private ConfigurationContext cfgCtx = null;
    private ServerHandler serverHandler = null;
    private NHttpServerConnection conn = null;
    private boolean isHttps = false;
    private HttpRequest request = null;
    private HttpResponse response = null;
    private InputStream is = null;
    private OutputStream os = null;
    private MetricsCollector metrics = null;
    private static final String SOAPACTION = "SOAPAction";
    private static final String LOCATION = "Location";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String TEXT_HTML = "text/html";
    private static final String TEXT_XML = "text/xml";
    private String remoteAddress = null;

    public ServerWorker(ConfigurationContext cfgCtx, NHttpServerConnection conn, boolean isHttps, MetricsCollector metrics, ServerHandler serverHandler, HttpRequest request, InputStream is, HttpResponse response, OutputStream os) {
        this.cfgCtx = cfgCtx;
        this.conn = conn;
        this.isHttps = isHttps;
        this.metrics = metrics;
        this.serverHandler = serverHandler;
        this.request = request;
        this.response = response;
        this.is = is;
        this.os = os;
        this.msgContext = this.createMessageContext(request);
    }

    private MessageContext createMessageContext(HttpRequest request) {
        HttpInetConnection inetConn;
        InetAddress remoteAddr;
        MessageContext msgContext = new MessageContext();
        msgContext.setMessageID(UIDGenerator.generateURNString());
        msgContext.setProperty("transportNonBlocking", (Object)Boolean.FALSE);
        msgContext.setConfigurationContext(this.cfgCtx);
        if (this.isHttps) {
            msgContext.setTransportOut(this.cfgCtx.getAxisConfiguration().getTransportOut("https"));
            msgContext.setTransportIn(this.cfgCtx.getAxisConfiguration().getTransportIn("https"));
            msgContext.setIncomingTransportName("https");
        } else {
            msgContext.setTransportOut(this.cfgCtx.getAxisConfiguration().getTransportOut("http"));
            msgContext.setTransportIn(this.cfgCtx.getAxisConfiguration().getTransportIn("http"));
            msgContext.setIncomingTransportName("http");
        }
        msgContext.setProperty("OutTransportInfo", (Object)this);
        msgContext.setServerSide(true);
        msgContext.setProperty("TransportInURL", (Object)request.getRequestLine().getUri());
        TreeMap<String, String> headers = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        for (Header header : request.getAllHeaders()) {
            headers.put(header.getName(), header.getValue());
        }
        msgContext.setProperty("TRANSPORT_HEADERS", headers);
        if (this.conn instanceof HttpInetConnection && (remoteAddr = (inetConn = (HttpInetConnection)this.conn).getRemoteAddress()) != null) {
            msgContext.setProperty("REMOTE_ADDR", (Object)remoteAddr.getHostAddress());
            msgContext.setProperty("REMOTE_HOST", (Object)NhttpUtil.getHostName(remoteAddr));
            this.remoteAddress = remoteAddr.getHostAddress();
        }
        msgContext.setProperty("RequestResponseTransportControl", (Object)new HttpCoreRequestResponseTransport(msgContext));
        msgContext.setProperty("synapse.server-connection-debug", this.conn.getContext().getAttribute("synapse.server-connection-debug"));
        return msgContext;
    }

    public void run() {
        HttpInetConnection inetConn;
        InetAddress localAddr;
        int pos;
        String uri;
        String method = this.request.getRequestLine().getMethod().toUpperCase();
        this.msgContext.setProperty("HTTP_METHOD", (Object)this.request.getRequestLine().getMethod());
        if (NHttpConfiguration.getInstance().isHttpMethodDisabled(method)) {
            this.handleException("Unsupported method : " + method, null);
        }
        String oriUri = uri = this.request.getRequestLine().getUri();
        if (uri.indexOf(this.cfgCtx.getServicePath()) != -1) {
            pos = (uri = uri.substring(uri.indexOf(this.cfgCtx.getServicePath()) + this.cfgCtx.getServicePath().length())).indexOf("/", 1);
            uri = pos > 0 ? uri.substring(pos) : ((pos = uri.indexOf("?")) != -1 ? uri.substring(pos) : "");
        } else {
            pos = uri.indexOf("://");
            if (pos != -1 && (pos = (uri = uri.substring(pos + 3)).indexOf("/")) != -1) {
                uri = uri.substring(pos + 1);
            }
        }
        this.msgContext.setProperty("REST_URL_POSTFIX", (Object)uri);
        String servicePrefix = oriUri.substring(0, oriUri.indexOf(uri));
        if (servicePrefix.indexOf("://") == -1 && (localAddr = (inetConn = (HttpInetConnection)this.conn).getLocalAddress()) != null) {
            servicePrefix = (this.isHttps ? "https://" : "http://") + localAddr.getHostName() + ":" + inetConn.getLocalPort() + servicePrefix;
        }
        this.msgContext.setProperty("SERVICE_PREFIX", (Object)servicePrefix);
        if ("GET".equals(method)) {
            this.processGet();
        } else if ("POST".equals(method)) {
            this.processEntityEnclosingMethod();
        } else if ("PUT".equals(method)) {
            this.processEntityEnclosingMethod();
        } else if ("HEAD".equals(method)) {
            this.processNonEntityEnclosingMethod();
        } else if ("OPTIONS".equals(method)) {
            this.processNonEntityEnclosingMethod();
        } else if ("DELETE".equals(method)) {
            this.processGetAndDelete("DELETE");
        } else if ("TRACE".equals(method)) {
            this.processNonEntityEnclosingMethod();
        } else {
            this.handleException("Unsupported method : " + method, null);
        }
        if (this.isAckRequired()) {
            String respWritten = "";
            if (this.msgContext.getOperationContext() != null) {
                respWritten = (String)this.msgContext.getOperationContext().getProperty("RESPONSE_WRITTEN");
            }
            boolean respWillFollow = !"true".equals(respWritten) && !"SKIP".equals(respWritten);
            boolean acked = ((RequestResponseTransport)this.msgContext.getProperty("RequestResponseTransportControl")).getStatus() == RequestResponseTransport.RequestResponseTransportStatus.ACKED;
            boolean forced = this.msgContext.isPropertyTrue("FORCE_SC_ACCEPTED");
            boolean nioAck = this.msgContext.isPropertyTrue("NIO-ACK-Requested", false);
            if (respWillFollow || acked || forced || nioAck) {
                if (!nioAck) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Sending 202 Accepted response for MessageID : " + this.msgContext.getMessageID() + " response written : " + respWritten + " response will follow : " + respWillFollow + " acked : " + acked + " forced ack : " + forced));
                    }
                    this.response.setStatusCode(202);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Sending ACK response with status " + this.msgContext.getProperty("HTTP_SC") + ", for MessageID : " + this.msgContext.getMessageID()));
                    }
                    this.response.setStatusCode(Integer.parseInt(this.msgContext.getProperty("HTTP_SC").toString()));
                    Map responseHeaders = (Map)this.msgContext.getProperty("TRANSPORT_HEADERS");
                    if (responseHeaders != null) {
                        for (Map.Entry entry : responseHeaders.entrySet()) {
                            this.response.addHeader((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                }
                if (this.metrics != null) {
                    this.metrics.incrementMessagesSent();
                }
                try {
                    this.serverHandler.commitResponse(this.conn, this.response);
                }
                catch (HttpException e) {
                    if (this.metrics != null) {
                        this.metrics.incrementFaultsSending();
                    }
                    this.handleException("Unexpected HTTP protocol error : " + e.getMessage(), (Exception)((Object)e));
                }
                catch (ConnectionClosedException e) {
                    if (this.metrics != null) {
                        this.metrics.incrementFaultsSending();
                    }
                    log.warn((Object)"Connection closed by client (Connection closed)");
                }
                catch (IllegalStateException e) {
                    if (this.metrics != null) {
                        this.metrics.incrementFaultsSending();
                    }
                    log.warn((Object)"Connection closed by client (Buffer closed)");
                }
                catch (IOException e) {
                    if (this.metrics != null) {
                        this.metrics.incrementFaultsSending();
                    }
                    this.handleException("IO Error sending response message", e);
                }
                catch (Exception e) {
                    if (this.metrics != null) {
                        this.metrics.incrementFaultsSending();
                    }
                    this.handleException("General Error sending response message", e);
                }
                if (this.is != null) {
                    try {
                        this.is.close();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
                try {
                    this.os.flush();
                    this.os.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isAckRequired() {
        if (this.msgContext != null) {
            if (this.msgContext.getOperationContext() != null && (!this.msgContext.getOperationContext().getAxisOperation().isControlOperation() || this.msgContext.isPropertyTrue("FORCE_SC_ACCEPTED"))) {
                return true;
            }
            if (this.msgContext.isPropertyTrue("NIO-ACK-Requested", false)) {
                return true;
            }
        }
        return false;
    }

    private void processEntityEnclosingMethod() {
        try {
            Header contentType = this.request.getFirstHeader(CONTENT_TYPE);
            String contentTypeStr = contentType != null ? contentType.getValue() : this.inferContentType();
            String charSetEncoding = BuilderUtil.getCharSetEncoding((String)contentTypeStr);
            this.msgContext.setProperty("CHARACTER_SET_ENCODING", (Object)charSetEncoding);
            if (HTTPTransportUtils.isRESTRequest((String)contentTypeStr)) {
                RESTUtil.processPOSTRequest(this.msgContext, this.is, this.os, this.request.getRequestLine().getUri(), contentType);
            } else {
                Header soapAction = this.request.getFirstHeader(SOAPACTION);
                HTTPTransportUtils.processHTTPPostRequest((MessageContext)this.msgContext, (InputStream)this.is, (OutputStream)this.os, (String)contentTypeStr, (String)(soapAction != null ? soapAction.getValue() : null), (String)this.request.getRequestLine().getUri());
            }
        }
        catch (AxisFault e) {
            this.handleException("Error processing POST request ", (Exception)((Object)e));
        }
    }

    private String inferContentType() {
        Parameter param = this.cfgCtx.getAxisConfiguration().getParameter("DEFAULT_REQUEST_CONTENT_TYPE");
        if (param != null) {
            return param.getValue().toString();
        }
        return null;
    }

    private void processNonEntityEnclosingMethod() {
        try {
            RESTUtil.processURLRequest(this.msgContext, this.os, null, this.request.getRequestLine().getUri());
        }
        catch (AxisFault e) {
            this.handleException("Error processing " + this.request.getRequestLine().getMethod() + " request for : " + this.request.getRequestLine().getUri(), (Exception)((Object)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processGet() {
        block42: {
            String parameterValue;
            AxisService service;
            HashMap<String, String> parameters;
            String serviceName;
            String servicePath;
            String uri;
            block43: {
                block44: {
                    ByteArrayOutputStream baos;
                    block41: {
                        int opnStart;
                        uri = this.request.getRequestLine().getUri();
                        servicePath = this.cfgCtx.getServiceContextPath();
                        if (!servicePath.startsWith("/")) {
                            servicePath = "/" + servicePath;
                        }
                        serviceName = null;
                        if (uri.startsWith(servicePath)) {
                            serviceName = uri.substring(servicePath.length());
                            if (serviceName.startsWith("/")) {
                                serviceName = serviceName.substring(1);
                            }
                            if (serviceName.indexOf("?") != -1) {
                                serviceName = serviceName.substring(0, serviceName.indexOf("?"));
                            }
                        }
                        if (serviceName != null && (opnStart = serviceName.indexOf("/")) != -1) {
                            serviceName = serviceName.substring(0, opnStart);
                        }
                        parameters = new HashMap<String, String>();
                        int pos = uri.indexOf("?");
                        if (pos == -1) {
                            this.msgContext.setTo(new EndpointReference(uri));
                        } else {
                            this.msgContext.setTo(new EndpointReference(uri.substring(0, pos)));
                            StringTokenizer st = new StringTokenizer(uri.substring(pos + 1), "&");
                            while (st.hasMoreTokens()) {
                                String param = st.nextToken();
                                pos = param.indexOf("=");
                                if (pos != -1) {
                                    parameters.put(param.substring(0, pos), param.substring(pos + 1));
                                    continue;
                                }
                                parameters.put(param, null);
                            }
                        }
                        if (!uri.equals("/favicon.ico")) break block41;
                        this.response.setStatusCode(301);
                        this.response.addHeader(LOCATION, "http://ws.apache.org/favicon.ico");
                        this.serverHandler.commitResponseHideExceptions(this.conn, this.response);
                        break block42;
                    }
                    if (serviceName != null && parameters.containsKey("wsdl")) {
                        service = (AxisService)this.cfgCtx.getAxisConfiguration().getServices().get(serviceName);
                        if (service == null) {
                            this.processGetAndDelete("GET");
                            return;
                        }
                        try {
                            baos = new ByteArrayOutputStream();
                            String parameterValue2 = (String)parameters.get("wsdl");
                            if (parameterValue2 == null) {
                                service.printWSDL((OutputStream)baos, ServerWorker.getIpAddress());
                            } else {
                                service.printUserWSDL((OutputStream)baos, parameterValue2);
                            }
                            this.response.addHeader(CONTENT_TYPE, TEXT_XML);
                            this.serverHandler.commitResponseHideExceptions(this.conn, this.response);
                            this.os.write(baos.toByteArray());
                        }
                        catch (Exception e) {
                            this.handleBrowserException("Error generating ?wsdl output for service : " + serviceName, e);
                            return;
                        }
                    }
                    if (serviceName != null && parameters.containsKey("wsdl2")) {
                        service = (AxisService)this.cfgCtx.getAxisConfiguration().getServices().get(serviceName);
                        if (service == null) {
                            this.processGetAndDelete("GET");
                            return;
                        }
                        parameterValue = (String)service.getParameterValue("serviceType");
                        if ("proxy".equals(parameterValue) && !this.isWSDLProvidedForProxyService(service)) {
                            this.handleBrowserException("No WSDL was provided for the Service " + serviceName + ". A WSDL cannot be generated.", null);
                            return;
                        }
                        try {
                            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
                            service.printWSDL2((OutputStream)baos2, ServerWorker.getIpAddress());
                            this.response.addHeader(CONTENT_TYPE, TEXT_XML);
                            this.serverHandler.commitResponseHideExceptions(this.conn, this.response);
                            this.os.write(baos2.toByteArray());
                        }
                        catch (Exception e) {
                            this.handleBrowserException("Error generating ?wsdl2 output for service : " + serviceName, e);
                            return;
                        }
                    }
                    if (serviceName == null || !parameters.containsKey("xsd")) break block43;
                    if (parameters.get("xsd") != null && !"".equals(parameters.get("xsd"))) break block44;
                    service = (AxisService)this.cfgCtx.getAxisConfiguration().getServices().get(serviceName);
                    if (service != null) {
                        try {
                            baos = new ByteArrayOutputStream();
                            service.printSchema((OutputStream)baos);
                            this.response.addHeader(CONTENT_TYPE, TEXT_XML);
                            this.serverHandler.commitResponseHideExceptions(this.conn, this.response);
                            this.os.write(baos.toByteArray());
                        }
                        catch (Exception e) {
                            this.handleBrowserException("Error generating ?xsd output for service : " + serviceName, e);
                            return;
                        }
                    }
                    break block42;
                }
                String schemaName = (String)parameters.get("xsd");
                AxisService service2 = (AxisService)this.cfgCtx.getAxisConfiguration().getServices().get(serviceName);
                if (service2 != null) {
                    int dotIndex;
                    service2.populateSchemaMappings();
                    Map schemaTable = service2.getSchemaMappingTable();
                    XmlSchema schema = (XmlSchema)schemaTable.get(schemaName);
                    if (schema == null && (dotIndex = schemaName.indexOf(46)) > 0) {
                        String schemaKey = schemaName.substring(0, dotIndex);
                        schema = (XmlSchema)schemaTable.get(schemaKey);
                    }
                    if (schema != null) {
                        try {
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            schema.write((OutputStream)baos);
                            this.response.addHeader(CONTENT_TYPE, TEXT_XML);
                            this.serverHandler.commitResponseHideExceptions(this.conn, this.response);
                            this.os.write(baos.toByteArray());
                        }
                        catch (Exception e) {
                            this.handleBrowserException("Error generating named ?xsd output for service : " + serviceName, e);
                            return;
                        }
                    } else {
                        this.response.setStatusCode(404);
                    }
                }
                break block42;
            }
            if (serviceName != null && parameters.containsKey("info")) {
                service = (AxisService)this.cfgCtx.getAxisConfiguration().getServices().get(serviceName);
                if (service == null) {
                    this.handleBrowserException("Invalid service : " + serviceName, null);
                    return;
                }
                parameterValue = (String)service.getParameterValue("serviceType");
                if ("proxy".equals(parameterValue) && !this.isWSDLProvidedForProxyService(service)) {
                    this.handleBrowserException("No WSDL was provided for the Service " + serviceName + ". A WSDL cannot be generated.", null);
                    return;
                }
                try {
                    byte[] bytes = HTTPTransportReceiver.printServiceHTML((String)serviceName, (ConfigurationContext)this.cfgCtx).getBytes();
                    this.response.addHeader(CONTENT_TYPE, TEXT_HTML);
                    this.serverHandler.commitResponseHideExceptions(this.conn, this.response);
                    this.os.write(bytes);
                }
                catch (IOException e) {
                    this.handleBrowserException("Error generating service details page for : " + serviceName, e);
                    return;
                }
            } else if (uri.startsWith(servicePath) && (serviceName == null || serviceName.length() == 0)) {
                try {
                    byte[] bytes = this.getServicesHTML(servicePath.endsWith("/") ? "" : servicePath + "/").getBytes();
                    this.response.addHeader(CONTENT_TYPE, TEXT_HTML);
                    this.serverHandler.commitResponseHideExceptions(this.conn, this.response);
                    this.os.write(bytes);
                }
                catch (IOException e) {
                    this.handleBrowserException("Error generating services list", e);
                }
            } else {
                this.processGetAndDelete("GET");
                return;
            }
        }
        try {
            this.os.flush();
            this.os.close();
            return;
        }
        catch (IOException ignore) {
            // empty catch block
        }
    }

    private void processGetAndDelete(String method) {
        try {
            RESTUtil.processGetAndDeleteRequest(this.msgContext, this.os, this.request.getRequestLine().getUri(), this.request.getFirstHeader(CONTENT_TYPE), method);
        }
        catch (AxisFault axisFault) {
            this.handleException("Error processing " + method + " request for: " + this.request.getRequestLine().getUri(), (Exception)((Object)axisFault));
        }
    }

    private void handleBrowserException(String msg, Exception e) {
        if (e == null) {
            log.error((Object)msg);
        } else {
            log.error((Object)msg, (Throwable)e);
        }
        if (!this.response.containsHeader("Transfer-Encoding")) {
            this.response.setStatusCode(500);
            this.response.setReasonPhrase(msg);
            this.response.addHeader(CONTENT_TYPE, TEXT_HTML);
            this.serverHandler.commitResponseHideExceptions(this.conn, this.response);
            try {
                this.os.write(msg.getBytes());
                this.os.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        if (this.conn != null) {
            try {
                this.conn.shutdown();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void handleException(String msg, Exception e) {
        block10: {
            if (e == null) {
                log.error((Object)msg);
            } else {
                log.error((Object)msg, (Throwable)e);
            }
            if (e == null) {
                e = new Exception(msg);
            }
            try {
                MessageContext faultContext = MessageContextBuilder.createFaultMessageContext((MessageContext)this.msgContext, (Throwable)e);
                AxisEngine.sendFault((MessageContext)faultContext);
            }
            catch (Exception ex) {
                this.response.setStatusCode(500);
                this.response.addHeader(CONTENT_TYPE, TEXT_XML);
                this.serverHandler.commitResponseHideExceptions(this.conn, this.response);
                try {
                    this.os.write(msg.getBytes());
                    if (ex != null) {
                        this.os.write(ex.getMessage().getBytes());
                    }
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                if (this.conn == null) break block10;
                try {
                    this.conn.shutdown();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isWSDLProvidedForProxyService(AxisService service) {
        boolean isWSDLProvided = false;
        if (service.getParameterValue("wsdl4jDefinition") != null || service.getParameterValue("WSDL20Description") != null) {
            isWSDLProvided = true;
        }
        return isWSDLProvided;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public InputStream getIs() {
        return this.is;
    }

    public ServerHandler getServiceHandler() {
        return this.serverHandler;
    }

    public NHttpServerConnection getConn() {
        return this.conn;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    private static String getIpAddress() throws SocketException {
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        String address = "127.0.0.1";
        while (e.hasMoreElements()) {
            NetworkInterface netface = e.nextElement();
            Enumeration<InetAddress> addresses = netface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress ip = addresses.nextElement();
                if (ip.isLoopbackAddress() || !ServerWorker.isIP(ip.getHostAddress())) continue;
                return ip.getHostAddress();
            }
        }
        return address;
    }

    private static boolean isIP(String hostAddress) {
        return hostAddress.split("[.]").length == 4;
    }

    public String getServicesHTML(String prefix) {
        HashMap services = this.cfgCtx.getAxisConfiguration().getServices();
        Hashtable erroneousServices = this.cfgCtx.getAxisConfiguration().getFaultyServices();
        boolean servicesFound = false;
        StringBuffer resultBuf = new StringBuffer();
        resultBuf.append("<html><head><title>Axis2: Services</title></head><body>");
        if (services != null && !services.isEmpty()) {
            servicesFound = true;
            resultBuf.append("<h2>Deployed services</h2>");
            for (Object service : services.values()) {
                AxisService axisService = (AxisService)service;
                Parameter parameter = axisService.getParameter("hiddenService");
                if (axisService.getName().startsWith("__") || parameter != null && JavaUtils.isTrueExplicitly((Object)parameter.getValue())) continue;
                Iterator iterator = axisService.getOperations();
                resultBuf.append("<h3><a href=\"").append(prefix).append(axisService.getName()).append("?wsdl\">").append(axisService.getName()).append("</a></h3>");
                if (iterator.hasNext()) {
                    resultBuf.append("Available operations <ul>");
                    while (iterator.hasNext()) {
                        AxisOperation axisOperation = (AxisOperation)iterator.next();
                        resultBuf.append("<li>").append(axisOperation.getName().getLocalPart()).append("</li>");
                    }
                    resultBuf.append("</ul>");
                    continue;
                }
                resultBuf.append("No operations specified for this service");
            }
        }
        if (erroneousServices != null && !erroneousServices.isEmpty()) {
            servicesFound = true;
            resultBuf.append("<hr><h2><font color=\"blue\">Faulty Services</font></h2>");
            Enumeration faultyservices = erroneousServices.keys();
            while (faultyservices.hasMoreElements()) {
                String faultyserviceName = (String)faultyservices.nextElement();
                resultBuf.append("<h3><font color=\"blue\">").append(faultyserviceName).append("</font></h3>");
            }
        }
        if (!servicesFound) {
            resultBuf.append("<h2>There are no services deployed</h2>");
        }
        resultBuf.append("</body></html>");
        return resultBuf.toString();
    }
}

