/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMException;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.synapse.transport.nhttp.debug.ClientConnectionDebug;

public class ClientWorker
implements Runnable {
    private static final Log log = LogFactory.getLog(ClientWorker.class);
    private ConfigurationContext cfgCtx = null;
    private MessageContext responseMsgCtx = null;
    private InputStream in = null;
    private HttpResponse response = null;
    private String endpointURLPrefix = null;

    public ClientWorker(ConfigurationContext cfgCtx, InputStream in, HttpResponse response, MessageContext outMsgCtx, String endpointURLPrefix) {
        this.cfgCtx = cfgCtx;
        this.in = in;
        this.response = response;
        this.endpointURLPrefix = endpointURLPrefix;
        try {
            this.responseMsgCtx = outMsgCtx.getOperationContext().getMessageContext("In");
            if (this.responseMsgCtx != null) {
                this.responseMsgCtx.setSoapAction("");
            }
        }
        catch (AxisFault af) {
            log.error((Object)"Error getting IN message context from the operation context", (Throwable)af);
            return;
        }
        if (this.responseMsgCtx == null && outMsgCtx.getOperationContext().isComplete()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error getting IN message context from the operation context. Possibly an RM terminate sequence message");
            }
        } else {
            if (this.responseMsgCtx == null) {
                this.responseMsgCtx = new MessageContext();
                this.responseMsgCtx.setOperationContext(outMsgCtx.getOperationContext());
            }
            this.responseMsgCtx.setServerSide(true);
            this.responseMsgCtx.setDoingREST(outMsgCtx.isDoingREST());
            this.responseMsgCtx.setProperty("TRANSPORT_IN", outMsgCtx.getProperty("TRANSPORT_IN"));
            this.responseMsgCtx.setTransportIn(outMsgCtx.getTransportIn());
            this.responseMsgCtx.setTransportOut(outMsgCtx.getTransportOut());
            Header[] headers = response.getAllHeaders();
            if (headers != null && headers.length > 0) {
                TreeMap<String, String> headerMap = new TreeMap<String, String>(new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareToIgnoreCase(o2);
                    }
                });
                for (int i = 0; i < headers.length; ++i) {
                    Header header = headers[i];
                    if ("Location".equals(header.getName()) && endpointURLPrefix != null && outMsgCtx.getProperty("SERVICE_PREFIX") != null) {
                        headerMap.put(header.getName(), header.getValue().replaceAll(endpointURLPrefix, (String)outMsgCtx.getProperty("SERVICE_PREFIX")));
                        continue;
                    }
                    headerMap.put(header.getName(), header.getValue());
                }
                this.responseMsgCtx.setProperty("TRANSPORT_HEADERS", headerMap);
            }
            this.responseMsgCtx.setAxisMessage(outMsgCtx.getOperationContext().getAxisOperation().getMessage("In"));
            this.responseMsgCtx.setOperationContext(outMsgCtx.getOperationContext());
            this.responseMsgCtx.setConfigurationContext(outMsgCtx.getConfigurationContext());
            this.responseMsgCtx.setTo(null);
            ClientConnectionDebug cd = (ClientConnectionDebug)outMsgCtx.getProperty("synapse.client-connection-debug");
            if (cd != null) {
                this.responseMsgCtx.setProperty("synapse.client-connection-debug", (Object)cd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block31: {
            if (this.responseMsgCtx == null) {
                return;
            }
            try {
                if (this.in != null) {
                    SOAPEnvelope envelope;
                    Header cType = this.response.getFirstHeader("Content-Type");
                    String contentType = cType != null ? cType.getValue() : this.inferContentType();
                    String charSetEnc = BuilderUtil.getCharSetEncoding((String)contentType);
                    if (charSetEnc == null) {
                        charSetEnc = "UTF-8";
                    }
                    this.responseMsgCtx.setProperty("CHARACTER_SET_ENCODING", (Object)charSetEnc);
                    this.responseMsgCtx.setServerSide(false);
                    try {
                        envelope = TransportUtils.createSOAPMessage((MessageContext)this.responseMsgCtx, (InputStream)HTTPTransportUtils.handleGZip((MessageContext)this.responseMsgCtx, (InputStream)this.in), (String)contentType);
                    }
                    catch (OMException e) {
                        String errorMessage = "Unexpected response received. HTTP response code : " + this.response.getStatusLine().getStatusCode() + " HTTP status : " + this.response.getStatusLine().getReasonPhrase() + " exception : " + e.getMessage();
                        log.warn((Object)errorMessage);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)errorMessage, (Throwable)e);
                            log.debug((Object)"Creating the SOAPFault to be injected...");
                        }
                        SOAP11Factory factory = new SOAP11Factory();
                        envelope = factory.getDefaultFaultEnvelope();
                        SOAPFaultDetail detail = factory.createSOAPFaultDetail();
                        detail.setText(errorMessage);
                        envelope.getBody().getFault().setDetail(detail);
                        SOAPFaultReason reason = factory.createSOAPFaultReason();
                        reason.setText(errorMessage);
                        envelope.getBody().getFault().setReason(reason);
                        SOAPFaultCode code = factory.createSOAPFaultCode();
                        code.setText(Integer.toString(this.response.getStatusLine().getStatusCode()));
                        envelope.getBody().getFault().setCode(code);
                    }
                    this.responseMsgCtx.setServerSide(true);
                    this.responseMsgCtx.setEnvelope(envelope);
                } else {
                    this.responseMsgCtx.setProperty("NO_ENTITY_BODY", (Object)Boolean.TRUE);
                    this.responseMsgCtx.setEnvelope(new SOAP11Factory().getDefaultEnvelope());
                }
                int statusCode = this.response.getStatusLine().getStatusCode();
                this.responseMsgCtx.setProperty("HTTP_SC", (Object)statusCode);
                if (statusCode >= 400) {
                    this.responseMsgCtx.setProperty("FAULT_MESSAGE", (Object)"TRUE");
                }
                this.responseMsgCtx.setProperty("NonBlockingTransport", (Object)true);
                if (this.endpointURLPrefix != null) {
                    this.responseMsgCtx.setProperty("ENDPOINT_PREFIX", (Object)this.endpointURLPrefix);
                }
                try {
                    AxisEngine.receive((MessageContext)this.responseMsgCtx);
                }
                catch (AxisFault af) {
                    log.error((Object)"Fault processing response message through Axis2", (Throwable)af);
                }
            }
            catch (AxisFault af) {
                log.error((Object)"Fault creating response SOAP envelope", (Throwable)af);
                return;
            }
            catch (XMLStreamException e) {
                log.error((Object)"Error creating response SOAP envelope", (Throwable)e);
            }
            catch (IOException e2) {
                log.error((Object)"Error closing input stream from which message was read", (Throwable)e2);
                break block31;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                try {
                    if (this.in != null) {
                        this.in.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String inferContentType() {
        Object cTypeProperty = this.responseMsgCtx.getProperty("CONTENT_TYPE");
        if (cTypeProperty != null) {
            return cTypeProperty.toString();
        }
        Parameter cTypeParam = this.cfgCtx.getAxisConfiguration().getParameter("CONTENT_TYPE");
        if (cTypeParam != null) {
            return cTypeParam.getValue().toString();
        }
        return "application/octet-stream";
    }
}

