/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.store;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.MessageContext;
import org.apache.synapse.message.store.MessageStore;
import org.apache.synapse.message.store.StorableMessage;

public class RedeliveryProcessor {
    private static final Log log = LogFactory.getLog(RedeliveryProcessor.class);
    private MessageStore messageStore;
    private int maxRedeleveries = 1;
    private int redeliveryDelay = 2000;
    private boolean exponentialBackoff = false;
    private int backOffMultiplier = -1;
    private transient boolean start;

    public RedeliveryProcessor(MessageStore messageStore) {
        this.messageStore = messageStore;
    }

    public MessageStore getMessageStore() {
        return this.messageStore;
    }

    public void start() {
        try {
            Thread.sleep(this.redeliveryDelay);
        }
        catch (InterruptedException e) {
            log.error((Object)e);
        }
        Thread t = new Thread(new Worker());
        this.start = true;
        t.start();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Redelivery Started");
        }
    }

    public void stop() {
        this.start = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Redelivery Stopped");
        }
    }

    public void setRedeliveryDelay(int redeliveryDelay) {
        this.redeliveryDelay = redeliveryDelay;
    }

    public void setMaxRedeleveries(int maxRedeleveries) {
        this.maxRedeleveries = maxRedeleveries;
    }

    public boolean isStarted() {
        return this.start;
    }

    public boolean isExponentialBackoffEnable() {
        return this.exponentialBackoff;
    }

    public void setExponentialBackoff(boolean exponentialBackoff) {
        this.exponentialBackoff = exponentialBackoff;
    }

    public int getBackOffMultiplier() {
        return this.backOffMultiplier;
    }

    public void setBackOffMultiplier(int backOffMultiplier) {
        this.backOffMultiplier = backOffMultiplier;
    }

    public int getMaxRedeleveries() {
        return this.maxRedeleveries;
    }

    public int getRedeliveryDelay() {
        return this.redeliveryDelay;
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (RedeliveryProcessor.this.start) {
                MessageStore messageStore = RedeliveryProcessor.this.messageStore;
                synchronized (messageStore) {
                    int delay = RedeliveryProcessor.this.redeliveryDelay;
                    StorableMessage storableMessage = RedeliveryProcessor.this.messageStore.getFirstSheduledMessage();
                    if (storableMessage == null || storableMessage.getEndpoint() == null || !storableMessage.getEndpoint().readyToSend()) {
                        continue;
                    }
                    RedeliveryProcessor.this.messageStore.dequeueScheduledQueue();
                    MessageContext synCtx = storableMessage.getMessageContext();
                    if (synCtx.getProperty("message.store.redelivery.count") == null) {
                        synCtx.setProperty("message.store.redelivery.count", "1");
                        delay = RedeliveryProcessor.this.redeliveryDelay;
                    } else {
                        String redeliveryCountStr = (String)synCtx.getProperty("message.store.redelivery.count");
                        int redeliveryCount = Integer.parseInt(redeliveryCountStr);
                        if (redeliveryCount >= RedeliveryProcessor.this.maxRedeleveries) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Maximum number of redelivery attempts has exceeded for the message: " + synCtx.getMessageID() + " - " + "Message will be put back to the message store."));
                            }
                            RedeliveryProcessor.this.messageStore.store(storableMessage);
                            continue;
                        }
                        synCtx.setProperty("message.store.redelivery.count", "" + (redeliveryCount + 1));
                        if (RedeliveryProcessor.this.maxRedeleveries <= redeliveryCount + 1) {
                            synCtx.setProperty("message.store.redelivery.redelivered", "true");
                        }
                        if (RedeliveryProcessor.this.exponentialBackoff && RedeliveryProcessor.this.backOffMultiplier == -1) {
                            delay = (redeliveryCount + 1) * RedeliveryProcessor.this.redeliveryDelay;
                        } else if (RedeliveryProcessor.this.exponentialBackoff) {
                            delay = (int)Math.pow(RedeliveryProcessor.this.backOffMultiplier, redeliveryCount) * RedeliveryProcessor.this.redeliveryDelay;
                        }
                    }
                    try {
                        RedeliveryProcessor.this.messageStore.wait(delay);
                    }
                    catch (InterruptedException ignored) {
                        // empty catch block
                    }
                    synCtx.pushFaultHandler((FaultHandler)((Object)storableMessage.getEndpoint()));
                    storableMessage.getEndpoint().send(storableMessage.getMessageContext());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Sent: " + storableMessage.getMessageContext().getEnvelope()));
                    }
                }
            }
        }
    }
}

