/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.store;

import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.message.store.MessageStore;
import org.apache.synapse.message.store.MessageStoreView;
import org.apache.synapse.message.store.RedeliveryProcessor;
import org.apache.synapse.message.store.StorableMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageStore
implements MessageStore,
ManagedLifecycle {
    protected String name;
    protected RedeliveryProcessor redeliveryProcessor;
    protected Queue<StorableMessage> scheduledMessageQueue = new LinkedList<StorableMessage>();
    protected String sequence;
    protected MessageStoreView messageStoreMBean;
    protected SynapseConfiguration synapseConfiguration;
    protected SynapseEnvironment synapseEnvironment;
    protected Map<String, Object> parameters;
    protected String description;
    protected String fileName;

    @Override
    public void init(SynapseEnvironment se) {
        this.synapseEnvironment = se;
        this.synapseConfiguration = this.synapseEnvironment.getSynapseConfiguration();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.messageStoreMBean = new MessageStoreView(name, this);
        MBeanRegistrar.getInstance().registerMBean((Object)this.messageStoreMBean, "DeadLetterChannel", this.name);
    }

    @Override
    public void setRedeliveryProcessor(RedeliveryProcessor redeliveryProcessor) {
        this.redeliveryProcessor = redeliveryProcessor;
    }

    @Override
    public RedeliveryProcessor getRedeliveryProcessor() {
        return this.redeliveryProcessor;
    }

    @Override
    public void schedule(StorableMessage storableMessage) {
        if (storableMessage != null) {
            this.scheduledMessageQueue.add(storableMessage);
        }
        if (this.scheduledMessageQueue.size() > 0 && this.redeliveryProcessor != null && !this.redeliveryProcessor.isStarted()) {
            this.redeliveryProcessor.start();
        }
    }

    @Override
    public StorableMessage dequeueScheduledQueue() {
        return this.scheduledMessageQueue.poll();
    }

    @Override
    public StorableMessage getFirstSheduledMessage() {
        return this.scheduledMessageQueue.peek();
    }

    protected void mediateSequence(MessageContext synCtx) {
        Mediator seq;
        if (this.sequence != null && synCtx != null && "true".equalsIgnoreCase((String)synCtx.getProperty("message.store.redelivery.redelivered")) && (seq = synCtx.getSequence(this.sequence)) != null) {
            seq.mediate(synCtx);
        }
    }

    @Override
    public int getSize() {
        return -1;
    }

    @Override
    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    @Override
    public String getSequence() {
        return this.sequence;
    }

    @Override
    public void setConfiguration(SynapseConfiguration configuration) {
        this.synapseConfiguration = configuration;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    @Override
    public String getProviderClass() {
        return this.getClass().getName();
    }

    @Override
    public void destroy() {
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setFileName(String filename) {
        this.fileName = filename;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }
}

