/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.eip.splitter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.OperationContext;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.eip.Target;
import org.apache.synapse.util.MessageHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneMediator
extends AbstractMediator
implements ManagedLifecycle {
    private boolean continueParent = false;
    private List<Target> targets = new ArrayList<Target>();

    @Override
    public boolean mediate(MessageContext synCtx) {
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Clone mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        Iterator<Target> iter = this.targets.iterator();
        int i = 0;
        while (iter.hasNext()) {
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Submitting " + (i + 1) + " of " + this.targets.size() + " messages for processing in parallel");
            }
            iter.next().mediate(this.getClonedMessageContext(synCtx, i++, this.targets.size()));
        }
        OperationContext opCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext().getOperationContext();
        if (!this.continueParent && opCtx != null) {
            opCtx.setProperty("RESPONSE_WRITTEN", (Object)"SKIP");
        }
        synLog.traceOrDebug("End : Clone mediator");
        return this.continueParent;
    }

    private MessageContext getClonedMessageContext(MessageContext synCtx, int messageSequence, int messageCount) {
        MessageContext newCtx = null;
        try {
            newCtx = MessageHelper.cloneMessageContext(synCtx);
            newCtx.setProperty("messageSequence", String.valueOf(messageSequence) + "/" + messageCount);
        }
        catch (AxisFault axisFault) {
            this.handleException("Error cloning the message context", (Exception)((Object)axisFault), synCtx);
        }
        return newCtx;
    }

    public boolean isContinueParent() {
        return this.continueParent;
    }

    public void setContinueParent(boolean continueParent) {
        this.continueParent = continueParent;
    }

    public List<Target> getTargets() {
        return this.targets;
    }

    public void setTargets(List<Target> targets) {
        this.targets = targets;
    }

    public void addTarget(Target target) {
        this.targets.add(target);
    }

    @Override
    public void init(SynapseEnvironment se) {
        for (Target target : this.targets) {
            SequenceMediator seq = target.getSequence();
            if (seq != null) {
                seq.init(se);
            }
            Endpoint endpoint = target.getEndpoint();
            endpoint.init(se);
        }
    }

    @Override
    public void destroy() {
        for (Target target : this.targets) {
            SequenceMediator seq = target.getSequence();
            if (seq != null) {
                seq.destroy();
            }
            Endpoint endpoint = target.getEndpoint();
            endpoint.destroy();
        }
    }
}

