/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.aspects.AspectConfigurable;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.mediators.MediatorLog;

public abstract class AbstractMediator
implements Mediator,
AspectConfigurable {
    protected Log log = LogFactory.getLog(this.getClass());
    protected static final Log trace = LogFactory.getLog((String)"TRACE_LOGGER");
    protected int traceState = 2;
    private AspectConfiguration aspectConfiguration;
    private String description;

    protected AbstractMediator() {
    }

    public String getType() {
        String cls = this.getClass().getName();
        int p = cls.lastIndexOf(".");
        if (p == -1) {
            return cls;
        }
        return cls.substring(p + 1);
    }

    public int getTraceState() {
        return this.traceState;
    }

    public void setTraceState(int traceState) {
        this.traceState = traceState;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setEffectiveTraceState(MessageContext synCtx) {
        if (this.traceState != 2) {
            synCtx.setTracingState(this.traceState);
        }
    }

    protected SynapseLog getLog(MessageContext synCtx) {
        return new MediatorLog(this.log, this.isTraceOn(synCtx), synCtx);
    }

    public boolean shouldTrace(int parentTraceState) {
        return this.traceState == 1 || this.traceState == 2 && parentTraceState == 1;
    }

    @Deprecated
    protected boolean isTraceOn(MessageContext msgCtx) {
        return this.traceState == 1 || this.traceState == 2 && msgCtx.getTracingState() == 1;
    }

    @Deprecated
    protected boolean isTraceOrDebugOn(boolean isTraceOn) {
        return isTraceOn || this.log.isDebugEnabled();
    }

    @Deprecated
    protected void traceOrDebug(boolean traceOn, String msg) {
        if (traceOn) {
            trace.info((Object)msg);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)msg);
        }
    }

    @Deprecated
    protected void traceOrDebugWarn(boolean traceOn, String msg) {
        if (traceOn) {
            trace.warn((Object)msg);
        }
        if (this.log.isDebugEnabled()) {
            this.log.warn((Object)msg);
        }
    }

    @Deprecated
    protected void auditLog(String msg, MessageContext msgContext) {
        this.log.info((Object)msg);
        if (msgContext.getServiceLog() != null) {
            msgContext.getServiceLog().info((Object)msg);
        }
        if (this.shouldTrace(msgContext.getTracingState())) {
            trace.info((Object)msg);
        }
    }

    protected void handleException(String msg, MessageContext msgContext) {
        this.log.error((Object)msg);
        if (msgContext.getServiceLog() != null) {
            msgContext.getServiceLog().error((Object)msg);
        }
        if (this.shouldTrace(msgContext.getTracingState())) {
            trace.error((Object)msg);
        }
        throw new SynapseException(msg);
    }

    @Deprecated
    protected void auditWarn(String msg, MessageContext msgContext) {
        this.log.warn((Object)msg);
        if (msgContext.getServiceLog() != null) {
            msgContext.getServiceLog().warn((Object)msg);
        }
        if (this.shouldTrace(msgContext.getTracingState())) {
            trace.warn((Object)msg);
        }
    }

    protected void handleException(String msg, Exception e, MessageContext msgContext) {
        this.log.error((Object)msg, (Throwable)e);
        if (msgContext.getServiceLog() != null) {
            msgContext.getServiceLog().error((Object)msg, (Throwable)e);
        }
        if (this.shouldTrace(msgContext.getTracingState())) {
            trace.error((Object)msg, (Throwable)e);
        }
        throw new SynapseException(msg, e);
    }

    public boolean isStatisticsEnable() {
        return this.aspectConfiguration != null && this.aspectConfiguration.isStatisticsEnable();
    }

    public void disableStatistics() {
        if (this.aspectConfiguration != null) {
            this.aspectConfiguration.disableStatistics();
        }
    }

    public void enableStatistics() {
        if (this.aspectConfiguration != null) {
            this.aspectConfiguration.enableStatistics();
        }
    }

    public void configure(AspectConfiguration aspectConfiguration) {
        this.aspectConfiguration = aspectConfiguration;
    }

    public AspectConfiguration getAspectConfiguration() {
        return this.aspectConfiguration;
    }
}

