/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints.dispatch;

import org.apache.synapse.MessageContext;
import org.apache.synapse.endpoints.dispatch.AbstractDispatcher;
import org.apache.synapse.endpoints.dispatch.SALSessions;
import org.apache.synapse.endpoints.dispatch.SessionInformation;

public class HttpSessionDispatcher
extends AbstractDispatcher {
    private static final String COOKIE = "Cookie";
    private static final String SET_COOKIE = "Set-Cookie";

    public SessionInformation getSession(MessageContext synCtx) {
        return SALSessions.getInstance().getSession(this.extractSessionID(synCtx, COOKIE));
    }

    public void updateSession(MessageContext synCtx) {
        String cookie = this.extractSessionID(synCtx, SET_COOKIE);
        if (cookie != null) {
            String[] sessionIds;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Found the HTTP header 'Set-Cookie: " + cookie + "' for updating the session"));
            }
            if ((sessionIds = cookie.split(";")) == null || sessionIds.length == 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Cannot find a session id for the cookie : " + cookie));
                }
                return;
            }
            String sessionId = sessionIds[0];
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Using the session id '" + sessionId + "' extracted from the Set-Cookie header "));
            }
            SALSessions.getInstance().updateSession(synCtx, sessionId);
        }
    }

    public void unbind(MessageContext synCtx) {
        SALSessions.getInstance().removeSession(this.extractSessionID(synCtx, COOKIE));
    }

    public boolean isServerInitiatedSession() {
        return true;
    }

    public void removeSessionID(MessageContext syCtx) {
        this.removeSessionID(syCtx, COOKIE);
    }
}

