/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import java.util.List;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.synapse.MessageContext;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2SynapseEnvironment;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointContext;
import org.apache.synapse.endpoints.EndpointView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndirectEndpoint
extends AbstractEndpoint {
    private String key = null;
    private Endpoint realEndpoint = null;

    @Override
    public void send(MessageContext synCtx) {
        this.reLoadAndInitEndpoint(((Axis2MessageContext)synCtx).getAxis2MessageContext().getConfigurationContext());
        if (this.realEndpoint != null) {
            this.realEndpoint.send(synCtx);
        } else {
            this.informFailure(synCtx, 305100, "Couldn't find the endpoint with the key : " + this.key);
        }
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public boolean readyToSend() {
        return this.realEndpoint.readyToSend();
    }

    @Override
    public void setName(String endpointName) {
    }

    @Override
    public EndpointContext getContext() {
        return this.realEndpoint.getContext();
    }

    @Override
    public List<Endpoint> getChildren() {
        return this.realEndpoint.getChildren();
    }

    @Override
    public EndpointView getMetricsMBean() {
        return this.realEndpoint.getMetricsMBean();
    }

    @Override
    public void init(SynapseEnvironment synapseEnvironment) {
        ConfigurationContext cc = ((Axis2SynapseEnvironment)synapseEnvironment).getAxis2ConfigurationContext();
        this.reLoadAndInitEndpoint(cc);
    }

    @Override
    public String toString() {
        return "Indirect Endpoint [" + this.key + "]";
    }

    private synchronized void reLoadAndInitEndpoint(ConfigurationContext cc) {
        Parameter parameter = cc.getAxisConfiguration().getParameter("synapse.config");
        Parameter synEnvParameter = cc.getAxisConfiguration().getParameter("synapse.env");
        if (parameter.getValue() instanceof SynapseConfiguration && synEnvParameter.getValue() instanceof SynapseEnvironment) {
            boolean reLoad;
            SynapseConfiguration synCfg = (SynapseConfiguration)parameter.getValue();
            SynapseEnvironment synapseEnvironment = (SynapseEnvironment)synEnvParameter.getValue();
            boolean bl = reLoad = this.realEndpoint == null;
            if (!reLoad) {
                Entry entry = synCfg.getEntryDefinition(this.key);
                if (entry != null && entry.isDynamic()) {
                    if (!entry.isCached() || entry.isExpired()) {
                        reLoad = true;
                    }
                } else {
                    reLoad = true;
                }
            }
            if (reLoad) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Loading real endpoint with key : " + this.key));
                }
                this.realEndpoint = synCfg.getEndpoint(this.key);
                if (this.realEndpoint != null && !this.realEndpoint.isInitialized()) {
                    this.realEndpoint.init(synapseEnvironment);
                }
            }
        }
    }
}

