/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.clustering.Member;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.LoadBalanceMembershipHandler;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2SynapseEnvironment;
import org.apache.synapse.endpoints.AddressEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.endpoints.LoadbalanceEndpoint;
import org.apache.synapse.endpoints.algorithms.AlgorithmContext;
import org.apache.synapse.endpoints.dispatch.Dispatcher;
import org.apache.synapse.endpoints.dispatch.SALSessions;
import org.apache.synapse.endpoints.dispatch.SessionInformation;

public class DynamicLoadbalanceEndpoint
extends LoadbalanceEndpoint {
    private static final Log log = LogFactory.getLog(DynamicLoadbalanceEndpoint.class);
    private boolean sessionAffinity = false;
    private Dispatcher dispatcher = null;
    private long sessionTimeout = -1L;
    private AlgorithmContext algorithmContext;
    private LoadBalanceMembershipHandler lbMembershipHandler;

    public void init(SynapseEnvironment synapseEnvironment) {
        ConfigurationContext cc = ((Axis2SynapseEnvironment)synapseEnvironment).getAxis2ConfigurationContext();
        if (!this.initialized) {
            SALSessions salSessions;
            super.init(synapseEnvironment);
            if (this.algorithmContext == null) {
                this.algorithmContext = new AlgorithmContext(this.isClusteringEnabled, cc, this.getName());
            }
            if (!(salSessions = SALSessions.getInstance()).isInitialized()) {
                salSessions.initialize(this.isClusteringEnabled, cc);
            }
        }
        log.info((Object)"Dynamic load balance endpoint initialized");
    }

    public void setLoadBalanceMembershipHandler(LoadBalanceMembershipHandler lbMembershipHandler) {
        this.lbMembershipHandler = lbMembershipHandler;
    }

    public LoadBalanceMembershipHandler getLbMembershipHandler() {
        return this.lbMembershipHandler;
    }

    public void send(MessageContext synCtx) {
        SessionInformation sessionInformation = null;
        Member currentMember = null;
        ConfigurationContext configCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext().getConfigurationContext();
        if (this.lbMembershipHandler.getConfigurationContext() == null) {
            this.lbMembershipHandler.setConfigurationContext(configCtx);
        }
        if (this.isSessionAffinityBasedLB()) {
            sessionInformation = (SessionInformation)synCtx.getProperty("synapse.sal.endpoint.current.sessioninformation");
            currentMember = (Member)synCtx.getProperty("synapse.sal.current.member");
            if (sessionInformation == null && currentMember == null && (sessionInformation = this.dispatcher.getSession(synCtx)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Current session id : " + sessionInformation.getId()));
                }
                currentMember = sessionInformation.getMember();
                synCtx.setProperty("synapse.sal.current.member", currentMember);
                synCtx.setProperty("synapse.sal.endpoint.current.sessioninformation", sessionInformation);
            }
        }
        if (sessionInformation != null && currentMember != null) {
            this.sendToApplicationMember(synCtx, currentMember, false);
        } else {
            currentMember = this.lbMembershipHandler.getNextApplicationMember(this.algorithmContext);
            if (currentMember == null) {
                String msg = "No application members available";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            this.sendToApplicationMember(synCtx, currentMember, true);
        }
    }

    public void setName(String name) {
        super.setName(name);
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public void setSessionAffinity(boolean sessionAffinity) {
        this.sessionAffinity = sessionAffinity;
    }

    public boolean isSessionAffinityBasedLB() {
        return this.sessionAffinity;
    }

    private void sendToApplicationMember(MessageContext synCtx, Member currentMember, boolean newSession) {
        org.apache.axis2.context.MessageContext axis2MsgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        String transport = axis2MsgCtx.getTransportIn().getName();
        String address = synCtx.getTo().getAddress();
        EndpointReference to = this.getEndpointReferenceAfterURLRewrite(currentMember, transport, address);
        synCtx.setTo(to);
        DynamicLoadbalanceFaultHandler faultHandler = new DynamicLoadbalanceFaultHandler(to);
        faultHandler.setCurrentMember(currentMember);
        if (this.isFailover()) {
            synCtx.pushFaultHandler(faultHandler);
            synCtx.getEnvelope().build();
        }
        Endpoint endpoint = this.getEndpoint(to, synCtx);
        if (this.isSessionAffinityBasedLB() && newSession) {
            this.prepareEndPointSequence(synCtx, endpoint);
            synCtx.setProperty("synapse.sal.current.member", currentMember);
            synCtx.setProperty("synape.sal.endpoints.dispatcher", this.dispatcher);
            synCtx.setProperty("synapse.sal.first_message_in_session", Boolean.TRUE);
        }
        endpoint.send(synCtx);
    }

    private void prepareEndPointSequence(MessageContext synCtx, Endpoint endpoint) {
        ArrayList<DynamicLoadbalanceEndpoint> endpointList;
        Object o = synCtx.getProperty("synapse.sal.endpoint.list");
        if (o instanceof List) {
            endpointList = (ArrayList<DynamicLoadbalanceEndpoint>)o;
            endpointList.add(this);
        } else {
            endpointList = new ArrayList<DynamicLoadbalanceEndpoint>();
            endpointList.add(this);
            synCtx.setProperty("synapse.sal.endpoint.list", endpointList);
        }
        if (!(endpoint instanceof DynamicLoadbalanceEndpoint)) {
            endpointList.add((DynamicLoadbalanceEndpoint)endpoint);
            if (this.dispatcher.isServerInitiatedSession()) {
                this.dispatcher.removeSessionID(synCtx);
            }
        }
    }

    private EndpointReference getEndpointReferenceAfterURLRewrite(Member currentMember, String transport, String address) {
        if (transport.equals("http") || transport.equals("https")) {
            if (address.indexOf(":") != -1) {
                try {
                    address = new URL(address).getPath();
                }
                catch (MalformedURLException e) {
                    String msg = "URL " + address + " is malformed";
                    log.error((Object)msg, (Throwable)e);
                    throw new SynapseException(msg, e);
                }
            }
            return new EndpointReference(transport + "://" + currentMember.getHostName() + ":" + ("http".equals(transport) ? currentMember.getHttpPort() : currentMember.getHttpsPort()) + address);
        }
        String msg = "Cannot load balance for non-HTTP/S transport " + transport;
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private Endpoint getEndpoint(EndpointReference to, MessageContext synCtx) {
        AddressEndpoint endpoint = new AddressEndpoint();
        endpoint.setName("DynamicLoadBalanceAddressEndpoint-" + Math.random());
        EndpointDefinition definition = new EndpointDefinition();
        definition.setReplicationDisabled(true);
        definition.setAddress(to.getAddress());
        endpoint.setDefinition(definition);
        endpoint.init((SynapseEnvironment)((Axis2MessageContext)synCtx).getAxis2MessageContext().getConfigurationContext().getAxisConfiguration().getParameterValue("synapse.env"));
        return endpoint;
    }

    private class DynamicLoadbalanceFaultHandler
    extends FaultHandler {
        private EndpointReference to;
        private Member currentMember;

        public void setCurrentMember(Member currentMember) {
            this.currentMember = currentMember;
        }

        private DynamicLoadbalanceFaultHandler(EndpointReference to) {
            this.to = to;
        }

        public void onFault(MessageContext synCtx) {
            Set pros;
            if (this.currentMember == null) {
                return;
            }
            synCtx.getFaultStack().pop();
            this.currentMember = DynamicLoadbalanceEndpoint.this.lbMembershipHandler.getNextApplicationMember(DynamicLoadbalanceEndpoint.this.algorithmContext);
            if (this.currentMember == null) {
                String msg = "No application members available";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            synCtx.setTo(this.to);
            if (DynamicLoadbalanceEndpoint.this.isSessionAffinityBasedLB() && (pros = synCtx.getPropertyKeySet()) != null) {
                pros.remove("synapse.sal.endpoint.current.sessioninformation");
            }
            DynamicLoadbalanceEndpoint.this.sendToApplicationMember(synCtx, this.currentMember, true);
        }
    }
}

