/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.util.Properties;
import org.apache.axis2.clustering.ClusterManager;
import org.apache.axis2.clustering.LoadBalanceEventHandler;
import org.apache.axis2.clustering.Member;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.LoadBalanceMembershipHandler;
import org.apache.synapse.endpoints.algorithms.AlgorithmContext;
import org.apache.synapse.endpoints.algorithms.LoadbalanceAlgorithm;

public class Axis2LoadBalanceMembershipHandler
implements LoadBalanceMembershipHandler {
    private static final Log log = LogFactory.getLog(Axis2LoadBalanceMembershipHandler.class);
    private String lbDomain;
    private LoadBalanceEventHandler lbEventHandler;
    private ConfigurationContext configCtx;
    private LoadbalanceAlgorithm algorithm;
    private Properties properties;

    public void init(Properties props, LoadbalanceAlgorithm algorithm) {
        this.properties = props;
        this.lbDomain = props.getProperty("applicationDomain");
        if (this.lbDomain == null) {
            String msg = "The applicationDomain property has not been specified in the dynamicLoadbalance configuration in the synapse.xml file. This has to be the same as the applicationDomain entry in the loadBalancer entry in the axis2.xml file.";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        this.algorithm = algorithm;
    }

    public void setConfigurationContext(ConfigurationContext configCtx) {
        this.configCtx = configCtx;
        ClusterManager clusterManager = configCtx.getAxisConfiguration().getClusterManager();
        if (clusterManager == null) {
            String msg = "In order to enable load balancing across an Axis2 cluster, the cluster entry should be enabled in the axis2.xml file";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        this.lbEventHandler = clusterManager.getLoadBalanceEventHandler(this.lbDomain);
        if (this.lbEventHandler == null) {
            String msg = "A LoadBalanceEventHandler has not been specified in the axis2.xml file for the domain " + this.lbDomain;
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
    }

    public ConfigurationContext getConfigurationContext() {
        return this.configCtx;
    }

    public Member getNextApplicationMember(AlgorithmContext context) {
        this.algorithm.setApplicationMembers(this.lbEventHandler.getMembers());
        return this.algorithm.getNextApplicationMember(context);
    }

    public LoadbalanceAlgorithm getLoadbalanceAlgorithm() {
        return this.algorithm;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

