/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.client.SandeshaClient;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.policy.builders.RMAssertionBuilder;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.AnonymousServiceFactory;
import org.apache.synapse.core.axis2.AsyncCallback;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.SOAPUtils;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.util.MessageHelper;

public class Axis2FlexibleMEPClient {
    private static final Log log = LogFactory.getLog(Axis2FlexibleMEPClient.class);

    public static void send(EndpointDefinition endpoint, MessageContext synapseOutMessageContext) throws AxisFault {
        Object rm11;
        Object property;
        boolean separateListener = false;
        boolean wsSecurityEnabled = false;
        String wsSecPolicyKey = null;
        String inboundWsSecPolicyKey = null;
        String outboundWsSecPolicyKey = null;
        boolean wsRMEnabled = false;
        String wsRMPolicyKey = null;
        boolean wsAddressingEnabled = false;
        String wsAddressingVersion = null;
        if (endpoint != null) {
            separateListener = endpoint.isUseSeparateListener();
            wsSecurityEnabled = endpoint.isSecurityOn();
            wsSecPolicyKey = endpoint.getWsSecPolicyKey();
            inboundWsSecPolicyKey = endpoint.getInboundWsSecPolicyKey();
            outboundWsSecPolicyKey = endpoint.getOutboundWsSecPolicyKey();
            wsRMEnabled = endpoint.isReliableMessagingOn();
            wsRMPolicyKey = endpoint.getWsRMPolicyKey();
            wsAddressingEnabled = endpoint.isAddressingOn() || wsRMEnabled;
            wsAddressingVersion = endpoint.getAddressingVersion();
        }
        if (log.isDebugEnabled()) {
            String to = endpoint != null && endpoint.getAddress() != null ? endpoint.getAddress() : synapseOutMessageContext.getTo().toString();
            log.debug((Object)("Sending [add = " + wsAddressingEnabled + "] [sec = " + wsSecurityEnabled + "] [rm = " + wsRMEnabled + (endpoint != null ? "] [mtom = " + endpoint.isUseMTOM() + "] [swa = " + endpoint.isUseSwa() + "] [format = " + endpoint.getFormat() + "] [force soap11=" + endpoint.isForceSOAP11() + "] [force soap12=" + endpoint.isForceSOAP12() + "] [pox=" + endpoint.isForcePOX() + "] [get=" + endpoint.isForceGET() + "] [encoding=" + endpoint.getCharSetEncoding() : "") + "] [to=" + to + "]"));
        }
        org.apache.axis2.context.MessageContext originalInMsgCtx = ((Axis2MessageContext)synapseOutMessageContext).getAxis2MessageContext();
        String preserveAddressingProperty = (String)synapseOutMessageContext.getProperty("PRESERVE_WS_ADDRESSING");
        org.apache.axis2.context.MessageContext axisOutMsgCtx = Axis2FlexibleMEPClient.cloneForSend(originalInMsgCtx, preserveAddressingProperty);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Message [Original Request Message ID : " + synapseOutMessageContext.getMessageID() + "]" + " [New Cloned Request Message ID : " + axisOutMsgCtx.getMessageID() + "]"));
        }
        if (endpoint != null) {
            EndpointReference epr;
            if ("pox".equals(endpoint.getFormat())) {
                axisOutMsgCtx.setDoingREST(true);
                axisOutMsgCtx.setProperty("messageType", (Object)"application/xml");
            } else if ("get".equals(endpoint.getFormat())) {
                axisOutMsgCtx.setDoingREST(true);
                axisOutMsgCtx.setProperty("HTTP_METHOD", (Object)"GET");
                axisOutMsgCtx.setProperty("messageType", (Object)"application/x-www-form-urlencoded");
            } else if ("soap11".equals(endpoint.getFormat())) {
                axisOutMsgCtx.setDoingREST(false);
                axisOutMsgCtx.removeProperty("messageType");
                axisOutMsgCtx.setProperty("HTTP_METHOD", (Object)"POST");
                if (axisOutMsgCtx.getSoapAction() == null && axisOutMsgCtx.getWSAAction() != null) {
                    axisOutMsgCtx.setSoapAction(axisOutMsgCtx.getWSAAction());
                }
                if (!axisOutMsgCtx.isSOAP11()) {
                    SOAPUtils.convertSOAP12toSOAP11(axisOutMsgCtx);
                }
            } else if ("soap12".equals(endpoint.getFormat())) {
                axisOutMsgCtx.setDoingREST(false);
                axisOutMsgCtx.removeProperty("messageType");
                axisOutMsgCtx.setProperty("HTTP_METHOD", (Object)"POST");
                if (axisOutMsgCtx.getSoapAction() == null && axisOutMsgCtx.getWSAAction() != null) {
                    axisOutMsgCtx.setSoapAction(axisOutMsgCtx.getWSAAction());
                }
                if (axisOutMsgCtx.isSOAP11()) {
                    SOAPUtils.convertSOAP11toSOAP12(axisOutMsgCtx);
                }
            } else if ("rest".equals(endpoint.getFormat())) {
                axisOutMsgCtx.removeProperty("messageType");
                axisOutMsgCtx.setDoingREST(true);
            } else {
                Axis2FlexibleMEPClient.processWSDL2RESTRequestMessageType(originalInMsgCtx, axisOutMsgCtx);
            }
            if (endpoint.isUseMTOM()) {
                axisOutMsgCtx.setDoingMTOM(true);
                axisOutMsgCtx.setProperty("enableMTOM", (Object)"true");
                axisOutMsgCtx.setDoingMTOM(true);
            } else if (endpoint.isUseSwa()) {
                axisOutMsgCtx.setDoingSwA(true);
                axisOutMsgCtx.setProperty("enableSwA", (Object)"true");
                axisOutMsgCtx.setDoingSwA(true);
            }
            if (endpoint.getCharSetEncoding() != null) {
                axisOutMsgCtx.setProperty("CHARACTER_SET_ENCODING", (Object)endpoint.getCharSetEncoding());
            }
            Object restSuffix = axisOutMsgCtx.getProperty("REST_URL_POSTFIX");
            boolean isRest = "rest".equals(endpoint.getFormat());
            if (!isRest) {
                isRest = Axis2FlexibleMEPClient.isRequestRest(originalInMsgCtx);
            }
            if (endpoint.getAddress() != null) {
                if (isRest && restSuffix != null && !"".equals(restSuffix)) {
                    axisOutMsgCtx.setTo(new EndpointReference(endpoint.getAddress() + restSuffix));
                } else {
                    axisOutMsgCtx.setTo(new EndpointReference(endpoint.getAddress()));
                }
                axisOutMsgCtx.setProperty("ENDPOINT_PREFIX", (Object)endpoint.getAddress());
            } else if (isRest && restSuffix != null && !"".equals(restSuffix) && (epr = axisOutMsgCtx.getTo()) != null) {
                axisOutMsgCtx.setTo(new EndpointReference(epr.getAddress() + restSuffix));
            }
            if (endpoint.isUseSeparateListener()) {
                axisOutMsgCtx.getOptions().setUseSeparateListener(true);
            }
        } else {
            Axis2FlexibleMEPClient.processWSDL2RESTRequestMessageType(originalInMsgCtx, axisOutMsgCtx);
        }
        if (axisOutMsgCtx.isDoingREST() && "application/x-www-form-urlencoded".equals(axisOutMsgCtx.getProperty("messageType")) && axisOutMsgCtx.getProperty("whttp:location") == null && axisOutMsgCtx.getEnvelope().getBody().getFirstElement() != null) {
            axisOutMsgCtx.setProperty("whttp:location", (Object)axisOutMsgCtx.getEnvelope().getBody().getFirstElement().getQName().getLocalPart());
        }
        if (wsAddressingEnabled) {
            if (wsAddressingVersion != null && "submission".equals(wsAddressingVersion)) {
                axisOutMsgCtx.setProperty("WSAddressingVersion", (Object)"http://schemas.xmlsoap.org/ws/2004/08/addressing");
            } else if (wsAddressingVersion != null && "final".equals(wsAddressingVersion)) {
                axisOutMsgCtx.setProperty("WSAddressingVersion", (Object)"http://www.w3.org/2005/08/addressing");
            }
            axisOutMsgCtx.setProperty("disableAddressingForOutMessages", (Object)Boolean.FALSE);
        } else {
            axisOutMsgCtx.setProperty("disableAddressingForOutMessages", (Object)Boolean.TRUE);
        }
        String preserveHeaderProperty = (String)synapseOutMessageContext.getProperty("preserveProcessedHeaders");
        if (preserveHeaderProperty == null || !Boolean.parseBoolean(preserveHeaderProperty)) {
            MessageHelper.removeProcessedHeaders(axisOutMsgCtx, preserveAddressingProperty != null && Boolean.parseBoolean(preserveAddressingProperty));
        }
        ConfigurationContext axisCfgCtx = axisOutMsgCtx.getConfigurationContext();
        AxisConfiguration axisCfg = axisCfgCtx.getAxisConfiguration();
        AxisService anoymousService = AnonymousServiceFactory.getAnonymousService(synapseOutMessageContext.getConfiguration(), axisCfg, wsAddressingEnabled, wsRMEnabled, wsSecurityEnabled);
        anoymousService.getParent().addParameter("hiddenService", (Object)"true");
        ServiceGroupContext sgc = new ServiceGroupContext(axisCfgCtx, (AxisServiceGroup)anoymousService.getParent());
        ServiceContext serviceCtx = sgc.getServiceContext(anoymousService);
        boolean outOnlyMessage = "true".equals(synapseOutMessageContext.getProperty("OUT_ONLY")) || "http://www.w3.org/ns/wsdl/in-only".equals(originalInMsgCtx.getOperationContext().getAxisOperation().getMessageExchangePattern());
        AxisOperation axisAnonymousOperation = anoymousService.getOperation(outOnlyMessage ? new QName("anonOutonlyOp") : new QName("anonOutInOp"));
        Options clientOptions = MessageHelper.cloneOptions(originalInMsgCtx.getOptions());
        clientOptions.setUseSeparateListener(separateListener);
        if (wsRMEnabled && wsRMPolicyKey != null && (property = synapseOutMessageContext.getEntry(wsRMPolicyKey)) instanceof OMElement) {
            OMElement policyOMElement = (OMElement)property;
            RMAssertionBuilder builder = new RMAssertionBuilder();
            SandeshaPolicyBean sandeshaPolicyBean = (SandeshaPolicyBean)builder.build(policyOMElement, null);
            Parameter policyParam = new Parameter("Sandesha2PropertyBean", (Object)sandeshaPolicyBean);
            anoymousService.addParameter(policyParam);
        }
        if (wsSecurityEnabled) {
            if (wsSecPolicyKey != null) {
                clientOptions.setProperty("rampartPolicy", (Object)MessageHelper.getPolicy(synapseOutMessageContext, wsSecPolicyKey));
            } else {
                if (inboundWsSecPolicyKey != null) {
                    clientOptions.setProperty("rampartInPolicy", (Object)MessageHelper.getPolicy(synapseOutMessageContext, inboundWsSecPolicyKey));
                }
                if (outboundWsSecPolicyKey != null) {
                    clientOptions.setProperty("rampartOutPolicy", (Object)MessageHelper.getPolicy(synapseOutMessageContext, outboundWsSecPolicyKey));
                }
            }
            if (axisOutMsgCtx.getEnvelope().getHeader() == null) {
                SOAPFactory fac = axisOutMsgCtx.isSOAP11() ? OMAbstractFactory.getSOAP11Factory() : OMAbstractFactory.getSOAP12Factory();
                fac.createSOAPHeader(axisOutMsgCtx.getEnvelope());
            }
        }
        OperationClient mepClient = axisAnonymousOperation.createClient(serviceCtx, clientOptions);
        mepClient.addMessageContext(axisOutMsgCtx);
        axisOutMsgCtx.setAxisMessage(axisAnonymousOperation.getMessage("Out"));
        if (endpoint != null && endpoint.getTimeoutDuration() > 0L) {
            axisOutMsgCtx.setProperty("SEND_TIMEOUT", (Object)endpoint.getTimeoutDuration());
        }
        if (!outOnlyMessage) {
            AsyncCallback callback = new AsyncCallback(synapseOutMessageContext);
            if (endpoint != null) {
                callback.setTimeOutOn(System.currentTimeMillis() + endpoint.getTimeoutDuration());
                callback.setTimeOutAction(endpoint.getTimeoutAction());
            } else {
                callback.setTimeOutOn(System.currentTimeMillis());
            }
            mepClient.setCallback((AxisCallback)callback);
        }
        originalInMsgCtx.getOperationContext().setProperty("RESPONSE_WRITTEN", (Object)"SKIP");
        Object o = originalInMsgCtx.getProperty("TRANSPORT_OUT_DESCRIPTION");
        if (o != null && o instanceof TransportOutDescription) {
            axisOutMsgCtx.setTransportOut((TransportOutDescription)o);
            clientOptions.setTransportOut((TransportOutDescription)o);
            clientOptions.setProperty("TRANSPORT_OUT_DESCRIPTION", o);
        }
        mepClient.execute(true);
        if (wsRMEnabled && (rm11 = clientOptions.getProperty("Sandesha2RMSpecVersion")) != null && rm11.equals("Spec_2007_02")) {
            ServiceClient serviceClient = new ServiceClient(axisOutMsgCtx.getConfigurationContext(), axisOutMsgCtx.getAxisService());
            serviceClient.setTargetEPR(new EndpointReference(endpoint.getAddress()));
            serviceClient.setOptions(clientOptions);
            serviceClient.getOptions().setTo(new EndpointReference(endpoint.getAddress()));
            SandeshaClient.terminateSequence((ServiceClient)serviceClient);
        }
    }

    private static org.apache.axis2.context.MessageContext cloneForSend(org.apache.axis2.context.MessageContext ori, String preserveAddressing) throws AxisFault {
        org.apache.axis2.context.MessageContext newMC = MessageHelper.clonePartially(ori);
        newMC.setEnvelope(ori.getEnvelope());
        if (preserveAddressing != null && Boolean.parseBoolean(preserveAddressing)) {
            newMC.setMessageID(ori.getMessageID());
        } else {
            MessageHelper.removeAddressingHeaders(newMC);
        }
        newMC.setProperty("TRANSPORT_HEADERS", ori.getProperty("TRANSPORT_HEADERS"));
        return newMC;
    }

    public static void clearSecurtityProperties(Options options) {
        for (Options current = options; current != null && current.getProperty("rampartPolicy") != null; current = current.getParent()) {
            current.setProperty("rampartPolicy", null);
        }
    }

    private static void processWSDL2RESTRequestMessageType(org.apache.axis2.context.MessageContext originalInMsgCtx, org.apache.axis2.context.MessageContext axisOutMsgCtx) {
        String httpMethod;
        Object restContentType = originalInMsgCtx.getProperty("synapse.internal.rest.contentType");
        if (restContentType == null && "GET".equals(httpMethod = (String)originalInMsgCtx.getProperty("HTTP_METHOD"))) {
            restContentType = "application/x-www-form-urlencoded";
        }
        if (restContentType instanceof String) {
            axisOutMsgCtx.setProperty("messageType", restContentType);
        }
    }

    private static boolean isRequestRest(org.apache.axis2.context.MessageContext originalInMsgCtx) {
        String httpMethod;
        boolean isRestRequest;
        boolean bl = isRestRequest = originalInMsgCtx.getProperty("synapse.internal.rest.contentType") != null;
        if (!isRestRequest && !(isRestRequest = "GET".equals(httpMethod = (String)originalInMsgCtx.getProperty("HTTP_METHOD")))) {
            isRestRequest = "POST".equals(httpMethod) && HTTPTransportUtils.isRESTRequest((String)String.valueOf(originalInMsgCtx.getProperty("messageType")));
        }
        return isRestRequest;
    }
}

