/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.ResourceMapSerializer;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.mediators.MediatorProperty;
import org.apache.synapse.mediators.transform.XSLTMediator;

public class XSLTMediatorSerializer
extends AbstractMediatorSerializer {
    private static final QName ATTRIBUTE_Q = new QName("http://ws.apache.org/ns/synapse", "attribute");

    protected OMElement serializeSpecificMediator(Mediator m) {
        if (!(m instanceof XSLTMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        XSLTMediator mediator = (XSLTMediator)m;
        OMElement xslt = fac.createOMElement("xslt", synNS);
        if (mediator.getXsltKey() != null) {
            xslt.addAttribute(fac.createOMAttribute("key", nullNS, mediator.getXsltKey()));
        } else {
            this.handleException("Invalid XSLT mediator. XSLT registry key is required");
        }
        XSLTMediatorSerializer.saveTracingState(xslt, mediator);
        if (mediator.getSource() != null) {
            SynapseXPathSerializer.serializeXPath(mediator.getSource(), xslt, "source");
        }
        if (mediator.getTargetPropertyName() != null) {
            xslt.addAttribute(fac.createOMAttribute("target", nullNS, mediator.getTargetPropertyName()));
        }
        this.serializeProperties(xslt, mediator.getProperties());
        List<MediatorProperty> features = mediator.getFeatures();
        if (!features.isEmpty()) {
            for (MediatorProperty mp : features) {
                OMElement prop = fac.createOMElement("feature", synNS, (OMContainer)xslt);
                if (mp.getName() != null) {
                    prop.addAttribute(fac.createOMAttribute("name", nullNS, mp.getName()));
                } else {
                    this.handleException("The Feature name is missing");
                }
                if (mp.getValue() != null) {
                    prop.addAttribute(fac.createOMAttribute("value", nullNS, mp.getValue()));
                    continue;
                }
                this.handleException("The Feature value is missing");
            }
        }
        this.serializeMediatorProperties(xslt, mediator.getAttributes(), ATTRIBUTE_Q);
        ResourceMapSerializer.serializeResourceMap(xslt, mediator.getResourceMap());
        return xslt;
    }

    public String getMediatorClassName() {
        return XSLTMediator.class.getName();
    }
}

