/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.message.store.InMemoryMessageStore;
import org.apache.synapse.message.store.MessageStore;
import org.apache.synapse.message.store.RedeliveryProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageStoreFactory {
    private static final Log log = LogFactory.getLog(MessageStoreFactory.class);
    public static final QName CLASS_Q = new QName("", "class");
    public static final QName NAME_Q = new QName("", "name");
    public static final QName SEQUENCE_Q = new QName("", "sequence");
    private static final QName REDELIVERY_Q = new QName("http://ws.apache.org/ns/synapse", "redelivery");
    private static final QName DELAY_Q = new QName("http://ws.apache.org/ns/synapse", "interval");
    private static final QName MAX_REDELIVERIES = new QName("http://ws.apache.org/ns/synapse", "maximumRedeliveries");
    private static final QName ENABLE_EXPONENTIAL_BACKOFF = new QName("http://ws.apache.org/ns/synapse", "exponentialBackoff");
    private static final QName BACKOFF_MULTIPLIER = new QName("http://ws.apache.org/ns/synapse", "backoffMutiplier");
    public static final QName PARAMETER_Q = new QName("http://ws.apache.org/ns/synapse", "parameter");
    private static final QName DESCRIPTION_Q = new QName("http://ws.apache.org/ns/synapse", "description");

    public static MessageStore createMessageStore(OMElement elem, Properties properties) {
        OMElement descriptionElem;
        OMElement redeliveryElem;
        MessageStore messageStore;
        OMAttribute clss = elem.getAttribute(CLASS_Q);
        if (clss != null) {
            try {
                Class<?> cls = Class.forName(clss.getAttributeValue());
                messageStore = (MessageStore)cls.newInstance();
            }
            catch (Exception e) {
                MessageStoreFactory.handleException("Error while instantiating the message store", e);
                return null;
            }
        } else {
            messageStore = new InMemoryMessageStore();
        }
        OMAttribute nameAtt = elem.getAttribute(NAME_Q);
        if (nameAtt != null) {
            messageStore.setName(nameAtt.getAttributeValue());
        } else {
            MessageStoreFactory.handleException("Message Store name not specified");
        }
        OMAttribute sequenceAtt = elem.getAttribute(SEQUENCE_Q);
        if (sequenceAtt != null) {
            messageStore.setSequence(sequenceAtt.getAttributeValue());
        }
        if ((redeliveryElem = elem.getFirstChildWithName(REDELIVERY_Q)) != null) {
            RedeliveryProcessor redeliveryProcessor = MessageStoreFactory.populateRedeliveryProcessor(redeliveryElem, messageStore);
            messageStore.setRedeliveryProcessor(redeliveryProcessor);
        }
        if ((descriptionElem = elem.getFirstChildWithName(DESCRIPTION_Q)) != null) {
            messageStore.setDescription(descriptionElem.getText());
        }
        messageStore.setParameters(MessageStoreFactory.getParameters(elem));
        return messageStore;
    }

    private static RedeliveryProcessor populateRedeliveryProcessor(OMElement element, MessageStore messageStore) {
        OMElement expBOElm;
        OMElement maxRedeliveryElm;
        RedeliveryProcessor redeliveryProcessor = new RedeliveryProcessor(messageStore);
        OMElement intervalElm = element.getFirstChildWithName(DELAY_Q);
        if (intervalElm != null) {
            int delay = 1000 * Integer.parseInt(intervalElm.getText());
            redeliveryProcessor.setRedeliveryDelay(delay);
        }
        if ((maxRedeliveryElm = element.getFirstChildWithName(MAX_REDELIVERIES)) != null) {
            int maxRedeliveries = Integer.parseInt(maxRedeliveryElm.getText());
            redeliveryProcessor.setMaxRedeleveries(maxRedeliveries);
        }
        if ((expBOElm = element.getFirstChildWithName(ENABLE_EXPONENTIAL_BACKOFF)) != null && JavaUtils.isTrueExplicitly((String)expBOElm.getText())) {
            redeliveryProcessor.setExponentialBackoff(true);
            OMElement multiplierElm = element.getFirstChildWithName(BACKOFF_MULTIPLIER);
            if (multiplierElm != null) {
                int mulp = Integer.parseInt(multiplierElm.getText());
                redeliveryProcessor.setBackOffMultiplier(mulp);
            }
        }
        return redeliveryProcessor;
    }

    private static Map<String, Object> getParameters(OMElement elem) {
        Iterator params = elem.getChildrenWithName(PARAMETER_Q);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        while (params.hasNext()) {
            Object o = params.next();
            if (!(o instanceof OMElement)) continue;
            OMElement prop = (OMElement)o;
            OMAttribute paramName = prop.getAttribute(NAME_Q);
            String paramValue = prop.getText();
            if (paramName != null) {
                if (paramValue == null) continue;
                parameters.put(paramName.getAttributeValue(), paramValue);
                continue;
            }
            MessageStoreFactory.handleException("Invalid MessageStore parameter - Parameter must have a name ");
        }
        return parameters;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }
}

