/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.mediators.MediatorProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediatorPropertySerializer {
    private static final Log log = LogFactory.getLog(MediatorPropertySerializer.class);
    protected static final OMFactory fac = OMAbstractFactory.getOMFactory();
    protected static final OMNamespace synNS = SynapseConstants.SYNAPSE_OMNAMESPACE;
    protected static final OMNamespace nullNS = fac.createOMNamespace("", "");
    protected static final QName PROP_Q = new QName("http://ws.apache.org/ns/synapse", "property");

    public static void serializeMediatorProperties(OMElement parent, Collection<MediatorProperty> props) {
        MediatorPropertySerializer.serializeMediatorProperties(parent, props, PROP_Q);
    }

    public static void serializeMediatorProperties(OMElement parent, Collection<MediatorProperty> props, QName childElementName) {
        for (MediatorProperty mp : props) {
            MediatorPropertySerializer.serializeMediatorProperty(parent, mp, childElementName);
        }
    }

    public static void serializeMediatorProperty(OMElement parent, MediatorProperty mp) {
        MediatorPropertySerializer.serializeMediatorProperty(parent, mp, PROP_Q);
    }

    public static void serializeMediatorProperty(OMElement parent, MediatorProperty mp, QName childElementName) {
        OMElement prop = fac.createOMElement(childElementName, (OMContainer)parent);
        if (mp.getName() == null) {
            String msg = "Mediator property name missing";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        prop.addAttribute(fac.createOMAttribute("name", nullNS, mp.getName()));
        if (mp.getValue() != null) {
            prop.addAttribute(fac.createOMAttribute("value", nullNS, mp.getValue()));
        } else if (mp.getExpression() != null) {
            SynapseXPathSerializer.serializeXPath(mp.getExpression(), prop, "expression");
        } else {
            String msg = "Mediator property must have a literal value or be an expression";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
    }
}

