/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.OMElementUtils;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.config.xml.TargetFactory;
import org.apache.synapse.mediators.eip.Target;
import org.apache.synapse.mediators.eip.splitter.IterateMediator;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.jaxen.XPath;

public class IterateMediatorFactory
extends AbstractMediatorFactory {
    private static final Log log = LogFactory.getLog(IterateMediatorFactory.class);
    private static final QName ITERATE_Q = new QName("http://ws.apache.org/ns/synapse", "iterate");
    private static final QName ATT_CONTPAR = new QName("continueParent");
    private static final QName ATT_PREPLD = new QName("preservePayload");
    private static final QName ATT_ATTACHPATH = new QName("attachPath");
    private static final QName ATT_SEQUENCIAL = new QName("sequential");

    protected Mediator createSpecificMediator(OMElement elem, Properties properties) {
        OMElement targetElement;
        OMAttribute expression;
        OMAttribute preservePayload;
        IterateMediator mediator = new IterateMediator();
        this.processAuditStatus(mediator, elem);
        OMAttribute continueParent = elem.getAttribute(ATT_CONTPAR);
        if (continueParent != null) {
            mediator.setContinueParent(Boolean.valueOf(continueParent.getAttributeValue()));
        }
        if ((preservePayload = elem.getAttribute(ATT_PREPLD)) != null) {
            mediator.setPreservePayload(Boolean.valueOf(preservePayload.getAttributeValue()));
        }
        if ((expression = elem.getAttribute(ATT_EXPRN)) != null) {
            try {
                mediator.setExpression(SynapseXPathFactory.getSynapseXPath(elem, ATT_EXPRN));
            }
            catch (JaxenException e) {
                this.handleException("Unable to build the IterateMediator. Invalid XPATH " + expression.getAttributeValue(), (Exception)((Object)e));
            }
        } else {
            this.handleException("XPATH expression is required for an IterateMediator under the \"expression\" attribute");
        }
        OMAttribute attachPath = elem.getAttribute(ATT_ATTACHPATH);
        String attachPathValue = ".";
        if (attachPath != null && !mediator.isPreservePayload()) {
            this.handleException("Wrong configuration for the iterate mediator :: if the iterator should not preserve payload, then attachPath can not be present");
        } else if (attachPath != null) {
            attachPathValue = attachPath.getAttributeValue();
        }
        try {
            SynapseXPath xp = new SynapseXPath(attachPathValue);
            OMElementUtils.addNameSpaces((XPath)xp, elem, log);
            mediator.setAttachPath(xp);
        }
        catch (JaxenException e) {
            this.handleException("Unable to build the IterateMediator. Invalid XPATH " + attachPathValue, (Exception)((Object)e));
        }
        boolean asynchronous = true;
        OMAttribute asynchronousAttr = elem.getAttribute(ATT_SEQUENCIAL);
        if (asynchronousAttr != null && asynchronousAttr.getAttributeValue().equals("true")) {
            asynchronous = false;
        }
        if ((targetElement = elem.getFirstChildWithName(TARGET_Q)) != null) {
            Target target = TargetFactory.createTarget(targetElement, properties);
            if (target != null) {
                target.setAsynchronous(asynchronous);
                mediator.setTarget(target);
            }
        } else {
            this.handleException("Target for an iterate mediator is required :: missing target");
        }
        return mediator;
    }

    public QName getTagQName() {
        return ITERATE_Q;
    }
}

