/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.commons.evaluators.EvaluatorException;
import org.apache.synapse.commons.evaluators.config.EvaluatorSerializer;
import org.apache.synapse.commons.evaluators.config.EvaluatorSerializerFinder;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.TargetSerializer;
import org.apache.synapse.mediators.filters.router.ConditionalRouterMediator;
import org.apache.synapse.mediators.filters.router.Route;

public class ConditionalRouterMediatorSerializer
extends AbstractMediatorSerializer {
    protected OMElement serializeSpecificMediator(Mediator m) {
        OMElement conditionalRouterElem = fac.createOMElement("conditionalRouter", synNS);
        ConditionalRouterMediatorSerializer.saveTracingState(conditionalRouterElem, m);
        ConditionalRouterMediator conditionalRouterMediator = (ConditionalRouterMediator)m;
        if (conditionalRouterMediator.isContinueAfterExplicitlySet()) {
            conditionalRouterElem.addAttribute("continueAfter", Boolean.toString(conditionalRouterMediator.isContinueAfter()), nullNS);
        }
        for (Route route : conditionalRouterMediator.getRoutes()) {
            EvaluatorSerializer evaluatorSerializer;
            OMElement routeElem = fac.createOMElement("route", synNS);
            if (route.isBreakRouteExplicitlySet()) {
                routeElem.addAttribute("breakRoute", Boolean.toString(route.isBreakRoute()), nullNS);
            }
            if (route.getEvaluator() != null && (evaluatorSerializer = EvaluatorSerializerFinder.getInstance().getSerializer(route.getEvaluator().getName())) != null) {
                OMElement conditionElement = fac.createOMElement("condition", synNS);
                try {
                    evaluatorSerializer.serialize(conditionElement, route.getEvaluator());
                }
                catch (EvaluatorException e) {
                    this.handleException("Cannot serialize the Evaluator", (Exception)((Object)e));
                }
                routeElem.addChild((OMNode)conditionElement);
            }
            if (route.getTarget() != null) {
                routeElem.addChild((OMNode)TargetSerializer.serializeTarget(route.getTarget()));
            } else {
                this.handleException("Route in a conditional router has to have a target");
            }
            if (route.getTarget().isAsynchronous()) {
                routeElem.addAttribute(fac.createOMAttribute("asynchronous", nullNS, "true"));
            }
            conditionalRouterElem.addChild((OMNode)routeElem);
        }
        return conditionalRouterElem;
    }

    public String getMediatorClassName() {
        return ConditionalRouterMediator.class.getName();
    }
}

