/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.util.JavaUtils;
import org.apache.synapse.Mediator;
import org.apache.synapse.commons.evaluators.Evaluator;
import org.apache.synapse.commons.evaluators.EvaluatorException;
import org.apache.synapse.commons.evaluators.config.EvaluatorFactoryFinder;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.TargetFactory;
import org.apache.synapse.mediators.eip.Target;
import org.apache.synapse.mediators.filters.router.ConditionalRouterMediator;
import org.apache.synapse.mediators.filters.router.Route;

public class ConditionalRouterMediatorFactory
extends AbstractMediatorFactory {
    private static final QName CONDITIONAL_ROUTER_Q = new QName("http://ws.apache.org/ns/synapse", "conditionalRouter");
    private static final QName ROUTE_Q = new QName("http://ws.apache.org/ns/synapse", "route");
    private static final QName CONDITION_Q = new QName("http://ws.apache.org/ns/synapse", "condition");
    private static final QName TARGET_Q = new QName("http://ws.apache.org/ns/synapse", "target");
    private static final QName CONTINUE_AFTER_ATTR = new QName("", "continueAfter");
    private static final QName BREAK_ROUTE_ATTR = new QName("", "breakRoute");
    private static final QName ASYNCHRONOUS_ATTR = new QName("", "asynchronous");

    protected Mediator createSpecificMediator(OMElement elem, Properties properties) {
        ConditionalRouterMediator conditionalRouterMediator = new ConditionalRouterMediator();
        this.processAuditStatus(conditionalRouterMediator, elem);
        if (elem.getAttribute(CONTINUE_AFTER_ATTR) != null) {
            if (JavaUtils.isTrueExplicitly((String)elem.getAttributeValue(CONTINUE_AFTER_ATTR).trim())) {
                conditionalRouterMediator.setContinueAfter(true);
            } else if (JavaUtils.isFalseExplicitly((String)elem.getAttributeValue(CONTINUE_AFTER_ATTR).trim())) {
                conditionalRouterMediator.setContinueAfter(false);
            } else {
                this.handleException("continueAfter attribute value of the conditionalRouter must be either 'true' or 'false', the value found is : " + elem.getAttributeValue(CONTINUE_AFTER_ATTR).trim());
            }
        }
        Iterator itr = elem.getChildrenWithName(ROUTE_Q);
        while (itr.hasNext()) {
            OMElement conditionElem;
            OMElement routeElem = (OMElement)itr.next();
            Route route = new Route();
            if (routeElem.getAttribute(BREAK_ROUTE_ATTR) != null) {
                if (JavaUtils.isTrueExplicitly((String)routeElem.getAttributeValue(BREAK_ROUTE_ATTR).trim())) {
                    route.setBreakRoute(true);
                } else if (JavaUtils.isFalseExplicitly((String)routeElem.getAttributeValue(BREAK_ROUTE_ATTR).trim())) {
                    route.setBreakRoute(false);
                } else {
                    this.handleException("breakRoute attribute value of the route element must be either 'true' or 'false', the value found is : " + routeElem.getAttributeValue(BREAK_ROUTE_ATTR).trim());
                }
            }
            if ((conditionElem = routeElem.getFirstChildWithName(CONDITION_Q)) == null) {
                this.handleException("Couldn't find the condition of the conditional router");
                return null;
            }
            try {
                Evaluator evaluator = EvaluatorFactoryFinder.getInstance().getEvaluator(conditionElem.getFirstElement());
                route.setEvaluator(evaluator);
            }
            catch (EvaluatorException ee) {
                this.handleException("Couldn't build the condition of the conditional router", (Exception)((Object)ee));
            }
            OMElement targetElem = routeElem.getFirstChildWithName(TARGET_Q);
            Target target = TargetFactory.createTarget(targetElem, properties);
            if (JavaUtils.isTrueExplicitly((String)routeElem.getAttributeValue(ASYNCHRONOUS_ATTR))) {
                target.setAsynchronous(true);
            } else {
                target.setAsynchronous(false);
            }
            route.setTarget(target);
            conditionalRouterMediator.addRoute(route);
        }
        return conditionalRouterMediator;
    }

    public QName getTagQName() {
        return CONDITIONAL_ROUTER_Q;
    }
}

