/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse;

import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerConfigurationInformation;
import org.apache.synapse.ServerConfigurationInformationFactory;
import org.apache.synapse.ServerManager;
import org.apache.synapse.SynapseException;

public class SynapseServer {
    private static final Log log = LogFactory.getLog(SynapseServer.class);
    private static final String USAGE_TXT = "Usage: SynapseServer <axis2_repository> <axis2_xml> <synapse_home> <synapse_xml> <resolve_root> <deployment mode>\n Opts: -? this message";
    private static ServerManager serverManager;

    public static void printUsage() {
        System.out.println(USAGE_TXT);
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        if (args.length <= 0 || args.length == 2 || args.length == 3 || args.length >= 8) {
            SynapseServer.printUsage();
        }
        log.info((Object)"Starting Apache Synapse...");
        ServerConfigurationInformation configurationInformation = ServerConfigurationInformationFactory.createServerConfigurationInformation(args);
        serverManager = new ServerManager();
        serverManager.init(configurationInformation, null);
        try {
            serverManager.start();
            SynapseServer.addShutdownHook();
            log.info((Object)"Apache Synapse started successfully");
            new CountDownLatch(1).await();
        }
        catch (SynapseException e) {
            log.fatal((Object)"Error starting Apache Synapse, trying a clean shutdown...", (Throwable)e);
            serverManager.shutdown();
            log.info((Object)"Clean shutdown due to the startups error complete");
            log.info((Object)"Halting JVM");
            System.exit(1);
        }
    }

    private static void addShutdownHook() {
        Thread shutdownHook = new Thread(){

            public void run() {
                log.info((Object)"Shutting down Apache Synapse...");
                try {
                    serverManager.shutdown();
                    log.info((Object)"Apache Synapse shutdown complete");
                    log.info((Object)"Halting JVM");
                }
                catch (Exception e) {
                    log.error((Object)"Error occurred while shutting down Apache Synapse, it may not be a clean shutdown", (Throwable)e);
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }
}

