/*
 * Decompiled with CFR 0.152.
 */
package samples.userguide;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Iterator;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;

public class AMQPConsumer {
    private Connection connection;
    private MessageConsumer messageConsumer;
    private Session session;
    private String inSymbol;
    private String inQty;
    private String inClOrderID;
    private int execID = 1;
    private static final String CLASS = "AMQPConsumer";
    private static final String PROPERTY_FILE = "../../repository/conf/sample/resources/fix/direct.properties";
    private static final String PROP_FILE_NAME = "propfile";
    private static final String LOOKUP_CODE_CON = "directQueue";
    private static final String LOOKUP_CODE_REP = "replyQueue";
    private static final String CONNECTION_FACTORY = "qpidConnectionfactory";
    private static final String FIX_MSG = "message";
    private static final String FIX_MSG_BODY = "body";
    private static final String FIX_MSG_ID = "id";
    private static final String FIX_MSG_SYMBOL = "55";
    private static final String FIX_MSG_CLORDID = "11";
    private static final String FIX_MSG_ORDQTY = "38";

    public static void main(String[] args) {
        AMQPConsumer syncConsumer = new AMQPConsumer();
        syncConsumer.runTest();
    }

    private void runTest() {
        try {
            String fileName = AMQPConsumer.getProperty(PROP_FILE_NAME, PROPERTY_FILE);
            Properties properties = new Properties();
            FileInputStream inStream = new FileInputStream(new File(fileName).getAbsolutePath());
            properties.load(inStream);
            InitialContext ctx = new InitialContext(properties);
            Destination destination = (Destination)ctx.lookup(LOOKUP_CODE_CON);
            Destination replyQueue = (Destination)ctx.lookup(LOOKUP_CODE_REP);
            ConnectionFactory conFac = (ConnectionFactory)ctx.lookup(CONNECTION_FACTORY);
            this.connection = conFac.createConnection();
            System.out.println("AMQPConsumer: Setting an ExceptionListener on the connection as sample uses a MessageConsumer");
            this.connection.setExceptionListener(new ExceptionListener(){

                public void onException(JMSException jmse) {
                    System.err.println("AMQPConsumer: The sample received an exception through the ExceptionListener" + jmse.getMessage());
                    jmse.printStackTrace();
                    System.exit(0);
                }
            });
            this.createSession(conFac, destination);
            this.createRepQueue(conFac, replyQueue);
            this.connection.start();
            System.out.println("AMQPConsumer: Starting connection so the MessageConsumer can receive messages");
            this.onMessage();
        }
        catch (Exception e) {
            System.out.println("ERROR : " + e.toString());
            e.printStackTrace();
        }
    }

    private void createSession(ConnectionFactory conFac, Destination destination) throws JMSException {
        System.out.println("AMQPConsumer: Creating a non-transacted, auto-acknowledged session");
        this.session = this.connection.createSession(false, 1);
        System.out.println("AMQPConsumer: Creating a MessageConsumer");
        this.messageConsumer = this.session.createConsumer(destination);
    }

    private void createRepQueue(ConnectionFactory conFac, Destination replyQueue) throws JMSException {
        MessageProducer messageProducer = this.session.createProducer(replyQueue);
        System.out.println("AMQPConsumer: Reply queue created");
    }

    private void onMessage() throws JMSException, XMLStreamException {
        boolean end = false;
        while (!end) {
            String text;
            Message message = this.messageConsumer.receive();
            if (message instanceof TextMessage) {
                text = ((TextMessage)message).getText();
            } else {
                byte[] body = new byte[(int)((BytesMessage)message).getBodyLength()];
                ((BytesMessage)message).readBytes(body);
                text = new String(body);
            }
            System.out.println("AMQPConsumer: Received  message:  " + text);
            if (message.getJMSReplyTo() == null) continue;
            this.parseOrder(text);
            this.sendExecution(message);
        }
    }

    private void parseOrder(String payload) throws XMLStreamException {
        ByteArrayInputStream is = new ByteArrayInputStream(payload.getBytes());
        XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(is);
        StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(parser, null);
        SOAPEnvelope envelope = (SOAPEnvelope)builder.getDocumentElement();
        SOAPBody soapBody = envelope.getBody();
        OMElement messageNode = soapBody.getFirstChildWithName(new QName(FIX_MSG));
        Iterator messageElements = messageNode.getChildElements();
        while (messageElements.hasNext()) {
            OMElement node = (OMElement)messageElements.next();
            if (!node.getQName().getLocalPart().equals(FIX_MSG_BODY)) continue;
            Iterator bodyElements = node.getChildElements();
            while (bodyElements.hasNext()) {
                OMElement bodyNode = (OMElement)bodyElements.next();
                String tag = bodyNode.getAttributeValue(new QName(FIX_MSG_ID));
                String value = bodyNode.getText();
                if (tag.equals(FIX_MSG_SYMBOL)) {
                    this.inSymbol = value;
                    continue;
                }
                if (tag.equals(FIX_MSG_CLORDID)) {
                    this.inClOrderID = value;
                    continue;
                }
                if (!tag.equals(FIX_MSG_ORDQTY)) continue;
                this.inQty = value;
            }
        }
    }

    private void sendExecution(Message message) throws JMSException {
        String repValue = "<m0:message xmlns:m0=\"http://services.samples/xsd/\" inSeession=\"FIX.4.0:EXEC-->SYNAPSE\" count=\"2\">\n<m0:header><m0:field m0:id=\"35\"><![CDATA[8]]></m0:field><m0:field m0:id=\"52\"><![CDATA[20080618-08:41:56]]></m0:field></m0:header><m0:body><m0:field m0:id=\"6\"><![CDATA[12.3]]></m0:field><m0:field m0:id=\"11\"><![CDATA[" + this.inClOrderID + "]]></m0:field>" + "<m0:field m0:id=\"14\"><![CDATA[" + this.inQty + "]]></m0:field>" + "<m0:field m0:id=\"17\"><![CDATA[" + this.execID + "]]></m0:field>" + "<m0:field m0:id=\"20\"><![CDATA[0]]></m0:field>" + "<m0:field m0:id=\"31\"><![CDATA[12.3]]></m0:field>" + "<m0:field m0:id=\"32\"><![CDATA[" + this.inQty + "]]></m0:field>" + "<m0:field m0:id=\"37\"><![CDATA[2]]></m0:field>" + "<m0:field m0:id=\"38\"><![CDATA[" + this.inQty + "]]></m0:field>" + "<m0:field m0:id=\"39\"><![CDATA[2]]></m0:field>" + "<m0:field m0:id=\"54\"><![CDATA[1]]></m0:field>" + "<m0:field m0:id=\"55\"><![CDATA[" + this.inSymbol + "]]></m0:field>" + "<m0:field m0:id=\"150\"><![CDATA[2]]></m0:field>" + "<m0:field m0:id=\"151\"><![CDATA[0]]></m0:field>" + "</m0:body>" + "<m0:trailer>" + "</m0:trailer>" + "</m0:message>";
        ++this.execID;
        TextMessage repMessage = this.session.createTextMessage(repValue);
        repMessage.setJMSCorrelationID(message.getJMSMessageID());
        MessageProducer replyProducer = this.session.createProducer(message.getJMSReplyTo());
        replyProducer.send((Message)repMessage);
        System.out.println("Execution sent: " + repMessage.getText());
    }

    private static String getProperty(String name, String def) {
        String result = System.getProperty(name);
        if (result == null || result.length() == 0) {
            result = def;
        }
        return result;
    }
}

