/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.http.util.EncodingUtils;
import org.apache.synapse.transport.base.MetricsCollector;
import org.apache.synapse.transport.nhttp.NHttpConfiguration;
import org.apache.synapse.transport.nhttp.ServerWorker;
import org.apache.synapse.transport.nhttp.util.PipeImpl;
import org.apache.synapse.transport.nhttp.util.WorkerPool;
import org.apache.synapse.transport.nhttp.util.WorkerPoolFactory;

public class ServerHandler
implements NHttpServiceHandler {
    private static final Log log = LogFactory.getLog(ServerHandler.class);
    private final HttpParams params;
    private final HttpResponseFactory responseFactory;
    private final HttpProcessor httpProcessor;
    private final ConnectionReuseStrategy connStrategy;
    ConfigurationContext cfgCtx = null;
    private NHttpConfiguration cfg = null;
    private boolean isHttps = false;
    private WorkerPool workerPool = null;
    private MetricsCollector metrics = null;
    private static final String REQUEST_SINK_CHANNEL = "request-sink-channel";
    private static final String RESPONSE_SOURCE_CHANNEL = "response-source-channel";
    private static final String REQUEST_BUFFER = "request-buffer";
    private static final String RESPONSE_BUFFER = "response-buffer";

    public ServerHandler(ConfigurationContext cfgCtx, HttpParams params, boolean isHttps, MetricsCollector metrics) {
        this.cfgCtx = cfgCtx;
        this.params = params;
        this.isHttps = isHttps;
        this.metrics = metrics;
        this.responseFactory = new DefaultHttpResponseFactory();
        this.httpProcessor = this.getHttpProcessor();
        this.connStrategy = new DefaultConnectionReuseStrategy();
        this.cfg = NHttpConfiguration.getInstance();
        this.workerPool = WorkerPoolFactory.getWorkerPool(this.cfg.getServerCoreThreads(), this.cfg.getServerMaxThreads(), this.cfg.getServerKeepalive(), this.cfg.getServerQueueLen(), "Server Worker thread group", "HttpServerWorker");
    }

    public void requestReceived(NHttpServerConnection conn) {
        block5: {
            HttpContext context = conn.getContext();
            HttpRequest request = conn.getHttpRequest();
            context.setAttribute("http.request", (Object)request);
            context.setAttribute(REQUEST_BUFFER, (Object)ByteBuffer.allocate(this.cfg.getBufferZise()));
            context.setAttribute(RESPONSE_BUFFER, (Object)ByteBuffer.allocate(this.cfg.getBufferZise()));
            try {
                PipeImpl requestPipe = new PipeImpl();
                PipeImpl responsePipe = new PipeImpl();
                context.setAttribute(REQUEST_SINK_CHANNEL, (Object)requestPipe.sink());
                context.setAttribute(RESPONSE_SOURCE_CHANNEL, (Object)responsePipe.source());
                ProtocolVersion httpVersion = request.getRequestLine().getProtocolVersion();
                HttpResponse response = this.responseFactory.newHttpResponse(httpVersion, 200, context);
                response.setParams(this.params);
                BasicHttpEntity entity = new BasicHttpEntity();
                entity.setContent(Channels.newInputStream(responsePipe.source()));
                if (httpVersion.greaterEquals((ProtocolVersion)HttpVersion.HTTP_1_1)) {
                    entity.setChunked(true);
                }
                response.setEntity((HttpEntity)entity);
                this.workerPool.execute(new ServerWorker(this.cfgCtx, conn, this.isHttps, this.metrics, this, request, Channels.newInputStream(requestPipe.source()), response, Channels.newOutputStream(responsePipe.sink())));
            }
            catch (IOException e) {
                this.handleException("Error processing request received for : " + request.getRequestLine().getUri(), e, conn);
                if (this.metrics != null) {
                    this.metrics.incrementFaultsReceiving();
                }
            }
            catch (Exception e) {
                this.handleException("Error processing request received for : " + request.getRequestLine().getUri(), e, conn);
                if (this.metrics == null) break block5;
                this.metrics.incrementFaultsReceiving();
            }
        }
    }

    public void inputReady(NHttpServerConnection conn, ContentDecoder decoder) {
        HttpContext context = conn.getContext();
        WritableByteChannel sink = (WritableByteChannel)context.getAttribute(REQUEST_SINK_CHANNEL);
        ByteBuffer inbuf = (ByteBuffer)context.getAttribute(REQUEST_BUFFER);
        try {
            while (decoder.read(inbuf) > 0) {
                inbuf.flip();
                sink.write(inbuf);
                if (this.metrics != null) {
                    this.metrics.incrementBytesReceived(inbuf.position());
                }
                inbuf.compact();
            }
            if (decoder.isCompleted()) {
                sink.close();
            }
        }
        catch (IOException e) {
            this.handleException("I/O Error : " + e.getMessage(), e, conn);
        }
    }

    public void responseReady(NHttpServerConnection conn) {
    }

    public void outputReady(NHttpServerConnection conn, ContentEncoder encoder) {
        HttpContext context = conn.getContext();
        HttpResponse response = conn.getHttpResponse();
        ReadableByteChannel source = (ReadableByteChannel)context.getAttribute(RESPONSE_SOURCE_CHANNEL);
        ByteBuffer outbuf = (ByteBuffer)context.getAttribute(RESPONSE_BUFFER);
        try {
            int bytesRead = source.read(outbuf);
            if (bytesRead == -1 && outbuf.position() == 0) {
                encoder.complete();
            } else {
                outbuf.flip();
                encoder.write(outbuf);
                outbuf.compact();
            }
            if (encoder.isCompleted()) {
                source.close();
                if (!this.connStrategy.keepAlive(response, context)) {
                    conn.close();
                }
            }
        }
        catch (IOException e) {
            this.handleException("I/O Error : " + e.getMessage(), e, conn);
        }
    }

    public void commitResponse(NHttpServerConnection conn, HttpResponse response) {
        try {
            this.httpProcessor.process(response, conn.getContext());
            conn.submitResponse(response);
        }
        catch (HttpException e) {
            this.handleException("Unexpected HTTP protocol error : " + e.getMessage(), (Exception)((Object)e), conn);
        }
        catch (IOException e) {
            this.handleException("IO error submiting response : " + e.getMessage(), e, conn);
        }
    }

    public void timeout(NHttpServerConnection conn) {
        HttpRequest req = (HttpRequest)conn.getContext().getAttribute("http.request");
        if (req != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Connection Timeout for request to : " + req.getRequestLine().getUri() + " Probably the keepalive connection was closed"));
            }
        } else {
            log.warn((Object)"Connection Timeout");
            if (this.metrics != null) {
                this.metrics.incrementTimeoutsReceiving();
            }
        }
        this.shutdownConnection((HttpConnection)conn);
    }

    public void connected(NHttpServerConnection conn) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"New incoming connection");
        }
    }

    public void closed(NHttpServerConnection conn) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Connection closed");
        }
    }

    public void exception(NHttpServerConnection conn, HttpException e) {
        HttpContext context = conn.getContext();
        HttpRequest request = conn.getHttpRequest();
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        HttpResponse response = this.responseFactory.newHttpResponse(ver, 400, context);
        byte[] msg = EncodingUtils.getAsciiBytes((String)("Malformed HTTP request: " + e.getMessage()));
        ByteArrayEntity entity = new ByteArrayEntity(msg);
        entity.setContentType("text/plain; charset=US-ASCII");
        response.setEntity((HttpEntity)entity);
        this.commitResponse(conn, response);
    }

    public void exception(NHttpServerConnection conn, IOException e) {
        if (e instanceof ConnectionClosedException || e.getMessage().contains("Connection reset by peer") || e.getMessage().contains("forcibly closed")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("I/O error (Probably the keepalive connection was closed):" + e.getMessage()));
            }
        } else {
            log.error((Object)("I/O error: " + e.getMessage()));
        }
        this.shutdownConnection((HttpConnection)conn);
    }

    private void handleException(String msg, Exception e, NHttpServerConnection conn) {
        log.error((Object)msg, (Throwable)e);
        if (conn != null) {
            this.shutdownConnection((HttpConnection)conn);
        }
    }

    private void shutdownConnection(HttpConnection conn) {
        try {
            conn.shutdown();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private HttpProcessor getHttpProcessor() {
        BasicHttpProcessor httpProcessor = new BasicHttpProcessor();
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseDate());
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseServer());
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseContent());
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
        return httpProcessor;
    }
}

