/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.SSLIOSessionHandler;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.nio.reactor.SessionRequest;
import org.apache.http.nio.reactor.SessionRequestCallback;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.synapse.transport.nhttp.Axis2HttpRequest;
import org.apache.synapse.transport.nhttp.ClientHandler;
import org.apache.synapse.transport.nhttp.ConnectionPool;
import org.apache.synapse.transport.nhttp.NHttpConfiguration;
import org.apache.synapse.transport.nhttp.NhttpUtils;
import org.apache.synapse.transport.nhttp.PlainClientIOEventDispatch;
import org.apache.synapse.transport.nhttp.ServerWorker;

public class HttpCoreNIOSender
extends AbstractHandler
implements TransportSender {
    private static final Log log = LogFactory.getLog(HttpCoreNIOSender.class);
    private ConfigurationContext cfgCtx;
    private DefaultConnectingIOReactor ioReactor = null;
    private NHttpClientHandler handler = null;
    private final SessionRequestCallback sessionRequestCallback = HttpCoreNIOSender.getSessionRequestCallback();
    private SSLContext sslContext = null;
    private SSLIOSessionHandler sslIOSessionHandler = null;

    public void init(ConfigurationContext cfgCtx, TransportOutDescription transportOut) throws AxisFault {
        this.cfgCtx = cfgCtx;
        this.sslContext = this.getSSLContext(transportOut);
        this.sslIOSessionHandler = this.getSSLIOSessionHandler(transportOut);
        Thread t = new Thread(new Runnable(){

            public void run() {
                HttpCoreNIOSender.this.executeClientEngine();
            }
        }, "HttpCoreNIOSender");
        t.start();
        log.info((Object)((this.sslContext == null ? "HTTP" : "HTTPS") + " Sender starting"));
    }

    private void executeClientEngine() {
        HttpParams params = this.getClientParameters();
        try {
            this.ioReactor = new DefaultConnectingIOReactor(NHttpConfiguration.getInstance().getClientIOWorkers(), params);
            this.ioReactor.setExceptionHandler(new IOReactorExceptionHandler(){

                public boolean handle(IOException ioException) {
                    log.warn((Object)("System may be unstable: IOReactor encountered a checked exception : " + ioException.getMessage()), (Throwable)ioException);
                    return true;
                }

                public boolean handle(RuntimeException runtimeException) {
                    log.warn((Object)("System may be unstable: IOReactor encountered a runtime exception : " + runtimeException.getMessage()), (Throwable)runtimeException);
                    return true;
                }
            });
        }
        catch (IOException e) {
            log.error((Object)"Error starting the IOReactor", (Throwable)e);
        }
        this.handler = new ClientHandler(this.cfgCtx, params);
        IOEventDispatch ioEventDispatch = this.getEventDispatch(this.handler, this.sslContext, this.sslIOSessionHandler, params);
        try {
            this.ioReactor.execute(ioEventDispatch);
        }
        catch (InterruptedIOException ex) {
            log.fatal((Object)"Reactor Interrupted");
        }
        catch (IOException e) {
            log.fatal((Object)("Encountered an I/O error: " + e.getMessage()), (Throwable)e);
        }
        log.info((Object)"Sender Shutdown");
    }

    protected IOEventDispatch getEventDispatch(NHttpClientHandler handler, SSLContext sslContext, SSLIOSessionHandler sslIOSessionHandler, HttpParams params) {
        return new PlainClientIOEventDispatch(handler, params);
    }

    protected SSLContext getSSLContext(TransportOutDescription transportOut) throws AxisFault {
        return null;
    }

    protected SSLIOSessionHandler getSSLIOSessionHandler(TransportOutDescription transportOut) throws AxisFault {
        return null;
    }

    private HttpParams getClientParameters() {
        NHttpConfiguration cfg = NHttpConfiguration.getInstance();
        BasicHttpParams params = new BasicHttpParams();
        params.setIntParameter("http.socket.timeout", cfg.getProperty("http.socket.timeout", 60000)).setIntParameter("http.connection.timeout", cfg.getProperty("http.connection.timeout", 10000)).setIntParameter("http.socket.buffer-size", cfg.getProperty("http.socket.buffer-size", 8192)).setBooleanParameter("http.connection.stalecheck", cfg.getProperty("http.connection.stalecheck", 0) == 1).setBooleanParameter("http.tcp.nodelay", cfg.getProperty("http.tcp.nodelay", 1) == 1).setParameter("http.useragent", (Object)"Synapse-HttpComponents-NIO");
        return params;
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        this.removeUnwantedHeaders(msgContext);
        EndpointReference epr = NhttpUtils.getDestinationEPR(msgContext);
        if (epr != null) {
            if (!"http://www.w3.org/2005/08/addressing/none".equals(epr.getAddress())) {
                this.sendAsyncRequest(epr, msgContext);
            } else {
                this.handleException("Cannot send message to http://www.w3.org/2005/08/addressing/none");
            }
        } else if (msgContext.getProperty("OutTransportInfo") != null) {
            if (msgContext.getProperty("OutTransportInfo") instanceof ServerWorker) {
                this.sendAsyncResponse(msgContext);
            } else {
                this.sendUsingOutputStream(msgContext);
            }
        } else {
            this.handleException("No valid destination EPR or OutputStream to send message");
        }
        if (msgContext.getOperationContext() != null) {
            msgContext.getOperationContext().setProperty("RESPONSE_WRITTEN", (Object)"true");
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void removeUnwantedHeaders(MessageContext msgContext) {
        Map headers = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
        if (headers == null || headers.isEmpty()) {
            return;
        }
        Iterator iter = headers.keySet().iterator();
        while (iter.hasNext()) {
            String headerName = (String)iter.next();
            if (!"Connection".equalsIgnoreCase(headerName) && !"Transfer-Encoding".equalsIgnoreCase(headerName) && !"Date".equalsIgnoreCase(headerName) && !"Server".equalsIgnoreCase(headerName) && !"Content-Type".equalsIgnoreCase(headerName) && !"Content-Length".equalsIgnoreCase(headerName) && !"User-Agent".equalsIgnoreCase(headerName)) continue;
            iter.remove();
        }
    }

    private void sendAsyncRequest(EndpointReference epr, MessageContext msgContext) throws AxisFault {
        try {
            URL url = new URL(epr.getAddress());
            int port = url.getPort();
            if (port == -1) {
                if ("http".equals(url.getProtocol())) {
                    port = 80;
                } else if ("https".equals(url.getProtocol())) {
                    port = 443;
                }
            }
            HttpHost httpHost = new HttpHost(url.getHost(), port, url.getProtocol());
            Axis2HttpRequest axis2Req = new Axis2HttpRequest(epr, httpHost, msgContext);
            NHttpClientConnection conn = ConnectionPool.getConnection(url.getHost(), port);
            if (conn == null) {
                this.ioReactor.connect((SocketAddress)new InetSocketAddress(url.getHost(), port), null, (Object)axis2Req, this.sessionRequestCallback);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"A new connection established");
                }
            } else {
                ((ClientHandler)this.handler).submitRequest(conn, axis2Req);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"An existing connection reused");
                }
            }
            axis2Req.streamMessageContents();
        }
        catch (MalformedURLException e) {
            this.handleException("Malformed destination EPR : " + epr.getAddress(), e);
        }
        catch (IOException e) {
            this.handleException("IO Error while submiting request message for sending", e);
        }
    }

    private void sendAsyncResponse(MessageContext msgContext) throws AxisFault {
        Map transportHeaders;
        this.removeUnwantedHeaders(msgContext);
        ServerWorker worker = (ServerWorker)msgContext.getProperty("OutTransportInfo");
        HttpResponse response = worker.getResponse();
        OMOutputFormat format = NhttpUtils.getOMOutputFormat(msgContext);
        MessageFormatter messageFormatter = TransportUtils.getMessageFormatter((MessageContext)msgContext);
        response.setHeader("Content-Type", messageFormatter.getContentType(msgContext, format, msgContext.getSoapAction()));
        if (msgContext.getEnvelope().getBody().hasFault()) {
            response.setStatusCode(500);
        }
        if (Utils.isExplicitlyTrue((MessageContext)msgContext, (String)"SC_ACCEPTED") && msgContext.getProperty("WSRMSequenceId") == null) {
            response.setStatusCode(202);
        }
        if ((transportHeaders = (Map)msgContext.getProperty("TRANSPORT_HEADERS")) != null && !transportHeaders.values().isEmpty()) {
            for (Object header : transportHeaders.keySet()) {
                Object value = transportHeaders.get(header);
                if (value == null || !(header instanceof String) || !(value instanceof String)) continue;
                response.setHeader((String)header, (String)value);
            }
        }
        worker.getServiceHandler().commitResponse(worker.getConn(), response);
        OutputStream out = worker.getOutputStream();
        try {
            if (Utils.isExplicitlyTrue((MessageContext)msgContext, (String)"SC_ACCEPTED") && msgContext.getProperty("WSRMSequenceId") == null) {
                out.write(new byte[0]);
            } else {
                messageFormatter.writeTo(msgContext, format, out, true);
            }
            out.close();
        }
        catch (IOException e) {
            this.handleException("IO Error sending response message", e);
        }
        try {
            worker.getIs().close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
    }

    private void sendUsingOutputStream(MessageContext msgContext) throws AxisFault {
        OMOutputFormat format = NhttpUtils.getOMOutputFormat(msgContext);
        MessageFormatter messageFormatter = TransportUtils.getMessageFormatter((MessageContext)msgContext);
        OutputStream out = (OutputStream)msgContext.getProperty("TRANSPORT_OUT");
        if (msgContext.isServerSide()) {
            OutTransportInfo transportInfo = (OutTransportInfo)msgContext.getProperty("OutTransportInfo");
            if (transportInfo != null) {
                transportInfo.setContentType(messageFormatter.getContentType(msgContext, format, msgContext.getSoapAction()));
            } else {
                throw new AxisFault("OutTransportInfo has not been set");
            }
        }
        try {
            messageFormatter.writeTo(msgContext, format, out, true);
            out.close();
        }
        catch (IOException e) {
            this.handleException("IO Error sending response message", e);
        }
    }

    public void cleanup(MessageContext msgContext) throws AxisFault {
    }

    public void stop() {
        try {
            this.ioReactor.shutdown();
            log.info((Object)"Sender shut down");
        }
        catch (IOException e) {
            log.warn((Object)"Error shutting down IOReactor", (Throwable)e);
        }
    }

    private static SessionRequestCallback getSessionRequestCallback() {
        return new SessionRequestCallback(){

            public void completed(SessionRequest request) {
            }

            public void failed(SessionRequest request) {
                this.handleError(request, false);
            }

            public void timeout(SessionRequest request) {
                this.handleError(request, true);
                request.cancel();
            }

            public void cancelled(SessionRequest sessionRequest) {
            }

            private void handleError(SessionRequest request, boolean isTimeout) {
                if (request.getAttachment() != null && request.getAttachment() instanceof Axis2HttpRequest) {
                    Axis2HttpRequest axis2Request = (Axis2HttpRequest)request.getAttachment();
                    MessageContext mc = axis2Request.getMsgContext();
                    MessageReceiver mr = mc.getAxisOperation().getMessageReceiver();
                    try {
                        AxisFault axisFault;
                        if (isTimeout) {
                            axisFault = new AxisFault("The connection timed out");
                        } else {
                            IOException exception = request.getException();
                            axisFault = new AxisFault(exception.toString(), (Throwable)exception);
                        }
                        MessageContext nioFaultMessageContext = MessageContextBuilder.createFaultMessageContext((MessageContext)mc, (Throwable)axisFault);
                        nioFaultMessageContext.setProperty("sending_fault", (Object)Boolean.TRUE);
                        mr.receive(nioFaultMessageContext);
                    }
                    catch (AxisFault af) {
                        log.error((Object)"Unable to report back failure to the message receiver", (Throwable)af);
                    }
                }
            }
        };
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    private void handleException(String msg) throws AxisFault {
        log.error((Object)msg);
        throw new AxisFault(msg);
    }
}

