/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.mail;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.activation.CommandMap;
import javax.activation.DataHandler;
import javax.activation.MailcapCommandMap;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.base.AbstractTransportSender;
import org.apache.synapse.transport.base.BaseConstants;
import org.apache.synapse.transport.base.BaseTransportException;
import org.apache.synapse.transport.base.BaseUtils;
import org.apache.synapse.transport.mail.MailOutTransportInfo;
import org.apache.synapse.transport.mail.WSMimeMessage;

public class MailTransportSender
extends AbstractTransportSender {
    private String smtpUsername = null;
    private String smtpPassword = null;
    private InternetAddress smtpFromAddress = null;
    private InternetAddress[] smtpBccAddresses = null;
    private String defaultMailFormat = "Text";
    private Session session = null;

    public MailTransportSender() {
        this.log = LogFactory.getLog(MailTransportSender.class);
    }

    public void init(ConfigurationContext cfgCtx, TransportOutDescription transportOut) throws AxisFault {
        this.setTransportName("mailto");
        super.init(cfgCtx, transportOut);
        Properties props = new Properties();
        ArrayList params = transportOut.getParameters();
        for (Parameter p : params) {
            props.put(p.getName(), p.getValue());
        }
        if (props.containsKey("mail.smtp.from")) {
            try {
                this.smtpFromAddress = new InternetAddress((String)props.get("mail.smtp.from"));
            }
            catch (AddressException e) {
                this.handleException("Invalid default 'From' address : " + props.get("mail.smtp.from"), (Exception)((Object)e));
            }
        }
        if (props.containsKey("transport.mail.SMTPBccAddresses")) {
            try {
                this.smtpBccAddresses = InternetAddress.parse((String)((String)props.get("transport.mail.SMTPBccAddresses")));
            }
            catch (AddressException e) {
                this.handleException("Invalid default 'Bcc' address : " + props.get("transport.mail.SMTPBccAddresses"), (Exception)((Object)e));
            }
        }
        if (props.containsKey("transport.mail.Format")) {
            this.defaultMailFormat = (String)props.get("transport.mail.Format");
        }
        this.smtpUsername = (String)props.get("mail.smtp.user");
        this.smtpPassword = (String)props.get("mail.smtp.password");
        this.session = this.smtpUsername != null && this.smtpPassword != null ? Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(MailTransportSender.this.smtpUsername, MailTransportSender.this.smtpPassword);
            }
        }) : Session.getInstance((Properties)props, null);
        MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mc.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
        mc.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
        mc.addMailcap("application/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
        mc.addMailcap("application/soap+xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
        mc.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
        mc.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed");
        mc.addMailcap("message/rfc822;; x-java-content-handler=com.sun.mail.handlers.message_rfc822");
        CommandMap.setDefaultCommandMap((CommandMap)mc);
        this.session.setDebug(this.log.isTraceEnabled());
    }

    public void sendMessage(MessageContext msgCtx, String targetAddress, OutTransportInfo outTransportInfo) throws AxisFault {
        MailOutTransportInfo mailOutInfo = null;
        if (targetAddress != null) {
            if (targetAddress.startsWith("mailto")) {
                targetAddress = targetAddress.substring("mailto".length() + 1);
            }
            if (msgCtx.getReplyTo() != null && !"http://www.w3.org/2005/08/addressing/none".equals(msgCtx.getReplyTo().getAddress()) && !"http://www.w3.org/2005/08/addressing/anonymous".equals(msgCtx.getReplyTo().getAddress())) {
                String replyTo = msgCtx.getReplyTo().getAddress();
                if (replyTo.startsWith("mailto")) {
                    replyTo = replyTo.substring("mailto".length() + 1);
                }
                try {
                    mailOutInfo = new MailOutTransportInfo(new InternetAddress(replyTo));
                }
                catch (AddressException e) {
                    this.handleException("Invalid reply address/es : " + replyTo, (Exception)((Object)e));
                }
            } else {
                mailOutInfo = new MailOutTransportInfo(this.smtpFromAddress);
            }
            try {
                mailOutInfo.setTargetAddresses(InternetAddress.parse((String)targetAddress));
            }
            catch (AddressException e) {
                this.handleException("Invalid target address/es : " + targetAddress, (Exception)((Object)e));
            }
        } else if (outTransportInfo != null && outTransportInfo instanceof MailOutTransportInfo) {
            mailOutInfo = (MailOutTransportInfo)outTransportInfo;
        }
        if (mailOutInfo != null) {
            try {
                this.sendMail(mailOutInfo, msgCtx);
            }
            catch (MessagingException e) {
                this.handleException("Error generating mail message", (Exception)((Object)e));
            }
            catch (IOException e) {
                this.handleException("Error generating mail message", e);
            }
        } else {
            this.handleException("Unable to determine out transport information to send message");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMail(MailOutTransportInfo outInfo, MessageContext msgContext) throws AxisFault, MessagingException, IOException {
        OMOutputFormat format = BaseUtils.getOMOutputFormat(msgContext);
        MessageFormatter messageFormatter = null;
        try {
            messageFormatter = TransportUtils.getMessageFormatter((MessageContext)msgContext);
        }
        catch (AxisFault axisFault) {
            throw new BaseTransportException("Unable to get the message formatter to use");
        }
        WSMimeMessage message = new WSMimeMessage(this.session);
        Map trpHeaders = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
        if (outInfo.getTargetAddresses() != null && outInfo.getFromAddress() != null) {
            message.setFrom((Address)outInfo.getFromAddress());
            message.setReplyTo(new Address[]{outInfo.getFromAddress()});
        } else if (trpHeaders != null && trpHeaders.containsKey("From")) {
            message.setFrom((Address)new InternetAddress((String)trpHeaders.get("From")));
            message.setReplyTo((Address[])InternetAddress.parse((String)((String)trpHeaders.get("From"))));
        } else if (this.smtpFromAddress != null) {
            message.setFrom((Address)this.smtpFromAddress);
            message.setReplyTo(new Address[]{this.smtpFromAddress});
        } else {
            this.handleException("From address for outgoing message cannot be determined");
        }
        if (trpHeaders != null && trpHeaders.containsKey("To")) {
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)((String)trpHeaders.get("To"))));
        } else if (outInfo.getTargetAddresses() != null) {
            message.setRecipients(Message.RecipientType.TO, (Address[])outInfo.getTargetAddresses());
        } else {
            this.handleException("To address for outgoing message cannot be determined");
        }
        if (trpHeaders != null && trpHeaders.containsKey("Cc")) {
            message.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)((String)trpHeaders.get("Cc"))));
        } else if (outInfo.getTargetAddresses() != null) {
            message.setRecipients(Message.RecipientType.CC, (Address[])outInfo.getCcAddresses());
        }
        InternetAddress[] trpBccArr = null;
        if (trpHeaders != null && trpHeaders.containsKey("Bcc")) {
            trpBccArr = InternetAddress.parse((String)((String)trpHeaders.get("Bcc")));
        }
        InternetAddress[] mergedBcc = new InternetAddress[(trpBccArr != null ? trpBccArr.length : 0) + (this.smtpBccAddresses != null ? this.smtpBccAddresses.length : 0)];
        if (trpBccArr != null) {
            System.arraycopy(trpBccArr, 0, mergedBcc, 0, trpBccArr.length);
        }
        if (this.smtpBccAddresses != null) {
            System.arraycopy(this.smtpBccAddresses, 0, mergedBcc, mergedBcc.length, this.smtpBccAddresses.length);
        }
        if (mergedBcc != null) {
            message.setRecipients(Message.RecipientType.BCC, (Address[])mergedBcc);
        }
        if (trpHeaders != null && trpHeaders.containsKey("Subject")) {
            message.setSubject((String)trpHeaders.get("Subject"));
        } else if (outInfo.getSubject() != null) {
            message.setSubject(outInfo.getSubject());
        } else {
            message.setSubject("SOAPAction: " + msgContext.getSoapAction());
        }
        if (msgContext.getMessageID() != null) {
            message.setHeader("Message-ID", msgContext.getMessageID());
            message.setHeader("X-Message-ID", msgContext.getMessageID());
        }
        if (outInfo.getRequestMessageID() != null) {
            message.setHeader("In-Reply-To", outInfo.getRequestMessageID());
            message.setHeader("References", outInfo.getRequestMessageID());
        } else {
            if (trpHeaders != null && trpHeaders.containsKey("In-Reply-To")) {
                message.setHeader("In-Reply-To", (String)trpHeaders.get("In-Reply-To"));
            }
            if (trpHeaders != null && trpHeaders.containsKey("References")) {
                message.setHeader("References", (String)trpHeaders.get("References"));
            }
        }
        message.setSentDate(new Date());
        message.setHeader("SOAPAction", msgContext.getSoapAction());
        ByteArrayOutputStream baos = null;
        String contentType = messageFormatter.getContentType(msgContext, format, msgContext.getSoapAction());
        DataHandler dataHandler = null;
        MimeMultipart mimeMultiPart = null;
        OMElement firstChild = msgContext.getEnvelope().getBody().getFirstElement();
        if (firstChild != null) {
            if (BaseConstants.DEFAULT_BINARY_WRAPPER.equals(firstChild.getQName())) {
                Object dh;
                baos = new ByteArrayOutputStream();
                OMNode omNode = firstChild.getFirstOMChild();
                if (omNode != null && omNode instanceof OMText && (dh = ((OMText)omNode).getDataHandler()) != null && dh instanceof DataHandler) {
                    dataHandler = (DataHandler)dh;
                }
            } else if (BaseConstants.DEFAULT_TEXT_WRAPPER.equals(firstChild.getQName())) {
                if (firstChild instanceof OMSourcedElementImpl) {
                    baos = new ByteArrayOutputStream();
                    try {
                        firstChild.serializeAndConsume((OutputStream)baos);
                    }
                    catch (XMLStreamException e) {
                        this.handleException("Error serializing 'text' payload from OMSourcedElement", e);
                    }
                    dataHandler = new DataHandler((Object)new String(baos.toByteArray(), format.getCharSetEncoding()), "text/plain");
                } else {
                    dataHandler = new DataHandler((Object)firstChild.getText(), "text/plain");
                }
            } else {
                baos = new ByteArrayOutputStream();
                messageFormatter.writeTo(msgContext, format, (OutputStream)baos, true);
                dataHandler = new DataHandler((Object)new String(baos.toByteArray(), format.getCharSetEncoding()), contentType);
                String mFormat = (String)msgContext.getProperty("transport.mail.Format");
                if (mFormat == null) {
                    mFormat = this.defaultMailFormat;
                }
                if ("Multipart".equals(mFormat)) {
                    mimeMultiPart = new MimeMultipart();
                    MimeBodyPart mimeBodyPart1 = new MimeBodyPart();
                    mimeBodyPart1.setContent((Object)"Web Service Message Attached", "text/plain");
                    MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
                    mimeBodyPart2.setDataHandler(dataHandler);
                    mimeBodyPart2.setHeader("SOAPAction", msgContext.getSoapAction());
                    mimeMultiPart.addBodyPart((BodyPart)mimeBodyPart1);
                    mimeMultiPart.addBodyPart((BodyPart)mimeBodyPart2);
                } else {
                    message.setHeader("SOAPAction", msgContext.getSoapAction());
                }
            }
        }
        try {
            if (mimeMultiPart == null) {
                message.setDataHandler(dataHandler);
            } else {
                message.setContent((Multipart)mimeMultiPart);
            }
            Transport.send((Message)message);
        }
        catch (MessagingException e) {
            this.handleException("Error creating mail message or sending it to the configured server", (Exception)((Object)e));
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (IOException ignore) {}
        }
    }
}

