/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.mail;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.synapse.transport.base.AbstractPollingTransportListener;
import org.apache.synapse.transport.base.BaseConstants;
import org.apache.synapse.transport.base.BaseUtils;
import org.apache.synapse.transport.mail.MailConstants;
import org.apache.synapse.transport.mail.MailOutTransportInfo;
import org.apache.synapse.transport.mail.MailUtils;
import org.apache.synapse.transport.mail.PollTableEntry;

public class MailTransportListener
extends AbstractPollingTransportListener {
    public static final String DELETE = "DELETE";
    public static final String MOVE = "MOVE";
    private final List pollTable = new ArrayList();

    public void init(ConfigurationContext cfgCtx, TransportInDescription trpInDesc) throws AxisFault {
        this.setTransportName("mailto");
        super.init(cfgCtx, trpInDesc);
    }

    public void onPoll() {
        for (PollTableEntry entry : this.pollTable) {
            long startTime = System.currentTimeMillis();
            if (startTime <= entry.getNextPollTime()) continue;
            this.checkMail(entry, entry.getEmailAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMail(PollTableEntry entry, InternetAddress emailAddress) {
        block38: {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Checking mail for account : " + emailAddress));
            }
            boolean connected = false;
            int retryCount = 0;
            int maxRetryCount = entry.getMaxRetryCount();
            long reconnectionTimeout = entry.getReconnectTimeout();
            Store store = null;
            while (!connected) {
                block37: {
                    try {
                        ++retryCount;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Attempting to connect to POP3/IMAP server for : " + entry.getEmailAddress() + " using " + entry.getProperties()));
                        }
                        Session session = Session.getInstance((Properties)entry.getProperties(), null);
                        session.setDebug(this.log.isTraceEnabled());
                        store = session.getStore(entry.getProtocol());
                        if (entry.getUserName() != null && entry.getPassword() != null) {
                            store.connect(entry.getUserName(), entry.getPassword());
                        } else {
                            this.handleException("Unable to locate username and password for mail login", null);
                        }
                        connected = store.isConnected();
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Error connecting to mail server for address : " + emailAddress), (Throwable)e);
                        if (maxRetryCount > retryCount) break block37;
                        this.processFailure("Error connecting to mail server for address : " + emailAddress + " :: " + e.getMessage(), e, entry);
                        return;
                    }
                }
                if (connected) continue;
                try {
                    this.log.warn((Object)("Connection to mail server for account : " + entry.getEmailAddress() + " failed. Retrying in : " + reconnectionTimeout / 1000L + " seconds"));
                    Thread.sleep(reconnectionTimeout);
                }
                catch (InterruptedException ignore) {}
            }
            if (connected) {
                Folder folder = null;
                try {
                    folder = entry.getFolder() != null ? store.getFolder(entry.getFolder()) : store.getFolder(MailConstants.DEFAULT_FOLDER);
                    if (folder == null) {
                        folder = store.getDefaultFolder();
                    }
                    if (folder == null) {
                        this.processFailure("Unable to access mail folder", null, entry);
                        break block38;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Connecting to folder : " + folder.getName() + " of email account : " + emailAddress));
                    }
                    folder.open(2);
                    int total = folder.getMessageCount();
                    Message[] messages = folder.getMessages();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)(messages.length + " messgaes in folder : " + folder));
                    }
                    for (int i = 0; i < total; ++i) {
                        if (messages[i].isSet(Flags.Flag.SEEN)) {
                            if (!this.log.isDebugEnabled()) continue;
                            this.log.debug((Object)("Skipping message # : " + i + " : " + messages[i].getSubject() + " - already marked SEEN"));
                            continue;
                        }
                        if (messages[i].isSet(Flags.Flag.DELETED)) {
                            if (!this.log.isDebugEnabled()) continue;
                            this.log.debug((Object)("Skipping message # : " + i + " : " + messages[i].getSubject() + " - already marked DELETED"));
                            continue;
                        }
                        entry.setLastPollState(3);
                        try {
                            this.processMail(messages[i], entry);
                            entry.setLastPollState(0);
                        }
                        catch (Exception e) {
                            entry.setLastPollState(2);
                        }
                        this.moveOrDeleteAfterProcessing(entry, store, folder, messages[i]);
                    }
                }
                catch (MessagingException me) {
                    this.processFailure("Error checking mail for account : " + emailAddress + " :: " + me.getMessage(), (Exception)((Object)me), entry);
                }
                finally {
                    try {
                        folder.close(true);
                    }
                    catch (MessagingException e) {
                        this.processFailure("Error closing mail folder : " + folder + " for account : " + emailAddress, (Exception)((Object)e), entry);
                    }
                    if (store != null) {
                        try {
                            store.close();
                        }
                        catch (MessagingException e) {
                            this.log.warn((Object)("Error closing mail store for account : " + emailAddress + " :: " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    private void processMail(Message message, PollTableEntry entry) throws MessagingException, IOException {
        InternetAddress[] fromAddress;
        String contentType;
        HashMap<String, String> trpHeaders = new HashMap<String, String>();
        try {
            Enumeration e = message.getAllHeaders();
            while (e.hasMoreElements()) {
                Header h = (Header)e.nextElement();
                if (!entry.retainHeader(h.getName())) continue;
                trpHeaders.put(h.getName(), h.getValue());
            }
        }
        catch (MessagingException ignore) {
            // empty catch block
        }
        if (!BaseUtils.isValid(contentType = entry.getContentType())) {
            Object content = message.getContent();
            if (content instanceof Multipart) {
                contentType = message.getContentType();
            } else if (content instanceof String) {
                contentType = message.getContentType();
            } else if (content instanceof InputStream) {
                contentType = "application/binary";
            }
        }
        if (contentType == null) {
            this.processFailure("Unable to determine Content-type for message : " + message.getMessageNumber() + " :: " + message.getSubject(), null, entry);
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Processing message as Content-Type : " + contentType));
        }
        MessageContext msgContext = this.createMessageContext();
        AxisService service = this.cfgCtx.getAxisConfiguration().getService(entry.getServiceName());
        msgContext.setAxisService(service);
        Parameter operationParam = service.getParameter("Operation");
        QName operationQName = operationParam != null ? BaseUtils.getQNameFromString(operationParam.getValue()) : BaseConstants.DEFAULT_OPERATION;
        AxisOperation operation = service.getOperation(operationQName);
        if (operation != null) {
            msgContext.setAxisOperation(operation);
            msgContext.setSoapAction("urn:" + operation.getName().getLocalPart());
        }
        if ((fromAddress = (InternetAddress[])message.getReplyTo()) == null) {
            fromAddress = (InternetAddress[])message.getFrom();
        }
        MailOutTransportInfo outInfo = new MailOutTransportInfo(fromAddress[0]);
        if (message.getReplyTo() != null) {
            outInfo.setTargetAddresses((InternetAddress[])message.getReplyTo());
        } else if (message.getFrom() != null) {
            outInfo.setTargetAddresses((InternetAddress[])message.getFrom());
        } else {
            Parameter param = service.getParameter("transport.mail.ReplyAddress");
            if (param != null && param.getValue() != null) {
                outInfo.setTargetAddresses(InternetAddress.parse((String)((String)param.getValue())));
            }
        }
        if (message.getRecipients(Message.RecipientType.CC) != null) {
            outInfo.setCcAddresses((InternetAddress[])message.getRecipients(Message.RecipientType.CC));
        }
        if (message.getSubject() != null) {
            outInfo.setSubject("Re: " + message.getSubject());
        }
        if (message.getHeader("X-Message-ID") != null) {
            outInfo.setRequestMessageID(message.getHeader("X-Message-ID")[0]);
        } else if (message instanceof MimeMessage && ((MimeMessage)message).getMessageID() != null) {
            outInfo.setRequestMessageID(((MimeMessage)message).getMessageID());
        }
        msgContext.setProperty("OutTransportInfo", (Object)outInfo);
        if (outInfo.getFromAddress() != null) {
            msgContext.setFrom(new EndpointReference("mailto:" + outInfo.getFromAddress().getAddress()));
        }
        msgContext.setMessageID(outInfo.getRequestMessageID());
        MailUtils.getInstace().setSOAPEnvelope(message, msgContext, contentType);
        String soapAction = (String)trpHeaders.get("SOAPAction");
        if (soapAction == null && message.getSubject() != null && message.getSubject().startsWith("SOAPAction") && (soapAction = message.getSubject().substring("SOAPAction".length())).startsWith(":")) {
            soapAction = soapAction.substring(1).trim();
        }
        this.handleIncomingMessage(msgContext, trpHeaders, soapAction, contentType);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Processed message : " + message.getMessageNumber() + " :: " + message.getSubject()));
        }
    }

    private void moveOrDeleteAfterProcessing(PollTableEntry entry, Store store, Folder folder, Message message) {
        String moveToFolder = null;
        try {
            switch (entry.getLastPollState()) {
                case 0: {
                    if (entry.getActionAfterProcess() != 1) break;
                    moveToFolder = entry.getMoveAfterProcess();
                    break;
                }
                case 2: {
                    if (entry.getActionAfterProcess() != 1) break;
                    moveToFolder = entry.getMoveAfterFailure();
                    break;
                }
                case 3: {
                    return;
                }
            }
            if (moveToFolder != null) {
                Folder dFolder;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Moving processed email to folder :" + moveToFolder));
                }
                if (!(dFolder = store.getFolder(moveToFolder)).exists()) {
                    dFolder.create(1);
                }
                folder.copyMessages(new Message[]{message}, dFolder);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Deleting email :" + message.getMessageNumber()));
            }
            message.setFlag(Flags.Flag.DELETED, true);
        }
        catch (MessagingException e) {
            this.log.error((Object)("Error deleting or resolving folder to move after processing : " + moveToFolder), (Throwable)e);
        }
    }

    private void processFailure(String msg, Exception e, PollTableEntry entry) {
        if (e == null) {
            this.log.error((Object)msg);
        } else {
            this.log.error((Object)msg, (Throwable)e);
        }
        long now = System.currentTimeMillis();
        entry.setLastPollState(2);
        entry.setLastPollTime(now);
        entry.setNextPollTime(now + entry.getPollInterval());
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        for (PollTableEntry entry : this.pollTable) {
            if (!entry.getServiceName().equals(serviceName)) continue;
            return new EndpointReference[]{new EndpointReference("mailto:" + entry.getEmailAddress())};
        }
        return null;
    }

    protected void startListeningForService(AxisService service) {
        Parameter param = service.getParameter("transport.PollInterval");
        long pollInterval = 300000L;
        if (param != null && param.getValue() instanceof String) {
            try {
                pollInterval = Integer.parseInt(param.getValue().toString());
            }
            catch (NumberFormatException e) {
                this.log.error((Object)("Invalid poll interval : " + param.getValue() + " for service : " + service.getName() + " default to : " + 300 + "sec"), (Throwable)e);
            }
        }
        PollTableEntry entry = new PollTableEntry();
        try {
            String strReconnectTimeout;
            entry.setEmailAddress(BaseUtils.getRequiredServiceParam(service, "transport.mail.Address"));
            ArrayList params = service.getParameters();
            for (Parameter p : params) {
                if (p.getName().startsWith("mail.")) {
                    entry.addProperty(p.getName(), (String)p.getValue());
                }
                if ("mail.pop3.user".equals(p.getName()) || "mail.imap.user".equals(p.getName())) {
                    entry.setUserName((String)p.getValue());
                }
                if ("mail.pop3.password".equals(p.getName()) || "mail.imap.password".equals(p.getName())) {
                    entry.setPassword((String)p.getValue());
                }
                if (!"transport.mail.Protocol".equals(p.getName())) continue;
                entry.setProtocol((String)p.getValue());
            }
            entry.setContentType(BaseUtils.getOptionalServiceParam(service, "transport.mail.ContentType"));
            entry.setReplyAddress(BaseUtils.getOptionalServiceParam(service, "transport.mail.ReplyAddress"));
            entry.addPreserveHeaders(BaseUtils.getOptionalServiceParam(service, "transport.mail.PreserveHeaders"));
            entry.addRemoveHeaders(BaseUtils.getOptionalServiceParam(service, "transport.mail.RemoveHeaders"));
            String option = BaseUtils.getOptionalServiceParam(service, "transport.mail.ActionAfterProcess");
            entry.setActionAfterProcess(MOVE.equals(option) ? 1 : 0);
            option = BaseUtils.getOptionalServiceParam(service, "transport.mail.ActionAfterFailure");
            entry.setActionAfterFailure(MOVE.equals(option) ? 1 : 0);
            String moveFolderAfterProcess = BaseUtils.getOptionalServiceParam(service, "transport.mail.MoveAfterProcess");
            entry.setMoveAfterProcess(moveFolderAfterProcess);
            String modeFolderAfterFailure = BaseUtils.getOptionalServiceParam(service, "transport.mail.MoveAfterFailure");
            entry.setMoveAfterFailure(modeFolderAfterFailure);
            String strMaxRetryCount = BaseUtils.getOptionalServiceParam(service, "transport.mail.MaxRetryCount");
            if (strMaxRetryCount != null) {
                entry.setMaxRetryCount(Integer.parseInt(strMaxRetryCount));
            }
            if ((strReconnectTimeout = BaseUtils.getOptionalServiceParam(service, "transport.mail.ReconnectTimeout")) != null) {
                entry.setReconnectTimeout(Integer.parseInt(strReconnectTimeout) * 1000);
            }
            entry.setServiceName(service.getName());
            this.schedulePoll(service, pollInterval);
            this.pollTable.add(entry);
        }
        catch (AxisFault axisFault) {
            String msg = "Error configuring the Mail transport for Service : " + service.getName() + " :: " + axisFault.getMessage();
            this.log.warn((Object)msg);
        }
        catch (AddressException e) {
            String msg = "Error configuring the Mail transport for Service :  Invalid email address specified by 'transport.mail.Address'parameter for service : " + service.getName() + " :: " + e.getMessage();
            this.log.warn((Object)msg);
        }
    }

    protected void stopListeningForService(AxisService service) {
        for (PollTableEntry entry : this.pollTable) {
            if (!service.getName().equals(entry.getServiceName())) continue;
            this.cancelPoll(service);
            this.pollTable.remove(entry);
        }
    }
}

