/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.base.threads;

import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.base.threads.WorkerPool;

public class NativeWorkerPool
implements WorkerPool {
    private static final Log log = LogFactory.getLog(NativeWorkerPool.class);
    Executor nativeExecutor = null;
    Executor executor = null;

    public NativeWorkerPool(int core, int max, int keepAlive, int queueLength, String threadGroupName, String threadGroupId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Using native util.concurrent package..");
        }
        this.executor = new ThreadPoolExecutor(core, max, (long)keepAlive, TimeUnit.SECONDS, queueLength == -1 ? new LinkedBlockingQueue<Runnable>() : new LinkedBlockingQueue(queueLength), new BackportThreadFactory(new ThreadGroup(threadGroupName), threadGroupId));
    }

    public void execute(Runnable task) {
        this.executor.execute(task);
    }

    public class BackportThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger count = new AtomicInteger(1);
        final String namePrefix;

        public BackportThreadFactory(ThreadGroup group, String namePrefix) {
            this.group = group;
            this.namePrefix = namePrefix;
        }

        public Thread newThread(Runnable runnable) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.namePrefix);
            buffer.append('-');
            buffer.append(this.count.getAndIncrement());
            Thread t = new Thread(this.group, runnable, buffer.toString(), 0L);
            t.setDaemon(false);
            t.setPriority(5);
            return t;
        }
    }
}

