/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.base;

import java.util.Map;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;

public abstract class AbstractTransportSender
extends AbstractHandler
implements TransportSender {
    protected Log log = null;
    protected String transportName = null;
    protected ConfigurationContext cfgCtx = null;
    protected AxisEngine engine = null;
    private TransportInDescription transportIn = null;
    private TransportOutDescription transportOut = null;
    protected boolean started = false;

    public void init(ConfigurationContext cfgCtx, TransportOutDescription transportOut) throws AxisFault {
        this.cfgCtx = cfgCtx;
        this.engine = new AxisEngine(cfgCtx);
        this.transportIn = cfgCtx.getAxisConfiguration().getTransportIn(this.transportName);
        this.transportOut = transportOut;
    }

    public void stop() {
        if (this.started) {
            this.started = false;
        }
    }

    public void cleanup(MessageContext msgContext) throws AxisFault {
    }

    public abstract void sendMessage(MessageContext var1, String var2, OutTransportInfo var3) throws AxisFault;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        String targetAddress = (String)msgContext.getProperty("TransportURL");
        if (targetAddress != null) {
            this.sendMessage(msgContext, targetAddress, null);
            return Handler.InvocationResponse.CONTINUE;
        } else if (msgContext.getTo() != null && !msgContext.getTo().hasAnonymousAddress()) {
            targetAddress = msgContext.getTo().getAddress();
            if (msgContext.getTo().hasNoneAddress()) return Handler.InvocationResponse.CONTINUE;
            this.sendMessage(msgContext, targetAddress, null);
            return Handler.InvocationResponse.CONTINUE;
        } else {
            if (!msgContext.isServerSide()) return Handler.InvocationResponse.CONTINUE;
            this.sendMessage(msgContext, null, (OutTransportInfo)msgContext.getProperty("OutTransportInfo"));
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    public void handleIncomingMessage(MessageContext msgCtx, Map trpHeaders, String soapAction, String contentType) {
        if (soapAction != null) {
            msgCtx.setSoapAction(soapAction);
        }
        msgCtx.setProperty("TRANSPORT_HEADERS", (Object)trpHeaders);
        try {
            try {
                AxisEngine.receive((MessageContext)msgCtx);
            }
            catch (AxisFault e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Error receiving message", (Throwable)e);
                }
                if (msgCtx.isServerSide()) {
                    AxisEngine.sendFault((MessageContext)MessageContextBuilder.createFaultMessageContext((MessageContext)msgCtx, (Throwable)e));
                }
            }
        }
        catch (AxisFault axisFault) {
            this.logException("Error processing response message", (Exception)((Object)axisFault));
        }
    }

    public MessageContext createResponseMessageContext(MessageContext outMsgCtx) {
        MessageContext responseMsgCtx = null;
        try {
            responseMsgCtx = outMsgCtx.getOperationContext().getMessageContext("In");
        }
        catch (AxisFault af) {
            this.log.error((Object)"Error getting IN message context from the operation context", (Throwable)af);
        }
        if (responseMsgCtx == null) {
            responseMsgCtx = new MessageContext();
            responseMsgCtx.setOperationContext(outMsgCtx.getOperationContext());
        }
        responseMsgCtx.setIncomingTransportName(this.transportName);
        responseMsgCtx.setTransportOut(this.transportOut);
        responseMsgCtx.setTransportIn(this.transportIn);
        responseMsgCtx.setMessageID(UUIDGenerator.getUUID());
        responseMsgCtx.setDoingREST(outMsgCtx.isDoingREST());
        responseMsgCtx.setProperty("TRANSPORT_IN", outMsgCtx.getProperty("TRANSPORT_IN"));
        responseMsgCtx.setAxisMessage(outMsgCtx.getOperationContext().getAxisOperation().getMessage("In"));
        responseMsgCtx.setTo(null);
        return responseMsgCtx;
    }

    protected boolean waitForSynchronousResponse(MessageContext msgCtx) {
        return msgCtx.getOperationContext() != null && "http://www.w3.org/ns/wsdl/out-in".equals(msgCtx.getOperationContext().getAxisOperation().getMessageExchangePattern());
    }

    public String getTransportName() {
        return this.transportName;
    }

    public void setTransportName(String transportName) {
        this.transportName = transportName;
    }

    protected void handleException(String msg, Exception e) throws AxisFault {
        this.log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    protected void handleException(String msg) throws AxisFault {
        this.log.error((Object)msg);
        throw new AxisFault(msg);
    }

    protected void logException(String msg, Exception e) {
        this.log.error((Object)msg, (Throwable)e);
    }
}

