/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.base;

import java.util.ArrayList;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.engine.AxisObserver;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.base.BaseUtils;
import org.apache.synapse.transport.base.threads.WorkerPool;
import org.apache.synapse.transport.base.threads.WorkerPoolFactory;

public abstract class AbstractTransportListener
implements TransportListener {
    protected Log log = null;
    protected String transportName = null;
    protected ConfigurationContext cfgCtx = null;
    protected AxisEngine engine = null;
    private TransportInDescription transportIn = null;
    private TransportOutDescription transportOut = null;
    protected boolean started = false;
    protected boolean isNonBlocking = false;
    private final AxisObserver axisObserver = new GenericAxisObserver();
    protected WorkerPool workerPool = null;
    protected boolean useAxis2ThreadPool = false;

    protected AbstractTransportListener() {
        this.log = LogFactory.getLog(this.getClass());
    }

    public void init(ConfigurationContext cfgCtx, TransportInDescription transportIn) throws AxisFault {
        this.cfgCtx = cfgCtx;
        this.engine = new AxisEngine(cfgCtx);
        this.transportIn = transportIn;
        this.transportOut = cfgCtx.getAxisConfiguration().getTransportOut(this.transportName);
        if (this.useAxis2ThreadPool) {
            throw new AxisFault("Unsupported thread pool for task execution - Axis2 thread pool");
        }
        this.workerPool = WorkerPoolFactory.getWorkerPool(10, 20, 5, -1, this.transportName + "Server Worker thread group", this.transportName + "-Worker");
        cfgCtx.getAxisConfiguration().addObservers(this.axisObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            if (this.started) {
                try {
                    this.stop();
                }
                catch (AxisFault ignore) {
                    this.log.warn((Object)("Error stopping the transport : " + this.transportName));
                }
            }
        }
        finally {
            this.started = false;
        }
    }

    public void stop() throws AxisFault {
        if (this.started) {
            this.started = false;
            this.cfgCtx.getAxisConfiguration().getObserversList().remove(this.axisObserver);
        }
    }

    public void start() throws AxisFault {
        if (!this.started) {
            this.started = true;
            this.cfgCtx.getAxisConfiguration().addObservers(this.axisObserver);
        }
        for (AxisService service : this.cfgCtx.getAxisConfiguration().getServices().values()) {
            if (!BaseUtils.isUsingTransport(service, this.transportName)) continue;
            this.startListeningForService(service);
        }
    }

    protected abstract void startListeningForService(AxisService var1);

    protected abstract void stopListeningForService(AxisService var1);

    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        return this.getEPRsForService(serviceName, ip)[0];
    }

    public SessionContext getSessionContext(MessageContext messageContext) {
        return null;
    }

    public MessageContext createMessageContext() {
        MessageContext msgCtx = new MessageContext();
        msgCtx.setConfigurationContext(this.cfgCtx);
        msgCtx.setIncomingTransportName(this.transportName);
        msgCtx.setTransportOut(this.transportOut);
        msgCtx.setTransportIn(this.transportIn);
        msgCtx.setServerSide(true);
        msgCtx.setMessageID(UUIDGenerator.getUUID());
        msgCtx.setProperty("transportNonBlocking", (Object)(!this.isNonBlocking ? 1 : 0));
        return msgCtx;
    }

    public void handleIncomingMessage(MessageContext msgCtx, Map trpHeaders, String soapAction, String contentType) throws AxisFault {
        if (soapAction != null) {
            msgCtx.setSoapAction(soapAction);
        }
        msgCtx.setProperty("TRANSPORT_HEADERS", (Object)trpHeaders);
        try {
            try {
                AxisEngine.receive((MessageContext)msgCtx);
            }
            catch (AxisFault e) {
                e.printStackTrace();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Error receiving message", (Throwable)e);
                }
                if (msgCtx.isServerSide()) {
                    AxisEngine.sendFault((MessageContext)MessageContextBuilder.createFaultMessageContext((MessageContext)msgCtx, (Throwable)e));
                }
            }
        }
        catch (AxisFault axisFault) {
            this.logException("Error processing received message", (Exception)((Object)axisFault));
            throw axisFault;
        }
    }

    protected void handleException(String msg, Exception e) throws AxisFault {
        this.log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    protected void logException(String msg, Exception e) {
        this.log.error((Object)msg, (Throwable)e);
    }

    public String getTransportName() {
        return this.transportName;
    }

    public void setTransportName(String transportName) {
        this.transportName = transportName;
    }

    class GenericAxisObserver
    implements AxisObserver {
        GenericAxisObserver() {
        }

        public void init(AxisConfiguration axisConfig) {
        }

        public void serviceUpdate(AxisEvent event, AxisService service) {
            if (service.getName().startsWith("__")) {
                return;
            }
            if (BaseUtils.isUsingTransport(service, AbstractTransportListener.this.transportName)) {
                switch (event.getEventType()) {
                    case 1: {
                        AbstractTransportListener.this.startListeningForService(service);
                        break;
                    }
                    case 0: {
                        AbstractTransportListener.this.stopListeningForService(service);
                        break;
                    }
                    case 3: {
                        AbstractTransportListener.this.startListeningForService(service);
                        break;
                    }
                    case 2: {
                        AbstractTransportListener.this.stopListeningForService(service);
                    }
                }
            }
        }

        public void moduleUpdate(AxisEvent event, AxisModule module) {
        }

        public void addParameter(Parameter param) throws AxisFault {
        }

        public void removeParameter(Parameter param) throws AxisFault {
        }

        public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        }

        public Parameter getParameter(String name) {
            return null;
        }

        public ArrayList getParameters() {
            return null;
        }

        public boolean isParameterLocked(String parameterName) {
            return false;
        }

        public void serviceGroupUpdate(AxisEvent event, AxisServiceGroup serviceGroup) {
        }
    }
}

